/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.path.spi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.babyfish.lang.Nulls;
import org.babyfish.persistence.path.QueryPath;

public final class PathPlanKey
implements Serializable {
    private static final long serialVersionUID = 561460285188124354L;
    private static final PathPlanKey NIL = new PathPlanKey(new SubKey[0]);
    private SubKey[] subKeys;
    private transient int hash;
    private transient String toString;

    private PathPlanKey(SubKey[] subKeys) {
        this.subKeys = subKeys;
    }

    static PathPlanKey of(Map<String, QueryPath[]> queryPathMap) {
        if (queryPathMap.isEmpty()) {
            return null;
        }
        SubKey[] arr = new SubKey[queryPathMap.size()];
        int len = 0;
        for (Map.Entry<String, QueryPath[]> entry : queryPathMap.entrySet()) {
            SubKey subKey = new SubKey(entry.getKey(), entry.getValue());
            if (subKey == null) continue;
            arr[len++] = subKey;
        }
        if (len == 0) {
            return null;
        }
        if (len < arr.length) {
            SubKey[] newArr = new SubKey[len];
            System.arraycopy(newArr, 0, arr, 0, len);
            arr = newArr;
        }
        return new PathPlanKey(arr);
    }

    static PathPlanKey nullToNil(PathPlanKey key) {
        return key == null ? NIL : key;
    }

    static PathPlanKey nilToNull(PathPlanKey key) {
        return key == NIL ? null : key;
    }

    SubKey[] getSubKeys() {
        return this.subKeys;
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash == 0) {
            hash = Arrays.hashCode(this.subKeys);
            if (hash == 0) {
                hash = -1;
            }
            this.hash = hash;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathPlanKey)) {
            return false;
        }
        PathPlanKey other = (PathPlanKey)obj;
        return Arrays.equals(this.subKeys, other.subKeys);
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder builder = new StringBuilder("{ ");
            for (SubKey subKey : this.subKeys) {
                subKey.toString(builder);
            }
            builder.append(" }");
            this.toString = toString = builder.toString();
        }
        return toString;
    }

    static final class SubKey
    implements Serializable {
        private static final long serialVersionUID = 927712794296956126L;
        private String alias;
        private QueryPath[] queryPaths;
        private transient int hash;

        private SubKey(String alias, QueryPath[] queryPaths) {
            this.alias = alias;
            this.queryPaths = (QueryPath[])queryPaths.clone();
        }

        String getAlias() {
            return this.alias;
        }

        QueryPath[] getQueryPaths() {
            return this.queryPaths;
        }

        public int hashCode() {
            int hash = this.hash;
            if (hash == 0) {
                hash = Arrays.hashCode(this.queryPaths);
                if (this.alias != null) {
                    hash = 31 * hash + this.alias.hashCode();
                }
                if (hash == 0) {
                    hash = -1;
                }
                this.hash = hash;
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SubKey)) {
                return false;
            }
            SubKey other = (SubKey)obj;
            return Nulls.equals((Object)this.alias, (Object)other.alias) && Arrays.equals(this.queryPaths, other.queryPaths);
        }

        void toString(StringBuilder builder) {
            builder.append(this.alias).append(" : { ");
            boolean addComma = false;
            for (QueryPath queryPath : this.queryPaths) {
                if (addComma) {
                    builder.append(", ");
                } else {
                    addComma = true;
                }
                builder.append(queryPath);
            }
            builder.append(" }");
        }
    }
}

