/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.path.spi;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.regex.Pattern;
import javax.persistence.criteria.JoinType;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.HashMap;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.TreeMap;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.lang.Nulls;
import org.babyfish.persistence.path.CollectionFetchType;
import org.babyfish.persistence.path.FetchPath;
import org.babyfish.persistence.path.GetterType;
import org.babyfish.persistence.path.QueryPath;
import org.babyfish.persistence.path.SimpleOrderPath;
import org.babyfish.persistence.path.spi.JoinNode;
import org.babyfish.persistence.path.spi.OrderNode;
import org.babyfish.persistence.path.spi.PathPlan;
import org.babyfish.persistence.path.spi.PathPlanKey;
import org.babyfish.persistence.path.spi.SubPlan;
import org.babyfish.util.Joins;
import org.babyfish.util.LazyResource;

public abstract class AbstractPathPlanFactory {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);

    public PathPlan create(PathPlanKey key) {
        return new PathPlanImpl(key);
    }

    protected abstract EntityDelegate getEntityDelegate(String var1);

    private static interface Resource {
        public String methodCanNotReturnNull(Class<?> var1, String var2);

        public String joinPropertyMustBeAssociationProperty(String var1, String var2);

        public String fetchPathCanNotContainId(FetchPath var1, String var2);

        public String fetchPathConOnlyContainOneScalar(FetchPath var1, String var2);

        public String scalarPropertyCanNotBeRequired(FetchPath var1, String var2);

        public String scalarPropertyCanNotBePartial(FetchPath var1, String var2);

        public String requiredOrderPropertyMustBeAssociationProperty(String var1, GetterType var2, String var3);

        public String simpleOrderPathStateAreConflict(String var1, String var2, String var3, String var4);
    }

    private static class JoinNodeTempCreatingData {
        boolean used;
        EntityDelegate entityDelegate;
        Map<String, PropertyDelegate> propertyDelegates;

        private JoinNodeTempCreatingData() {
        }
    }

    private static class OrderNodeImpl
    implements OrderNode {
        private static final Pattern DOT = Pattern.compile("\\.");
        int sequence;
        JoinNodeImpl parentNode;
        private String quanifiedName;
        List<String> names = new ArrayList();
        boolean post;
        boolean desc;

        public OrderNodeImpl(int sequence, JoinNodeImpl parentNode, String quanifiedName, boolean post, boolean desc) {
            this.quanifiedName = quanifiedName;
            if (quanifiedName.indexOf(46) == -1) {
                this.names.add(quanifiedName);
            } else {
                for (String name : DOT.split(quanifiedName)) {
                    this.names.add(name);
                }
            }
            this.sequence = sequence;
            this.parentNode = parentNode;
            this.post = post;
            this.desc = desc;
        }

        @Override
        public int getSequence() {
            return this.sequence;
        }

        @Override
        public JoinNode getParentNode() {
            return this.parentNode;
        }

        @Override
        public String getQuanifiedName() {
            return this.quanifiedName;
        }

        @Override
        public List<String> getNames() {
            return MACollections.unmodifiable(this.names);
        }

        @Override
        public boolean isPost() {
            return this.post;
        }

        @Override
        public boolean isDesc() {
            return this.desc;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.isPost()) {
                builder.append("post order by ");
            } else {
                builder.append("pre order by ");
            }
            builder.append(this.parentNode.getPath()).append('@');
            this.toNameAndTypeString(builder);
            return builder.toString();
        }

        void toStringForJoinNode(StringBuilder builder, int tabCount) {
            for (int i = tabCount - 1; i >= 0; --i) {
                builder.append('\t');
            }
            if (this.isPost()) {
                builder.append("post order by ");
            } else {
                builder.append("pre order by ");
            }
            this.toNameAndTypeString(builder);
            builder.append("\r\n");
        }

        private void toNameAndTypeString(StringBuilder builder) {
            builder.append(this.getQuanifiedName());
            if (this.isDesc()) {
                builder.append(" desc");
            } else {
                builder.append(" asc");
            }
        }
    }

    private static class JoinNodeImpl
    implements JoinNode {
        private String name;
        private JoinType joinType;
        private CollectionFetchType collectionFetchType;
        private JoinNodeImpl parentNode;
        private boolean fetch;
        private XOrderedSet<String> loadedScalarNames;
        private Map<String, JoinNodeImpl> childNodes;
        private Map<String, OrderNodeImpl> orderNodes;
        private boolean collection;
        private boolean containsScalarEagerness;
        private boolean containsInnerJoins;
        private boolean containsCollectionJoins;
        private boolean containsCollectionInnerJoins;
        private boolean containsNoFetchJoins;
        private transient String path;
        private transient String toString;
        private transient JoinNodeTempCreatingData creatingData = new JoinNodeTempCreatingData();

        JoinNodeImpl(EntityDelegate entityDelegate) {
            this.name = "this";
            this.joinType = JoinType.LEFT;
            this.collectionFetchType = CollectionFetchType.ALL;
            this.creatingData.entityDelegate = entityDelegate;
        }

        private JoinNodeImpl(JoinNodeImpl parentNode, String name, JoinType joinType, boolean fetch, CollectionFetchType collectionFetchType) {
            EntityDelegate parentEntityDelegate = parentNode.creatingData.entityDelegate;
            if (name.equals(parentEntityDelegate.getIdPropertyName())) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).joinPropertyMustBeAssociationProperty(parentNode.getPath(), name));
            }
            PropertyDelegate propertyDelegate = parentNode.getPropertyDelegate(name);
            if (!propertyDelegate.isAssociation()) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).joinPropertyMustBeAssociationProperty(parentNode.getPath(), name));
            }
            this.parentNode = parentNode;
            this.name = name;
            this.joinType = joinType;
            this.collectionFetchType = collectionFetchType;
            if (fetch) {
                this.setFetch();
            }
            this.collection = propertyDelegate.isCollection();
            this.creatingData.entityDelegate = propertyDelegate.getAssociatedEntityDelegate();
        }

        void setFetch() {
            JoinNodeImpl joinNodeImpl = this;
            while (joinNodeImpl != null && !joinNodeImpl.fetch) {
                joinNodeImpl.fetch = true;
                joinNodeImpl = joinNodeImpl.parentNode;
            }
            this.setUsed();
        }

        void setUsed() {
            JoinNodeImpl joinNodeImpl = this;
            while (joinNodeImpl != null && !joinNodeImpl.creatingData.used) {
                joinNodeImpl.creatingData.used = true;
                joinNodeImpl = joinNodeImpl.parentNode;
            }
        }

        void addFetchPath(FetchPath fetchPath) {
            JoinNodeImpl joinNodeImpl = this;
            FetchPath.Node node = fetchPath.getFirstNode();
            while (node != null) {
                FetchPath.Node nextNode = node.getNextNode();
                if (node.getName().equals(this.getIdPropertyName())) {
                    throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).fetchPathCanNotContainId(fetchPath, node.getName()));
                }
                PropertyDelegate propertyDelegate = joinNodeImpl.getPropertyDelegate(node.getName());
                if (propertyDelegate.isAssociation()) {
                    joinNodeImpl = joinNodeImpl.addJoinNode(node.getName(), node.getGetterType(), true, node.getCollectionFetchType());
                } else {
                    if (nextNode != null) {
                        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).fetchPathConOnlyContainOneScalar(fetchPath, node.getName()));
                    }
                    if (node.getGetterType() == GetterType.REQUIRED) {
                        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).scalarPropertyCanNotBeRequired(fetchPath, node.getName()));
                    }
                    if (node.getCollectionFetchType() == CollectionFetchType.PARTIAL) {
                        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).scalarPropertyCanNotBePartial(fetchPath, node.getName()));
                    }
                    joinNodeImpl.addLoadedScalarName(node.getName());
                }
                node = nextNode;
            }
        }

        void addSimpleOrderPath(int orderSequence, SimpleOrderPath simpleOrderPath) {
            OrderNodeImpl orderNodeImpl;
            JoinNodeImpl joinNodeImpl = this;
            SimpleOrderPath.Node node = simpleOrderPath.getFirstNode();
            if (node == null) {
                orderNodeImpl = new OrderNodeImpl(orderSequence, joinNodeImpl, joinNodeImpl.getIdPropertyName(), simpleOrderPath.isPost(), simpleOrderPath.isDesc());
            } else {
                while (true) {
                    SimpleOrderPath.Node nextNode = node.getNextNode();
                    boolean isId = node.getName().equals(this.getIdPropertyName());
                    PropertyDelegate propertyDelegate = null;
                    if (!isId) {
                        propertyDelegate = joinNodeImpl.getPropertyDelegate(node.getName());
                    }
                    if (propertyDelegate != null && propertyDelegate.isAssociation()) {
                        if (nextNode == null) {
                            String orderName = node.getName();
                            if (node.getGetterType() == GetterType.REQUIRED || propertyDelegate.isCollection()) {
                                joinNodeImpl = joinNodeImpl.addJoinNode(node.getName(), node.getGetterType(), false, CollectionFetchType.ALL);
                                orderName = joinNodeImpl.getIdPropertyName();
                            }
                            orderNodeImpl = new OrderNodeImpl(orderSequence, joinNodeImpl, orderName, simpleOrderPath.isPost(), simpleOrderPath.isDesc());
                            break;
                        }
                    } else {
                        if (nextNode != null) {
                            StringBuilder quanifiedNameBuilder = new StringBuilder();
                            while (node != null) {
                                if (node.getGetterType() == GetterType.REQUIRED) {
                                    throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).requiredOrderPropertyMustBeAssociationProperty(joinNodeImpl.getPath() + "." + quanifiedNameBuilder.toString(), GetterType.REQUIRED, node.getName()));
                                }
                                if (quanifiedNameBuilder.length() != 0) {
                                    quanifiedNameBuilder.append('.');
                                }
                                quanifiedNameBuilder.append(node.getName());
                                node = node.getNextNode();
                            }
                            orderNodeImpl = new OrderNodeImpl(orderSequence, joinNodeImpl, quanifiedNameBuilder.toString(), simpleOrderPath.isPost(), simpleOrderPath.isDesc());
                            break;
                        }
                        if (node.getGetterType() == GetterType.REQUIRED) {
                            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).requiredOrderPropertyMustBeAssociationProperty(joinNodeImpl.getPath(), GetterType.REQUIRED, node.getName()));
                        }
                        if (joinNodeImpl.parentNode != null && !joinNodeImpl.collection && node.getGetterType() == GetterType.OPTIONAL && node.getName().equals(joinNodeImpl.getIdPropertyName())) {
                            orderNodeImpl = new OrderNodeImpl(orderSequence, joinNodeImpl.parentNode, joinNodeImpl.name, simpleOrderPath.isPost(), simpleOrderPath.isDesc());
                            joinNodeImpl = joinNodeImpl.parentNode;
                            break;
                        }
                        orderNodeImpl = new OrderNodeImpl(orderSequence, joinNodeImpl, node.getName(), simpleOrderPath.isPost(), simpleOrderPath.isDesc());
                        break;
                    }
                    joinNodeImpl = joinNodeImpl.addJoinNode(node.getName(), node.getGetterType(), false, CollectionFetchType.ALL);
                    node = nextNode;
                }
            }
            LinkedHashMap orderNodes = joinNodeImpl.orderNodes;
            if (orderNodes == null) {
                joinNodeImpl.orderNodes = orderNodes = new LinkedHashMap();
            } else {
                OrderNodeImpl existingOrderNode = orderNodes.get(orderNodeImpl.getQuanifiedName());
                if (existingOrderNode != null) {
                    if (existingOrderNode.post != orderNodeImpl.post) {
                        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).simpleOrderPathStateAreConflict(existingOrderNode.getParentNode().getPath() + '.' + existingOrderNode.getQuanifiedName(), existingOrderNode.isPost() ? "post" : "pre", orderNodeImpl.getParentNode().getPath() + '.' + orderNodeImpl.getQuanifiedName(), orderNodeImpl.isPost() ? "post" : "pre"));
                    }
                    if (existingOrderNode.desc != orderNodeImpl.desc) {
                        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).simpleOrderPathStateAreConflict(existingOrderNode.getParentNode().getPath() + '.' + existingOrderNode.getQuanifiedName(), existingOrderNode.isPost() ? "desc" : "asc", orderNodeImpl.getParentNode().getPath() + '.' + orderNodeImpl.getQuanifiedName(), orderNodeImpl.isPost() ? "desc" : "asc"));
                    }
                    orderNodeImpl = null;
                }
            }
            if (orderNodeImpl != null) {
                orderNodes.put(orderNodeImpl.getQuanifiedName(), orderNodeImpl);
            }
        }

        private JoinNodeImpl addJoinNode(String name, GetterType getterType, boolean fetch, CollectionFetchType collectionFetchType) {
            JoinNodeImpl childJoinNodeImpl = null;
            LinkedHashMap childNodes = this.childNodes;
            if (childNodes != null && (childJoinNodeImpl = childNodes.get(name)) != null) {
                childJoinNodeImpl.setFetch();
                if (getterType == GetterType.REQUIRED) {
                    childJoinNodeImpl.joinType = JoinType.INNER;
                }
                if (collectionFetchType == CollectionFetchType.PARTIAL) {
                    childJoinNodeImpl.collectionFetchType = CollectionFetchType.PARTIAL;
                }
            }
            if (childJoinNodeImpl == null) {
                childJoinNodeImpl = new JoinNodeImpl(this, name, getterType == GetterType.REQUIRED ? JoinType.INNER : JoinType.LEFT, fetch, collectionFetchType);
                if (childNodes == null) {
                    this.childNodes = childNodes = new LinkedHashMap();
                }
                childNodes.put((String)name, (JoinNodeImpl)childJoinNodeImpl);
            }
            return childJoinNodeImpl;
        }

        private String getIdPropertyName() {
            return this.creatingData.entityDelegate.getIdPropertyName();
        }

        private boolean containsImplicitCollectionJoins() {
            return this.creatingData.entityDelegate.containsImplicitCollectionJoins();
        }

        private PropertyDelegate getPropertyDelegate(String name) {
            PropertyDelegate propertyDelegate = null;
            HashMap propertyDelegates = this.creatingData.propertyDelegates;
            if (propertyDelegates == null) {
                this.creatingData.propertyDelegates = propertyDelegates = new HashMap();
            } else {
                propertyDelegate = propertyDelegates.get(name);
            }
            if (propertyDelegate == null) {
                try {
                    propertyDelegate = this.creatingData.entityDelegate.getNonIdProperty(name);
                }
                catch (Error | RuntimeException ex) {
                    throw new IllegalArgumentException(ex);
                }
                if (propertyDelegate == null) {
                    throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).methodCanNotReturnNull(this.creatingData.entityDelegate.getClass(), "getNonIdProperty(String)"));
                }
            }
            propertyDelegates.put(name, propertyDelegate);
            return propertyDelegate;
        }

        void finalInitialize() {
            this.markJoinNodeAsUsedByOrderRequest();
            this.removeUnusedJoinNode();
            this.initializeContainsScalarEagerness();
            this.initializeContainsInnerJoins();
            this.initializeContainsCollectionJoins();
            this.initializeContainsCollectionInnerJoins();
            this.initializeContainsNoFetchJoins();
            this.finalInitializePrivateData();
        }

        void collectOrderNodes(NavigableMap<Integer, OrderNode> preOrderNodeMap, NavigableMap<Integer, OrderNode> postOrderNodeMap) {
            if (this.orderNodes != null) {
                for (OrderNodeImpl orderNodeImpl : this.orderNodes.values()) {
                    if (orderNodeImpl.post) {
                        postOrderNodeMap.put(orderNodeImpl.sequence, orderNodeImpl);
                        continue;
                    }
                    preOrderNodeMap.put(orderNodeImpl.sequence, orderNodeImpl);
                }
            }
            if (this.childNodes != null) {
                for (JoinNodeImpl childJoinNodeImpl : this.childNodes.values()) {
                    childJoinNodeImpl.collectOrderNodes(preOrderNodeMap, postOrderNodeMap);
                }
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JoinType getJoinType() {
            return this.joinType;
        }

        @Override
        public boolean isFetch() {
            return this.fetch;
        }

        @Override
        public CollectionFetchType getCollectionFetchType() {
            return this.collectionFetchType;
        }

        @Override
        public XOrderedSet<String> getLoadedScalarNames() {
            return this.loadedScalarNames;
        }

        @Override
        public JoinNode getParentNode() {
            return this.parentNode;
        }

        @Override
        public Map<String, JoinNode> getChildNodes() {
            return this.childNodes;
        }

        @Override
        public Map<String, OrderNode> getOrderNodes() {
            return this.orderNodes;
        }

        @Override
        public boolean isCollection() {
            return this.collection;
        }

        @Override
        public boolean containsScalarEagerness() {
            return this.containsScalarEagerness;
        }

        @Override
        public boolean containsInnerJoins() {
            return this.containsInnerJoins;
        }

        @Override
        public boolean containsCollectionJoins() {
            return this.containsCollectionJoins;
        }

        @Override
        public boolean containsCollectionInnerJoins() {
            return this.containsCollectionInnerJoins;
        }

        @Override
        public boolean containsNoFetchJoins() {
            return this.containsNoFetchJoins;
        }

        @Override
        public String getPath() {
            String path = this.path;
            if (path == null) {
                StringBuilder builder = new StringBuilder();
                if (this.parentNode == null) {
                    builder.append(this.name);
                } else {
                    builder.append(this.parentNode.getPath());
                    if (this.joinType == JoinType.INNER) {
                        builder.append("/inner join ");
                    } else {
                        builder.append("/left join ");
                    }
                    if (this.fetch) {
                        builder.append("fetch ");
                    }
                    if (this.collectionFetchType == CollectionFetchType.PARTIAL) {
                        builder.append("partial(").append(this.name).append(')');
                    } else {
                        builder.append(this.name);
                    }
                }
                if (!Nulls.isNullOrEmpty(this.loadedScalarNames)) {
                    builder.append('[');
                    Joins.join(this.loadedScalarNames, (StringBuilder)builder);
                    builder.append(']');
                }
                this.path = path = builder.toString();
            }
            return path;
        }

        public String toString() {
            String toString = this.toString;
            if (toString == null) {
                StringBuilder builder = new StringBuilder();
                this.toString(builder, 0);
                this.toString = toString = builder.toString();
            }
            return toString;
        }

        private void addLoadedScalarName(String loadedScalarName) {
            if (!Nulls.isNullOrEmpty((String)loadedScalarName)) {
                if (this.loadedScalarNames == null) {
                    this.loadedScalarNames = new LinkedHashSet();
                }
                this.loadedScalarNames.add((Object)loadedScalarName);
            }
        }

        private void toString(StringBuilder builder, int tabCount) {
            for (int i = tabCount - 1; i >= 0; --i) {
                builder.append('\t');
            }
            if (tabCount == 0) {
                builder.append(this.getPath());
            } else {
                if (this.joinType == JoinType.INNER) {
                    builder.append("inner join ");
                } else {
                    builder.append("left join ");
                }
                if (this.fetch) {
                    builder.append("fetch ");
                }
                if (this.getCollectionFetchType() == CollectionFetchType.PARTIAL) {
                    builder.append("partial(").append(this.name).append(')');
                } else {
                    builder.append(this.name);
                }
                if (!Nulls.isNullOrEmpty(this.loadedScalarNames)) {
                    builder.append('[');
                    Joins.join(this.loadedScalarNames, (StringBuilder)builder);
                    builder.append(']');
                }
            }
            builder.append("\r\n");
            if (this.childNodes != null) {
                for (JoinNodeImpl childJoinNodeImpl : this.childNodes.values()) {
                    childJoinNodeImpl.toString(builder, tabCount + 1);
                }
            }
            if (this.orderNodes != null) {
                for (OrderNodeImpl orderNode : this.orderNodes.values()) {
                    orderNode.toStringForJoinNode(builder, tabCount + 1);
                }
            }
        }

        private void markJoinNodeAsUsedByOrderRequest() {
            Map<String, JoinNodeImpl> childNodes;
            Map<String, OrderNodeImpl> orderRequests = this.orderNodes;
            if (orderRequests != null && !orderRequests.isEmpty()) {
                this.setUsed();
            }
            if ((childNodes = this.childNodes) != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    childJoiNodeImpl.markJoinNodeAsUsedByOrderRequest();
                }
            }
        }

        private void removeUnusedJoinNode() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                Iterator<JoinNodeImpl> itr = childNodes.values().iterator();
                while (itr.hasNext()) {
                    JoinNodeImpl childNodeImpl = itr.next();
                    if (!childNodeImpl.creatingData.used) {
                        itr.remove();
                        continue;
                    }
                    childNodeImpl.removeUnusedJoinNode();
                }
            }
        }

        private boolean initializeContainsScalarEagerness() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    if (!childJoiNodeImpl.initializeContainsScalarEagerness()) continue;
                    this.containsScalarEagerness = true;
                }
            }
            if (!Nulls.isNullOrEmpty(this.loadedScalarNames)) {
                this.containsScalarEagerness = true;
            }
            return this.containsScalarEagerness;
        }

        private boolean initializeContainsInnerJoins() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    if (!childJoiNodeImpl.initializeContainsInnerJoins()) continue;
                    this.containsInnerJoins = true;
                }
            }
            if (this.joinType == JoinType.INNER) {
                this.containsInnerJoins = true;
            }
            return this.containsInnerJoins;
        }

        private boolean initializeContainsCollectionJoins() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    if (!childJoiNodeImpl.initializeContainsCollectionJoins()) continue;
                    this.containsCollectionJoins = true;
                }
            }
            if (this.collection || this.containsImplicitCollectionJoins()) {
                this.containsCollectionJoins = true;
            }
            return this.containsCollectionJoins;
        }

        private boolean initializeContainsCollectionInnerJoins() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoinNodeImpl : childNodes.values()) {
                    if (!childJoinNodeImpl.initializeContainsCollectionInnerJoins()) continue;
                    this.containsCollectionInnerJoins = true;
                }
            }
            if (this.collection && this.joinType == JoinType.INNER) {
                this.containsCollectionInnerJoins = true;
            }
            return this.containsCollectionInnerJoins;
        }

        private boolean initializeContainsNoFetchJoins() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    if (!childJoiNodeImpl.initializeContainsNoFetchJoins()) continue;
                    this.containsNoFetchJoins = true;
                }
            }
            if (this.parentNode != null && !this.fetch) {
                this.containsNoFetchJoins = true;
            }
            return this.containsNoFetchJoins;
        }

        private void finalInitializePrivateData() {
            Map<String, JoinNodeImpl> childNodes = this.childNodes;
            if (childNodes != null) {
                for (JoinNodeImpl childJoiNodeImpl : childNodes.values()) {
                    childJoiNodeImpl.finalInitializePrivateData();
                }
            }
            this.loadedScalarNames = this.loadedScalarNames == null ? MACollections.emptyOrderedSet() : MACollections.unmodifiable(this.loadedScalarNames);
            this.childNodes = childNodes == null ? MACollections.emptyOrderedMap() : MACollections.unmodifiable(childNodes);
            this.orderNodes = this.orderNodes == null ? MACollections.emptyOrderedMap() : MACollections.unmodifiable(this.orderNodes);
            this.creatingData = null;
            this.path = null;
            this.toString = null;
        }
    }

    private class SubPlanImpl
    implements SubPlan {
        private String alias;
        private JoinNodeImpl joinNodeImpl;
        private List<OrderNode> preOrderNodes;
        private List<OrderNode> postOrderNodes;

        SubPlanImpl(PathPlanKey.SubKey subKey) {
            EntityDelegate entityDelegate = AbstractPathPlanFactory.this.getEntityDelegate(this.alias);
            if (entityDelegate == null) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).methodCanNotReturnNull(AbstractPathPlanFactory.this.getClass(), "getEntityDelegate(String)"));
            }
            JoinNodeImpl joinNodeImpl = new JoinNodeImpl(entityDelegate);
            int orderSequence = 0;
            if (subKey.getQueryPaths() != null) {
                for (QueryPath queryPath : subKey.getQueryPaths()) {
                    if (queryPath instanceof FetchPath) {
                        joinNodeImpl.addFetchPath((FetchPath)queryPath);
                        continue;
                    }
                    joinNodeImpl.addSimpleOrderPath(orderSequence++, (SimpleOrderPath)queryPath);
                }
            }
            joinNodeImpl.finalInitialize();
            this.alias = subKey.getAlias();
            this.joinNodeImpl = joinNodeImpl;
            TreeMap preOrderNodeMap = new TreeMap();
            TreeMap postOrderNodeMap = new TreeMap();
            joinNodeImpl.collectOrderNodes((NavigableMap<Integer, OrderNode>)preOrderNodeMap, (NavigableMap<Integer, OrderNode>)postOrderNodeMap);
            this.preOrderNodes = MACollections.wrap((Object[])preOrderNodeMap.values().toArray(new OrderNode[preOrderNodeMap.size()]));
            this.postOrderNodes = MACollections.wrap((Object[])postOrderNodeMap.values().toArray(new OrderNode[postOrderNodeMap.size()]));
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public JoinNode getJoinNode() {
            return this.joinNodeImpl;
        }

        @Override
        public List<OrderNode> getPreOrderNodes() {
            return this.preOrderNodes;
        }

        @Override
        public List<OrderNode> getPostOrderNodes() {
            return this.postOrderNodes;
        }
    }

    private class PathPlanImpl
    implements PathPlan {
        private Map<String, SubPlanImpl> subPlans;
        private boolean containsScalarEagerness;
        private boolean containsInnerJoins;
        private boolean containsCollectionJoins;
        private boolean containsCollectionInnerJoins;
        private boolean containsNoFetchJoins;

        public PathPlanImpl(PathPlanKey key) {
            key = PathPlanKey.nullToNil(key);
            LinkedHashMap map = new LinkedHashMap(key.getSubKeys().length);
            for (PathPlanKey.SubKey subKey : key.getSubKeys()) {
                AbstractPathPlanFactory abstractPathPlanFactory2 = AbstractPathPlanFactory.this;
                abstractPathPlanFactory2.getClass();
                SubPlanImpl subPlan = abstractPathPlanFactory2.new SubPlanImpl(subKey);
                map.put(subKey.getAlias(), subPlan);
                this.containsScalarEagerness |= subPlan.getJoinNode().containsScalarEagerness();
                this.containsInnerJoins |= subPlan.getJoinNode().containsInnerJoins();
                this.containsCollectionJoins |= subPlan.getJoinNode().containsCollectionJoins();
                this.containsCollectionInnerJoins |= subPlan.getJoinNode().containsCollectionInnerJoins();
                this.containsNoFetchJoins |= subPlan.getJoinNode().containsNoFetchJoins();
            }
            this.subPlans = MACollections.unmodifiable((Map)map);
        }

        @Override
        public Map<String, SubPlan> getSubPlans() {
            return MACollections.unmodifiable(this.subPlans);
        }

        @Override
        public boolean containsScalarEagerness() {
            return this.containsScalarEagerness;
        }

        @Override
        public boolean containsInnerJoins() {
            return this.containsInnerJoins;
        }

        @Override
        public boolean containsCollectionJoins() {
            return this.containsCollectionJoins;
        }

        @Override
        public boolean containsCollectionInnerJoins() {
            return this.containsCollectionInnerJoins;
        }

        @Override
        public boolean containsNoFetchJoins() {
            return this.containsNoFetchJoins;
        }
    }

    protected static interface PropertyDelegate {
        public boolean isAssociation();

        public boolean isCollection();

        public EntityDelegate getAssociatedEntityDelegate();
    }

    protected static interface EntityDelegate {
        public String getIdPropertyName();

        public PropertyDelegate getNonIdProperty(String var1);

        public boolean containsImplicitCollectionJoins();
    }
}

