/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.spi.AbstractPath;

public class SingularAttributePath<X>
extends AbstractPath<X> {
    private static final long serialVersionUID = 436933653541939703L;
    private SingularAttribute<?, X> attribute;
    private ManagedType<X> managedType;

    public SingularAttributePath(AbstractPath<?> parentPath, SingularAttribute<?, X> attribute) {
        super(((AbstractPath)Arguments.mustNotBeNull((String)"parentPath", parentPath)).getCriteriaBuilder(), parentPath);
        this.attribute = attribute;
        if (Attribute.PersistentAttributeType.BASIC != attribute.getPersistentAttributeType()) {
            this.managedType = Attribute.PersistentAttributeType.EMBEDDED == attribute.getPersistentAttributeType() ? (EmbeddableType)attribute.getType() : (IdentifiableType)attribute.getType();
        }
    }

    public SingularAttribute<?, X> getAttribute() {
        return this.attribute;
    }

    @Override
    protected boolean isReferenceable() {
        return this.managedType != null;
    }

    @Override
    protected Attribute<? super X, ?> onLocateAttribute(String attributeName) {
        return this.managedType.getAttribute(attributeName);
    }

    public Class<? extends X> getJavaType() {
        return this.attribute.getJavaType();
    }

    public Bindable<X> getModel() {
        return this.getAttribute();
    }

    @Override
    public String toString() {
        return this.getParentPath().toString() + '.' + this.attribute.getName();
    }
}

