/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.PluralJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.reflect.ClassInfo;
import org.babyfish.persistence.criteria.XAbstractQuery;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.spi.AbstractPredicate;
import org.babyfish.persistence.criteria.spi.CommonCriteriaStructure;

class QueryStructure<T>
extends CommonCriteriaStructure {
    private Class<T> resultType;
    private boolean distinct;
    private Selection<T> selection;
    private XOrderedSet<XRoot<?>> roots;
    private List<Expression<?>> groupList;
    private Predicate groupRestriction;

    QueryStructure(XAbstractQuery<T> owner, Class<T> resultType) {
        super(owner);
        this.resultType = resultType;
        this.roots = new LinkedHashSet();
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public <S extends Selection<T>> S getSelection() {
        return (S)this.selection;
    }

    public XOrderedSet<XRoot<?>> getXRoots() {
        return this.roots;
    }

    public List<Expression<?>> getGroupList() {
        List<Expression<?>> groupList = this.groupList;
        if (groupList == null) {
            return MACollections.emptyList();
        }
        return groupList;
    }

    public Predicate getGroupRestriction() {
        return this.groupRestriction;
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void select(Selection<? extends T> selection) {
        if (selection != null) {
            Class selectionType;
            if (selection instanceof PluralJoin) {
                PluralJoin pluralJoin = (PluralJoin)selection;
                selectionType = pluralJoin.getModel().getElementType().getJavaType();
            } else {
                selectionType = ClassInfo.box((Class)selection.getJavaType());
            }
            if (!this.getResultType().isAssignableFrom(selectionType)) {
                throw new IllegalArgumentException("Can not set a selection whose java type is \"" + selectionType.getName() + "\" because it is not the query result type \"" + this.getResultType().getName() + "\" or its derived type.");
            }
        }
        this.selection = selection;
    }

    public <X> XRoot<X> from(Class<X> entityClass) {
        XRoot<X> root = this.createRoot(entityClass);
        this.roots.add(root);
        return root;
    }

    public <X> XRoot<X> from(EntityType<X> entity) {
        XRoot<X> root = this.createRoot(entity);
        this.roots.add(root);
        return root;
    }

    public void groupBy(Expression<?> ... grouping) {
        this.groupBy((List<Expression<?>>)MACollections.wrap((Object[])grouping));
    }

    public void groupBy(List<Expression<?>> grouping) {
        Object groupList;
        if (grouping != null) {
            groupList = new ArrayList(grouping.size());
            for (Expression<?> expression : grouping) {
                if (expression == null) continue;
                groupList.add(expression);
            }
            groupList = groupList.isEmpty() ? null : MACollections.unmodifiable((List)groupList);
        } else {
            groupList = null;
        }
        this.groupList = groupList;
    }

    public void having(Expression<Boolean> restriction) {
        Predicate predicate = this.getOwner().getCriteriaBuilder().isTrue(restriction);
        this.groupRestriction = AbstractPredicate.isNullOrEmpty((Expression<Boolean>)predicate) ? null : predicate;
    }

    public void having(Predicate ... restrictions) {
        Predicate predicate = this.getOwner().getCriteriaBuilder().and(restrictions);
        this.groupRestriction = AbstractPredicate.isNullOrEmpty((Expression<Boolean>)predicate) ? null : predicate;
    }
}

