/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.EqualityComparator;
import org.babyfish.collection.HashMap;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.ReferenceEqualityComparator;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.Arguments;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.persistence.XEntityManagerFactory;
import org.babyfish.persistence.criteria.Assignment;
import org.babyfish.persistence.criteria.JoinMode;
import org.babyfish.persistence.criteria.XAbstractQuery;
import org.babyfish.persistence.criteria.XCommonAbstractCriteria;
import org.babyfish.persistence.criteria.XCriteriaDelete;
import org.babyfish.persistence.criteria.XCriteriaQuery;
import org.babyfish.persistence.criteria.XCriteriaUpdate;
import org.babyfish.persistence.criteria.XFetch;
import org.babyfish.persistence.criteria.XFetchParent;
import org.babyfish.persistence.criteria.XFrom;
import org.babyfish.persistence.criteria.XJoin;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.XSubquery;
import org.babyfish.persistence.criteria.expression.ParameterExpressionImpl;
import org.babyfish.persistence.criteria.spi.AbstractFrom;
import org.babyfish.persistence.criteria.spi.AbstractNode;
import org.babyfish.persistence.criteria.spi.AbstractPath;
import org.babyfish.persistence.criteria.spi.AbstractVisitor;
import org.babyfish.persistence.criteria.spi.MapKeyPath;
import org.babyfish.persistence.criteria.spi.PathId;
import org.babyfish.persistence.criteria.spi.PluralAttributePath;
import org.babyfish.persistence.criteria.spi.SingularAttributePath;
import org.babyfish.persistence.path.CollectionFetchType;
import org.babyfish.persistence.path.spi.EntityManagerFactoryConfigurable;
import org.babyfish.util.LazyResource;

public class QueryContext
implements AutoCloseable {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private XCommonAbstractCriteria commonAbstractCriteria;
    private Map<XCommonAbstractCriteria, List<Entity>> rootEntitiyMap;
    private XOrderedMap<XFrom<?, ?>, Entity> fromEntityMap;
    private XOrderedMap<XFetch<?, ?>, Entity> fetchEntityMap;
    private XOrderedMap<PathId, PathNode> pathNodes;
    private XOrderedMap<String, ParameterExpression<?>> namedParameters;
    private List<ParameterExpression<?>> unnamedParameters;
    private PathId.Allocator pathIdAllocator = PathId.primaryAllocator();

    public QueryContext(XCommonAbstractCriteria commonAbstractCriteria) {
        this.commonAbstractCriteria = (XCommonAbstractCriteria)Arguments.mustNotBeNull((String)"commonAbstractCriteria", (Object)commonAbstractCriteria);
        PreVisitorImpl preVisitorImpl = new PreVisitorImpl();
        preVisitorImpl.visit(commonAbstractCriteria);
        if (!this.pathIdAllocator.isEmpty()) {
            throw new AssertionError();
        }
        this.rootEntitiyMap = preVisitorImpl.rootEntityMap;
        this.fromEntityMap = preVisitorImpl.fromEntityImplMap;
        this.fetchEntityMap = preVisitorImpl.fetchEntityImplMap;
        this.pathNodes = MACollections.unmodifiable(preVisitorImpl.pathNodeImpls);
        this.namedParameters = MACollections.unmodifiable(preVisitorImpl.namedParameters);
        this.unnamedParameters = MACollections.unmodifiable(preVisitorImpl.unnamedParameters);
    }

    @Override
    public void close() {
        XCommonAbstractCriteria commonAbstractCriteria = this.commonAbstractCriteria;
        if (commonAbstractCriteria != null) {
            new PostVisitorImpl().visit(commonAbstractCriteria);
            this.commonAbstractCriteria = null;
            this.pathIdAllocator = null;
        }
    }

    public PathId.Allocator secondaryPathIdAllocator() {
        if (this.pathIdAllocator == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return this.pathIdAllocator.secondaryAllocator();
    }

    public XCommonAbstractCriteria getCommonAbstractCriteria() {
        XCommonAbstractCriteria commonAbstractCriteria = this.commonAbstractCriteria;
        if (commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return commonAbstractCriteria;
    }

    public List<Entity> getRootEntities(XCommonAbstractCriteria query) {
        if (this.commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return this.rootEntitiyMap.get(query);
    }

    public Entity getEntity(XFetchParent<?, ?> fetchParent) {
        XFrom treatedParent;
        if (this.commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        if (fetchParent instanceof AbstractFrom && (treatedParent = ((AbstractFrom)fetchParent).getTreatedParent()) != null) {
            return this.getEntity(treatedParent);
        }
        if (fetchParent instanceof XFrom) {
            XFrom<?, ?> from = QueryContext.getEntityMapKey((XFrom)fetchParent);
            return (Entity)this.fromEntityMap.get(from);
        }
        return (Entity)this.fetchEntityMap.get(fetchParent);
    }

    public XOrderedMap<PathId, PathNode> getPathNodes() {
        if (this.commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return this.pathNodes;
    }

    public XOrderedMap<String, ParameterExpression<?>> getNamedParameters() {
        if (this.commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return this.namedParameters;
    }

    public List<ParameterExpression<?>> getUnnamedParameters() {
        if (this.commonAbstractCriteria == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).queryContextIsClosed(QueryContext.class));
        }
        return this.unnamedParameters;
    }

    private boolean isDbSchemaStrict() {
        XEntityManagerFactory entityManagerFactory = this.commonAbstractCriteria.getCriteriaBuilder().getEntityManagerFactory();
        if (entityManagerFactory instanceof EntityManagerFactoryConfigurable) {
            return ((EntityManagerFactoryConfigurable)((Object)entityManagerFactory)).isDbSchemaStrict();
        }
        return false;
    }

    private static XFrom<?, ?> getEntityMapKey(XFrom<?, ?> from) {
        XFrom treatedParent = ((AbstractFrom)from).getTreatedParent();
        if (treatedParent != null) {
            return QueryContext.getEntityMapKey(treatedParent);
        }
        XFrom<?, ?> correlationRoot = from;
        while ((from = from.getCorrelationParent()) != null) {
            correlationRoot = from;
        }
        return correlationRoot;
    }

    private static interface Resource {
        public String queryContextIsClosed(Class<QueryContext> var1);

        public String unnamedParameterCanNotBeUsedTwice();

        public String noRoots(Class<? extends XCommonAbstractCriteria> var1);

        public String entityIdHasNotBeenAllocated(Class<Entity> var1);
    }

    private static class PathNodeImpl
    implements PathNode {
        Class<?> treateAsType;
        PathNodeImpl parentNode;
        Attribute<?, ?> attribute;
        EntityImpl entityImpl;

        static PathNodeImpl of(boolean dbSchemaStrict, Path<?> path, Map<XFrom<?, ?>, EntityImpl> fromEntityImplMap, boolean directlyReferencedByTopmostSelection) {
            return PathNodeImpl.ofImpl(dbSchemaStrict, true, path, fromEntityImplMap, directlyReferencedByTopmostSelection);
        }

        private static PathNodeImpl ofImpl(boolean dbSchemaStrict, boolean leaf, Path<?> path, Map<XFrom<?, ?>, EntityImpl> fromEntityImplMap, boolean directlyReferencedByTopmostSelection) {
            PluralAttribute attribute;
            Arguments.mustNotBeInstanceOfValue((String)"path", path, MapKeyPath.class);
            if (path == null) {
                return null;
            }
            if (path instanceof From) {
                if (leaf && path instanceof Join) {
                    Join join = (Join)path;
                    if (!directlyReferencedByTopmostSelection && PathNodeImpl.isLeftOrNonNullReferenceJoin(join, dbSchemaStrict)) {
                        XFrom parentFrom = (XFrom)join.getParentPath();
                        EntityImpl parentEntity = fromEntityImplMap.get(QueryContext.getEntityMapKey(parentFrom));
                        return new PathNodeImpl(PathNodeImpl.treatedAsType(path), new PathNodeImpl(PathNodeImpl.treatedAsType(parentFrom), PathNodeImpl.ofImpl(dbSchemaStrict, false, parentFrom, fromEntityImplMap, directlyReferencedByTopmostSelection), parentEntity), join.getAttribute());
                    }
                }
                EntityImpl entityImpl = fromEntityImplMap.get(QueryContext.getEntityMapKey((XFrom)path));
                return new PathNodeImpl(PathNodeImpl.treatedAsType(path), PathNodeImpl.ofImpl(dbSchemaStrict, false, path.getParentPath(), fromEntityImplMap, directlyReferencedByTopmostSelection), entityImpl);
            }
            if (path.getModel() instanceof SingularAttribute && (attribute = (PluralAttribute)path.getModel()).isId()) {
                if (path.getParentPath() instanceof Join) {
                    Join join = (Join)path.getParentPath();
                    if (PathNodeImpl.isLeftOrNonNullReferenceJoin(join, dbSchemaStrict)) {
                        From from = (From)join.getParentPath();
                        return new PathNodeImpl(PathNodeImpl.treatedAsType(path), new PathNodeImpl(PathNodeImpl.treatedAsType(join), PathNodeImpl.ofImpl(dbSchemaStrict, false, from, fromEntityImplMap, directlyReferencedByTopmostSelection), join.getAttribute()), (Attribute<?, ?>)attribute);
                    }
                } else if (path.getParentPath() instanceof SingularAttributePath) {
                    SingularAttributePath parentPath = (SingularAttributePath)path.getParentPath();
                    return new PathNodeImpl(PathNodeImpl.treatedAsType(path), new PathNodeImpl(PathNodeImpl.treatedAsType(parentPath), PathNodeImpl.ofImpl(dbSchemaStrict, false, parentPath.getParentPath(), fromEntityImplMap, directlyReferencedByTopmostSelection), (Attribute<?, ?>)parentPath.getAttribute()), (Attribute<?, ?>)attribute);
                }
            }
            if ((attribute = (Attribute)path.getModel()) != null) {
                Attribute.PersistentAttributeType pat;
                if (!(leaf && !directlyReferencedByTopmostSelection || (pat = attribute.getPersistentAttributeType()) != Attribute.PersistentAttributeType.ONE_TO_ONE && pat != Attribute.PersistentAttributeType.MANY_TO_ONE)) {
                    PathNodeImpl parentNode = PathNodeImpl.ofImpl(dbSchemaStrict, false, path.getParentPath(), fromEntityImplMap, directlyReferencedByTopmostSelection);
                    EntityImpl entityImpl = parentNode.entityImpl.implicitlyJoin((Attribute<?, ?>)attribute);
                    return new PathNodeImpl(PathNodeImpl.treatedAsType(path), parentNode, entityImpl);
                }
            } else {
                attribute = ((PluralAttributePath)path).getAttribute();
            }
            return new PathNodeImpl(PathNodeImpl.treatedAsType(path), PathNodeImpl.ofImpl(dbSchemaStrict, false, path.getParentPath(), fromEntityImplMap, directlyReferencedByTopmostSelection), (Attribute<?, ?>)attribute);
        }

        private PathNodeImpl(Class<?> treatedAsType, PathNodeImpl parentNode, EntityImpl entityImpl) {
            this.treateAsType = treatedAsType;
            this.parentNode = parentNode;
            this.entityImpl = entityImpl;
            this.attribute = entityImpl.getAttribute();
            entityImpl.setUsed();
        }

        private PathNodeImpl(Class<?> treatedAsType, PathNodeImpl parentNode, Attribute<?, ?> attribute) {
            this.treateAsType = treatedAsType;
            this.parentNode = parentNode;
            this.attribute = attribute;
        }

        private static Class<?> treatedAsType(Path<?> path) {
            Path treatedParent = ((AbstractPath)path).getTreatedParent();
            if (treatedParent != null) {
                return path.getJavaType();
            }
            return null;
        }

        @Override
        public PathNode getParent() {
            return this.parentNode;
        }

        @Override
        public Entity getEntity() {
            return this.entityImpl;
        }

        @Override
        public Attribute<?, ?> getAttribute() {
            return this.attribute;
        }

        @Override
        public Class<?> getTreatAsType() {
            return this.treateAsType;
        }

        private static boolean isLeftOrNonNullReferenceJoin(Join<?, ?> join, boolean dbSchemaStrict) {
            if (join.getAttribute().isCollection()) {
                return false;
            }
            if (join.getJoinType() == JoinType.LEFT) {
                return true;
            }
            if (!dbSchemaStrict) {
                return false;
            }
            SingularAttribute singularAttribute = (SingularAttribute)join.getAttribute();
            return !singularAttribute.isOptional() && singularAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
    }

    private static class EntityImpl
    implements Entity {
        private int id = -1;
        private ManagedType<?> managedType;
        private Attribute<?, ?> attribute;
        private JoinType joinType;
        private JoinMode joinMode;
        private boolean fetch;
        private boolean explicit;
        private boolean used;
        private EntityImpl parent;
        private List<EntityImpl> entities;
        private String sourceAlias;
        private Predicate on;

        private EntityImpl(EntityImpl parent, XFrom<?, ?> from) {
            this.parent = parent;
            this.explicit = true;
            this.sourceAlias = from.getAlias();
            if (from instanceof XRoot) {
                if (parent != null) {
                    throw new AssertionError();
                }
                this.managedType = ((XRoot)from).getModel();
                this.setUsed();
            } else {
                if (parent == null) {
                    throw new AssertionError();
                }
                XJoin join = (XJoin)from;
                Attribute attribute = join.getAttribute();
                this.managedType = attribute instanceof PluralAttribute ? (ManagedType)((PluralAttribute)attribute).getElementType() : (ManagedType)((SingularAttribute)attribute).getType();
                this.attribute = attribute;
                this.joinType = join.getJoinType();
                this.joinMode = join.getJoinMode();
                this.on = join.getOn();
                if (this.joinMode.isRequired() || this.on != null) {
                    this.setUsed();
                }
            }
        }

        private EntityImpl(EntityImpl parentNode, Attribute<?, ?> attribute, JoinType joinType) {
            this.parent = parentNode;
            this.managedType = attribute instanceof PluralAttribute ? (ManagedType)((PluralAttribute)attribute).getElementType() : (ManagedType)((SingularAttribute)attribute).getType();
            this.attribute = attribute;
            this.joinType = joinType;
            this.joinMode = JoinMode.OPTIONALLY_MERGE_EXISTS;
        }

        static EntityImpl of(EntityImpl parent, XFrom<?, ?> from, Map<XFrom<?, ?>, EntityImpl> fromEntityImplMap) {
            XJoin join;
            EntityImpl entityImpl = null;
            if (parent != null && !(join = (XJoin)from).getJoinMode().isNew()) {
                for (EntityImpl existingEntityImpl : parent.entities) {
                    String sourceAlias;
                    if (existingEntityImpl.attribute != join.getAttribute() || existingEntityImpl.joinMode.isNew()) continue;
                    if (existingEntityImpl.joinType != join.getJoinType()) {
                        existingEntityImpl.joinType = JoinType.INNER;
                    }
                    if ((sourceAlias = join.getAlias()) != null) {
                        if (existingEntityImpl.sourceAlias != null && !existingEntityImpl.sourceAlias.equals(sourceAlias)) {
                            throw new IllegalArgumentException();
                        }
                        existingEntityImpl.sourceAlias = sourceAlias;
                    }
                    entityImpl = existingEntityImpl;
                    break;
                }
            }
            if (entityImpl == null) {
                entityImpl = new EntityImpl(parent, from);
                if (parent != null) {
                    parent.entities.add(entityImpl);
                }
            }
            fromEntityImplMap.put(from, entityImpl);
            XOrderedSet<XJoin<?, ?>> joins = from.getXJoins();
            if (!from.getXJoins().isEmpty()) {
                ArrayList entities = entityImpl.entities;
                if (entities == null) {
                    entityImpl.entities = entities = new ArrayList();
                }
                for (XJoin join2 : joins) {
                    EntityImpl.of(entityImpl, join2, fromEntityImplMap);
                }
            }
            return entityImpl;
        }

        EntityImpl implicitlyJoin(Attribute<?, ?> attribute) {
            ArrayList entities = this.entities;
            if (entities != null) {
                for (EntityImpl existingEntityImpl : entities) {
                    if (existingEntityImpl.attribute != attribute) continue;
                    if (existingEntityImpl.joinType != this.joinType) {
                        existingEntityImpl.joinType = JoinType.INNER;
                    }
                    existingEntityImpl.setUsed();
                    return existingEntityImpl;
                }
            } else {
                this.entities = entities = new ArrayList();
            }
            EntityImpl entityImpl = new EntityImpl(this, attribute, JoinType.INNER);
            entities.add(entityImpl);
            return entityImpl;
        }

        static void fetch(Map<XFrom<?, ?>, EntityImpl> fromEntityImplMap, Map<XFetch<?, ?>, EntityImpl> fetchEntityImplMap) {
            for (Map.Entry<XFrom<?, ?>, EntityImpl> entry : fromEntityImplMap.entrySet()) {
                EntityImpl.fetch(entry.getValue(), QueryContext.getEntityMapKey(entry.getKey()), fetchEntityImplMap);
            }
        }

        private static void fetch(EntityImpl parentEntityImpl, XFetchParent<?, ?> fetchParent, Map<XFetch<?, ?>, EntityImpl> fetchEntityImplMap) {
            ArrayList entities = parentEntityImpl.entities;
            for (XFetch fetch : fetchParent.getXFetches()) {
                EntityImpl childEntityImpl = null;
                if (entities != null) {
                    for (EntityImpl existingEntityImpl : entities) {
                        if (existingEntityImpl.attribute != fetch.getAttribute() || existingEntityImpl.joinMode.isNew() || fetch.getCollectionFetchType() != CollectionFetchType.PARTIAL && !(existingEntityImpl.attribute instanceof SingularAttribute) && !existingEntityImpl.fetch) continue;
                        if (existingEntityImpl.joinType != fetch.getJoinType()) {
                            existingEntityImpl.joinType = JoinType.INNER;
                        }
                        childEntityImpl = existingEntityImpl;
                        break;
                    }
                }
                if (childEntityImpl == null) {
                    if (entities == null) {
                        parentEntityImpl.entities = entities = new ArrayList();
                    }
                    childEntityImpl = new EntityImpl(parentEntityImpl, fetch.getAttribute(), fetch.getJoinType());
                    entities.add(childEntityImpl);
                }
                childEntityImpl.setFetch();
                fetchEntityImplMap.put(fetch, childEntityImpl);
                EntityImpl.fetch(childEntityImpl, fetch, fetchEntityImplMap);
            }
        }

        void setUsed() {
            EntityImpl entityImpl = this;
            while (entityImpl != null) {
                entityImpl.used = true;
                entityImpl = entityImpl.parent;
            }
        }

        void setFetch() {
            this.fetch = true;
            this.setUsed();
            EntityImpl entityImpl = this;
            while (entityImpl != null) {
                entityImpl.explicit = true;
                entityImpl = entityImpl.parent;
            }
        }

        void setIdIfNecessary(int id) {
            this.id = id;
        }

        @Override
        public String getRenderAlias() {
            int id = this.id;
            if (id == -1) {
                throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).entityIdHasNotBeenAllocated(Entity.class));
            }
            String sourceAlias = this.sourceAlias;
            if (this.joinMode == null || !this.joinMode.isNew()) {
                if (sourceAlias == null) {
                    return "babyfish_shared_alias_" + id;
                }
                return sourceAlias;
            }
            if (sourceAlias == null) {
                return "babyfish_not_shared_alias_" + id;
            }
            return "babyfish_not_shared_alias_" + sourceAlias;
        }

        @Override
        public ManagedType<?> getManagedType() {
            return this.managedType;
        }

        @Override
        public Attribute<?, ?> getAttribute() {
            return this.attribute;
        }

        @Override
        public JoinType getJoinType() {
            return this.joinType;
        }

        @Override
        public JoinMode getJoinMode() {
            return this.joinMode;
        }

        @Override
        public boolean isFetch() {
            return this.fetch;
        }

        @Override
        public boolean isExplicit() {
            return this.explicit;
        }

        @Override
        public boolean isUsed() {
            return this.used;
        }

        @Override
        public Predicate getOn() {
            return this.on;
        }

        @Override
        public Entity getParent() {
            return this.parent;
        }

        @Override
        public List<Entity> getEntities() {
            List<EntityImpl> entities = this.entities;
            if (entities == null) {
                return MACollections.emptyList();
            }
            return MACollections.unmodifiable(entities);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(0, builder);
            return builder.toString();
        }

        private void toString(int tab, StringBuilder output) {
            for (int i = tab - 1; i >= 0; --i) {
                output.append('\t');
            }
            if (this.parent == null) {
                output.append(this.managedType.getJavaType().getName());
            } else {
                output.append(this.joinType.name().toLowerCase()).append(" join ");
                if (this.fetch) {
                    output.append("fetch ");
                }
                output.append(this.attribute.getName()).append("(joinMode = ").append(this.joinMode.name().toLowerCase()).append(", used = ").append(this.used).append(");");
            }
            List<EntityImpl> entities = this.entities;
            if (entities == null) {
                output.append("\r\n");
            } else {
                output.append(" {\r\n");
                for (EntityImpl entity : entities) {
                    entity.toString(tab + 1, output);
                }
                for (int i = tab - 1; i >= 0; --i) {
                    output.append('\t');
                }
                output.append("}\r\n");
            }
        }
    }

    private class PostVisitorImpl
    extends AbstractVisitor {
        private PostVisitorImpl() {
        }

        @Override
        protected void visit(Object o) {
            if (o != null) {
                AbstractNode abstractNode = (AbstractNode)o;
                abstractNode.unfreeze(QueryContext.this);
                abstractNode.accept(this);
            }
        }
    }

    private class PreVisitorImpl
    extends AbstractVisitor {
        Map<XCommonAbstractCriteria, List<Entity>> rootEntityMap = new HashMap((EqualityComparator)ReferenceEqualityComparator.getInstance(), (EqualityComparator)((ReferenceEqualityComparator)null));
        XOrderedMap<XFrom<?, ?>, EntityImpl> fromEntityImplMap = new LinkedHashMap((EqualityComparator)ReferenceEqualityComparator.getInstance(), (EqualityComparator)((ReferenceEqualityComparator)null));
        XOrderedMap<XFetch<?, ?>, EntityImpl> fetchEntityImplMap = new LinkedHashMap((EqualityComparator)ReferenceEqualityComparator.getInstance(), (EqualityComparator)((ReferenceEqualityComparator)null));
        XOrderedMap<PathId, PathNodeImpl> pathNodeImpls = new LinkedHashMap();
        XOrderedMap<String, ParameterExpression<?>> namedParameters = new LinkedHashMap();
        List<ParameterExpression<?>> unnamedParameters = new ArrayList();
        int entityIdSequence;
        int parameterPositionSequence;

        private PreVisitorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitCriteriaQuery(XCriteriaQuery<?> query) {
            this.getEntities(query);
            this.visitAbstractQuery(query);
            PathId.Allocator pathIdAllocator = QueryContext.this.pathIdAllocator;
            pathIdAllocator.push(PathId.Allocator.ORDER_LIST);
            try {
                for (Order order : query.getOrderList()) {
                    this.visit(order);
                }
            }
            finally {
                pathIdAllocator.pop();
            }
            this.afterVisitCommonAbstractCriteria(query);
        }

        @Override
        public void visitSubquery(XSubquery<?> query) {
            this.getEntities(query);
            this.visitAbstractQuery(query);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitCriteriaUpdate(XCriteriaUpdate<?> update) {
            this.getEntities(update);
            PathId.Allocator pathIdAllocator = QueryContext.this.pathIdAllocator;
            pathIdAllocator.push(PathId.Allocator.ON_TREE);
            try {
                this.visitOnExpressions(update);
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.ASSIGNMENT_LIST);
            try {
                for (Assignment assignment : update.getAssignments()) {
                    this.visit(assignment);
                }
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.RESTRICTION);
            try {
                this.visit(update.getRestriction());
            }
            finally {
                pathIdAllocator.pop();
            }
            this.afterVisitCommonAbstractCriteria(update);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitCriteriaDelete(XCriteriaDelete<?> delete) {
            this.getEntities(delete);
            PathId.Allocator pathIdAllocator = QueryContext.this.pathIdAllocator;
            pathIdAllocator.push(PathId.Allocator.ON_TREE);
            try {
                this.visitOnExpressions(delete);
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.RESTRICTION);
            try {
                this.visit(delete.getRestriction());
            }
            finally {
                pathIdAllocator.pop();
            }
            this.afterVisitCommonAbstractCriteria(delete);
        }

        @Override
        public void visitPath(Path<?> path) {
            if (path instanceof MapKeyPath) {
                this.visit(path.getParentPath());
            } else {
                PathId pathId = QueryContext.this.pathIdAllocator.allocate();
                if (pathId.getPath() != path) {
                    throw new AssertionError();
                }
                this.pathNodeImpls.put((Object)pathId, null);
            }
        }

        @Override
        public void visitParameterExpression(ParameterExpression<?> parameterExpression) {
            if (parameterExpression.getName() == null) {
                ParameterExpressionImpl parameterExpressionImpl = (ParameterExpressionImpl)parameterExpression;
                if (!parameterExpressionImpl.setPosition(++this.parameterPositionSequence)) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).unnamedParameterCanNotBeUsedTwice());
                }
                this.unnamedParameters.add(parameterExpression);
            } else {
                this.namedParameters.put((Object)parameterExpression.getName(), parameterExpression);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void visit(Object o) {
            if (o != null) {
                PathId.Allocator pathIdAllocator = QueryContext.this.pathIdAllocator;
                pathIdAllocator.push(o);
                try {
                    AbstractNode abstractNode = (AbstractNode)o;
                    abstractNode.freeze(QueryContext.this);
                    abstractNode.accept(this);
                }
                finally {
                    pathIdAllocator.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitAbstractQuery(XAbstractQuery<?> query) {
            PathId.Allocator pathIdAllocator = QueryContext.this.pathIdAllocator;
            pathIdAllocator.push(PathId.Allocator.SELECTION);
            try {
                this.visit(query.getSelection());
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.ON_TREE);
            try {
                this.visitOnExpressions(query);
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.RESTRICTION);
            try {
                this.visit(query.getRestriction());
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.GROUP_LIST);
            try {
                for (Expression expression : query.getGroupList()) {
                    this.visit(expression);
                }
            }
            finally {
                pathIdAllocator.pop();
            }
            pathIdAllocator.push(PathId.Allocator.GROUP_RESTRICTION);
            try {
                this.visit(query.getGroupRestriction());
            }
            finally {
                pathIdAllocator.pop();
            }
        }

        private List<Entity> getEntities(XCommonAbstractCriteria commonAbstractCriteria) {
            ArrayList entities = this.rootEntityMap.get(commonAbstractCriteria);
            if (entities == null) {
                if (commonAbstractCriteria instanceof XCriteriaUpdate) {
                    XCriteriaUpdate update = (XCriteriaUpdate)commonAbstractCriteria;
                    XRoot root = update.getRoot();
                    if (root == null) {
                        throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).noRoots(XCriteriaUpdate.class));
                    }
                    entities = new ArrayList();
                    entities.add(EntityImpl.of(null, root, this.fromEntityImplMap));
                } else if (commonAbstractCriteria instanceof XCriteriaDelete) {
                    XCriteriaDelete delete = (XCriteriaDelete)commonAbstractCriteria;
                    XRoot root = delete.getRoot();
                    if (root == null) {
                        throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).noRoots(XCriteriaUpdate.class));
                    }
                    entities = new ArrayList();
                    entities.add(EntityImpl.of(null, root, this.fromEntityImplMap));
                } else {
                    XAbstractQuery query = (XAbstractQuery)commonAbstractCriteria;
                    XOrderedSet<XRoot<?>> roots = query.getXRoots();
                    if (roots.isEmpty()) {
                        throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).noRoots(XAbstractQuery.class));
                    }
                    entities = new ArrayList(roots.size());
                    for (XRoot root : roots) {
                        EntityImpl entityImpl = EntityImpl.of(null, root, this.fromEntityImplMap);
                        entities.add(entityImpl);
                    }
                }
                this.rootEntityMap.put(commonAbstractCriteria, (List<Entity>)entities);
            }
            return entities;
        }

        private void afterVisitCommonAbstractCriteria(XCommonAbstractCriteria commandAbstractCriteria) {
            for (Map.Entry entry : this.pathNodeImpls.entrySet()) {
                entry.setValue(PathNodeImpl.of(QueryContext.this.isDbSchemaStrict(), ((PathId)entry.getKey()).getPath(), this.fromEntityImplMap, ((PathId)entry.getKey()).isDirectlyReferencedByTopmostSelection()));
            }
            EntityImpl.fetch(this.fromEntityImplMap, this.fetchEntityImplMap);
            for (Map.Entry entry : this.fromEntityImplMap.entrySet()) {
                if (!(entry.getKey() instanceof XRoot)) continue;
                this.allocateEntityId((EntityImpl)entry.getValue());
            }
        }

        private void allocateEntityId(EntityImpl entityImpl) {
            if (entityImpl.isUsed()) {
                entityImpl.setIdIfNecessary(this.entityIdSequence++);
            }
            if (!entityImpl.getEntities().isEmpty()) {
                for (Entity childEntity : entityImpl.getEntities()) {
                    this.allocateEntityId((EntityImpl)childEntity);
                }
            }
        }
    }

    public static interface PathNode {
        public Class<?> getTreatAsType();

        public PathNode getParent();

        public Entity getEntity();

        public Attribute<?, ?> getAttribute();
    }

    public static interface Entity {
        public String getRenderAlias();

        public ManagedType<?> getManagedType();

        public Attribute<?, ?> getAttribute();

        public JoinType getJoinType();

        public JoinMode getJoinMode();

        public boolean isFetch();

        public boolean isUsed();

        public boolean isExplicit();

        public Predicate getOn();

        public Entity getParent();

        public List<Entity> getEntities();
    }
}

