/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.babyfish.persistence.criteria.spi.AbstractPath;
import org.babyfish.persistence.criteria.spi.MapAttributeJoin;
import org.babyfish.util.LazyResource;

public class MapKeyPath<K>
extends AbstractPath<K> {
    private static final long serialVersionUID = -2255355353123105873L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    MapKeyAttribute<K> mapKeyAttribute;

    protected MapKeyPath(MapAttributeJoin<?, K, ?> mapAttributeJoin) {
        super(mapAttributeJoin.getCriteriaBuilder(), mapAttributeJoin);
        this.mapKeyAttribute = new MapKeyAttribute<K>(mapAttributeJoin);
    }

    public Bindable<K> getModel() {
        return this.mapKeyAttribute;
    }

    public Class<? extends K> getJavaType() {
        return this.mapKeyAttribute.getJavaType();
    }

    @Override
    protected boolean isReferenceable() {
        return this.mapKeyAttribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC;
    }

    @Override
    protected Attribute<? super K, ?> onLocateAttribute(String attributeName) {
        throw new UnsupportedOperationException(((Resource)LAZY_RESOURCE.get()).unSupportedByMapKeyPath(MapKeyPath.class));
    }

    public MapAttributeJoin<?, K, ?> getParentPath() {
        return (MapAttributeJoin)super.getParentPath();
    }

    private static interface Resource {
        public String unSupportedByMapKeyPath(Class<MapKeyPath> var1);
    }

    private static class MapKeyAttribute<K>
    implements SingularAttribute<Map<K, ?>, K>,
    Serializable {
        private static final long serialVersionUID = -2988284156889184044L;
        private static final Method ENTRY_GET_KEY_METHOD;
        private MapAttributeJoin<?, K, ?> mapAttributeJoin;

        MapKeyAttribute(MapAttributeJoin<?, K, ?> mapAttributeJoin) {
            this.mapAttributeJoin = mapAttributeJoin;
        }

        public ManagedType<Map<K, ?>> getDeclaringType() {
            throw new UnsupportedOperationException(((Resource)LAZY_RESOURCE.get()).unSupportedByMapKeyPath(MapKeyPath.class));
        }

        public Member getJavaMember() {
            return ENTRY_GET_KEY_METHOD;
        }

        public String getName() {
            return "key";
        }

        public Type<K> getType() {
            return this.mapAttributeJoin.getAttribute().getKeyType();
        }

        public Bindable.BindableType getBindableType() {
            return this.isAssociation() ? Bindable.BindableType.ENTITY_TYPE : Bindable.BindableType.SINGULAR_ATTRIBUTE;
        }

        public Class<K> getJavaType() {
            return this.mapAttributeJoin.getAttribute().getKeyJavaType();
        }

        public Class<K> getBindableJavaType() {
            return this.mapAttributeJoin.getAttribute().getKeyJavaType();
        }

        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            Type keyType = this.mapAttributeJoin.getAttribute().getKeyType();
            if (keyType instanceof IdentifiableType) {
                return Attribute.PersistentAttributeType.MANY_TO_ONE;
            }
            if (keyType instanceof ManagedType) {
                return Attribute.PersistentAttributeType.EMBEDDED;
            }
            return Attribute.PersistentAttributeType.BASIC;
        }

        public boolean isAssociation() {
            return this.mapAttributeJoin.getAttribute().getKeyType() instanceof IdentifiableType;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isId() {
            return false;
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isVersion() {
            return false;
        }

        static {
            Method entryGetKeyMethod;
            try {
                entryGetKeyMethod = Map.Entry.class.getDeclaredMethod("getKey", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new AssertionError();
            }
            ENTRY_GET_KEY_METHOD = entryGetKeyMethod;
        }
    }
}

