/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.Collection;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.Arguments;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.lang.Nulls;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.XSubquery;
import org.babyfish.persistence.criteria.ext.DependencyPredicateBuilder;
import org.babyfish.persistence.criteria.ext.SelfGetter;
import org.babyfish.persistence.criteria.ext.SelfGetterFromRestrictedTarget;
import org.babyfish.persistence.criteria.spi.AbstractFrom;
import org.babyfish.util.LazyResource;

public class DependencyPredicateBuilderImpl<S, T>
implements DependencyPredicateBuilder<S, T> {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private AbstractFrom<?, S> from;
    private Class<T> targetType;
    private XOrderedSet<SelfGetter<S, T>> selfGetters;
    private Boolean has;
    private XOrderedMap<SingularAttribute<? super T, ?>, XOrderedSet<?>> includeMap;
    private XOrderedMap<SingularAttribute<? super T, ?>, XOrderedSet<?>> excludeMap;

    public DependencyPredicateBuilderImpl(AbstractFrom<?, S> from, Class<T> targetType) {
        this.from = (AbstractFrom)Arguments.mustNotBeNull((String)"from", from);
        this.targetType = Arguments.mustBeClass((String)"targetType", (Class)((Class)Arguments.mustNotBeNull((String)"targetType", targetType)));
    }

    @Override
    public DependencyPredicateBuilder<S, T> addSelfGetter(SelfGetter<S, T> selfGetter) {
        if (selfGetter != null) {
            LinkedHashSet selfGetters = this.selfGetters;
            if (selfGetters == null) {
                this.selfGetters = selfGetters = new LinkedHashSet();
            }
            selfGetters.add(selfGetter);
        }
        return this;
    }

    @Override
    public DependencyPredicateBuilder<S, T> has(Boolean has) {
        this.has = has;
        return this;
    }

    @Override
    public DependencyPredicateBuilder<S, T> includeAny(Iterable<? extends T> targets) {
        this.includeImpl(null, DependencyPredicateBuilderImpl.orderedSet(targets));
        return this;
    }

    @Override
    public DependencyPredicateBuilder<S, T> includeAny(T ... targets) {
        this.includeImpl(null, DependencyPredicateBuilderImpl.orderedSet(targets));
        return this;
    }

    @Override
    public <V> DependencyPredicateBuilder<S, T> includeAny(SingularAttribute<? super T, V> valueAttribute, Iterable<V> values) {
        this.includeImpl((SingularAttribute)Arguments.mustNotBeNull((String)"valueAttribute", valueAttribute), DependencyPredicateBuilderImpl.orderedSet(values));
        return this;
    }

    @Override
    public <V> DependencyPredicateBuilder<S, T> includeAny(SingularAttribute<? super T, V> valueAttribute, V ... values) {
        this.includeImpl((SingularAttribute)Arguments.mustNotBeNull((String)"valueAttribute", valueAttribute), DependencyPredicateBuilderImpl.orderedSet(values));
        return this;
    }

    @Override
    public DependencyPredicateBuilder<S, T> excludeAll(Iterable<? extends T> targets) {
        this.excludeImpl(null, DependencyPredicateBuilderImpl.orderedSet(targets));
        return this;
    }

    @Override
    public DependencyPredicateBuilder<S, T> excludeAll(T ... targets) {
        this.excludeImpl(null, DependencyPredicateBuilderImpl.orderedSet(targets));
        return this;
    }

    @Override
    public <V> DependencyPredicateBuilder<S, T> excludeAll(SingularAttribute<? super T, V> valueAttribute, Iterable<V> values) {
        this.excludeImpl((SingularAttribute)Arguments.mustNotBeNull((String)"valueAttribute", valueAttribute), DependencyPredicateBuilderImpl.orderedSet(values));
        return this;
    }

    @Override
    public <V> DependencyPredicateBuilder<S, T> excludeAll(SingularAttribute<? super T, V> valueAttribute, V ... values) {
        this.excludeImpl((SingularAttribute)Arguments.mustNotBeNull((String)"valueAttribute", valueAttribute), DependencyPredicateBuilderImpl.orderedSet(values));
        return this;
    }

    @Override
    public Predicate build() {
        if (Nulls.isNullOrEmpty(this.selfGetters)) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).noSelfGetter(DependencyPredicateBuilder.class, SelfGetter.class));
        }
        Boolean has = this.has;
        XOrderedMap<SingularAttribute<? super T, ?>, XOrderedSet<?>> includeMap = this.includeMap;
        XOrderedMap<SingularAttribute<? super T, ?>, XOrderedSet<?>> excludeMap = this.excludeMap;
        if (has == null && Nulls.isNullOrEmpty(includeMap) && Nulls.isNullOrEmpty(excludeMap)) {
            return null;
        }
        Class<T> targetType = this.targetType;
        AbstractFrom<?, S> from = this.from;
        XCriteriaBuilder cb = from.getCriteriaBuilder();
        Predicate predicate = null;
        Predicate negPredicate = null;
        for (SelfGetter selfGetter : this.selfGetters) {
            Path self;
            XRoot target;
            XSubquery<Integer> sq;
            if (Boolean.TRUE.equals(has) || !Nulls.isNullOrEmpty(includeMap)) {
                sq = from.getCommonAbstractCriteria().subquery(Integer.class);
                target = sq.from(targetType);
                self = DependencyPredicateBuilderImpl.safeGetSelf(selfGetter, target);
                sq.where(cb.equal(from, (Expression)self), DependencyPredicateBuilderImpl.targetPredicate(cb, target, selfGetter), DependencyPredicateBuilderImpl.valuePredicate(cb, target, includeMap)).select(cb.constant(0));
                predicate = cb.or((Expression)predicate, (Expression)cb.exists(sq));
            }
            if (!Boolean.FALSE.equals(has) && Nulls.isNullOrEmpty(excludeMap)) continue;
            sq = this.from.getCommonAbstractCriteria().subquery(Integer.class);
            target = sq.from(targetType);
            self = DependencyPredicateBuilderImpl.safeGetSelf(selfGetter, target);
            sq.where(cb.equal(from, (Expression)self), DependencyPredicateBuilderImpl.targetPredicate(cb, target, selfGetter), Boolean.FALSE.equals(has) ? null : DependencyPredicateBuilderImpl.valuePredicate(cb, target, excludeMap)).select(cb.constant(0));
            negPredicate = cb.and((Expression)negPredicate, (Expression)cb.not((Expression)cb.exists(sq)));
        }
        return cb.and((Expression)predicate, (Expression)negPredicate);
    }

    private void includeImpl(SingularAttribute<? super T, ?> valueAttribute, XOrderedSet<?> values) {
        if (Nulls.isNullOrEmpty(values)) {
            return;
        }
        LinkedHashMap includeMap = this.includeMap;
        if (includeMap == null) {
            this.includeMap = includeMap = new LinkedHashMap();
        }
        includeMap.put(valueAttribute, values);
    }

    private void excludeImpl(SingularAttribute<? super T, ?> valueAttribute, XOrderedSet<?> values) {
        if (Nulls.isNullOrEmpty(values)) {
            return;
        }
        LinkedHashMap excludeMap = this.excludeMap;
        if (excludeMap == null) {
            this.excludeMap = excludeMap = new LinkedHashMap();
        }
        excludeMap.put(valueAttribute, values);
    }

    private static <E> XOrderedSet<E> orderedSet(Iterable<E> iterable) {
        if (Nulls.isNullOrEmpty(iterable)) {
            return MACollections.emptyOrderedSet();
        }
        LinkedHashSet set = iterable instanceof Collection ? new LinkedHashSet((((Collection)iterable).size() * 4 + 2) / 3) : new LinkedHashSet();
        for (E e : iterable) {
            if (e == null) continue;
            set.add(e);
        }
        if (set.isEmpty()) {
            return MACollections.emptyOrderedSet();
        }
        return set;
    }

    private static <X, Y> Path<X> safeGetSelf(SelfGetter<X, Y> selfGetter, XRoot<Y> target) {
        Path<X> self = selfGetter.getSelf(target);
        if (self == null) {
            throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).selfGetterCanNotReturnNull(selfGetter.getClass(), "Path<S> getSelf(XRoot<T> target)"));
        }
        return self;
    }

    private static <E> XOrderedSet<E> orderedSet(E[] values) {
        if (Nulls.isNullOrEmpty((Object[])values)) {
            return MACollections.emptyOrderedSet();
        }
        LinkedHashSet set = new LinkedHashSet((values.length * 4 + 2) / 3);
        for (E e : values) {
            if (e == null) continue;
            set.add(e);
        }
        if (set.isEmpty()) {
            return MACollections.emptyOrderedSet();
        }
        return set;
    }

    private static <Y> Predicate targetPredicate(XCriteriaBuilder cb, XRoot<Y> target, SelfGetter<?, Y> selfGetter) {
        if (selfGetter instanceof SelfGetterFromRestrictedTarget) {
            SelfGetterFromRestrictedTarget selfGetterFromRestrictedTarget = (SelfGetterFromRestrictedTarget)selfGetter;
            return selfGetterFromRestrictedTarget.restrictTarget(cb, target);
        }
        return null;
    }

    private static <Y> Predicate valuePredicate(XCriteriaBuilder cb, XRoot<Y> target, XOrderedMap<SingularAttribute<? super Y, ?>, XOrderedSet<?>> valueMap) {
        if (Nulls.isNullOrEmpty(valueMap)) {
            return null;
        }
        Predicate predicate = null;
        for (Map.Entry entry : valueMap.entrySet()) {
            SingularAttribute valueAttribute = (SingularAttribute)entry.getKey();
            if (valueAttribute == null) {
                predicate = cb.or((Expression)predicate, (Expression)cb.in(target, (Iterable)entry.getValue()));
                continue;
            }
            predicate = cb.or((Expression)predicate, (Expression)cb.in(target.get(valueAttribute), (Iterable)entry.getValue()));
        }
        return predicate;
    }

    private static interface Resource {
        public String noSelfGetter(Class<DependencyPredicateBuilder> var1, Class<SelfGetter> var2);

        public String selfGetterCanNotReturnNull(Class<? extends SelfGetter> var1, String var2);
    }
}

