/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.Assignment;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.XCriteriaUpdate;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.XSubquery;
import org.babyfish.persistence.criteria.spi.AbstractNode;
import org.babyfish.persistence.criteria.spi.AssignmentImpl;
import org.babyfish.persistence.criteria.spi.CommonCriteriaStructure;
import org.babyfish.persistence.criteria.spi.CriteriaSubqueryImpl;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class CriteriaUpdateImpl<T>
extends AbstractNode
implements XCriteriaUpdate<T> {
    private static final long serialVersionUID = -779353911411874272L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private CommonCriteriaStructure commonCriteriaStructure = new CommonCriteriaStructure(this);
    private XRoot<T> root;
    private List<Assignment> assignments = new ArrayList();

    protected CriteriaUpdateImpl(XCriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    @Override
    public XRoot<T> getRoot() {
        return this.root;
    }

    @Override
    public List<Assignment> getAssignments() {
        return MACollections.unmodifiable(this.assignments);
    }

    public Predicate getRestriction() {
        return this.commonCriteriaStructure.getRestriction();
    }

    @Override
    public <U> XSubquery<U> subquery(Class<U> type) {
        this.checkState();
        return new CriteriaSubqueryImpl<U>(this, type);
    }

    @Override
    public XRoot<T> from(Class<T> entityClass) {
        this.checkState();
        this.rootMustBeNull();
        this.root = this.commonCriteriaStructure.createRoot(entityClass);
        return this.root;
    }

    @Override
    public XRoot<T> from(EntityType<T> entity) {
        this.checkState();
        this.rootMustBeNull();
        this.root = this.commonCriteriaStructure.createRoot(entity);
        return this.root;
    }

    @Override
    public <Y, X extends Y> XCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        this.checkState();
        this.rootMustNotBeNull();
        Path path = this.root.get(attribute);
        Expression expression = value == null ? this.getCriteriaBuilder().nullLiteral(path.getJavaType()) : this.getCriteriaBuilder().literal(value);
        this.assignments.add(new AssignmentImpl(this.getCriteriaBuilder(), path, expression));
        return this;
    }

    @Override
    public <Y> XCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        this.checkState();
        this.rootMustNotBeNull();
        Path path = this.root.get(attribute);
        this.assignments.add(new AssignmentImpl(this.getCriteriaBuilder(), path, value));
        return this;
    }

    @Override
    public <Y, X extends Y> XCriteriaUpdate<T> set(Path<Y> attribute, X value) {
        this.checkState();
        this.rootMustNotBeNull();
        this.pathMustBeChildOfRoot(attribute);
        Expression expression = value == null ? this.getCriteriaBuilder().nullLiteral(attribute.getJavaType()) : this.getCriteriaBuilder().literal(value);
        this.assignments.add(new AssignmentImpl(this.getCriteriaBuilder(), attribute, expression));
        return this;
    }

    @Override
    public <Y> XCriteriaUpdate<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.checkState();
        this.rootMustNotBeNull();
        this.pathMustBeChildOfRoot(attribute);
        this.assignments.add(new AssignmentImpl(this.getCriteriaBuilder(), attribute, value));
        return this;
    }

    @Override
    public XCriteriaUpdate<T> set(String attributeName, Object value) {
        this.checkState();
        this.rootMustNotBeNull();
        Path path = this.root.get(attributeName);
        Expression expression = value == null ? this.getCriteriaBuilder().nullLiteral(path.getJavaType()) : this.getCriteriaBuilder().literal(value);
        this.assignments.add(new AssignmentImpl(this.getCriteriaBuilder(), path, expression));
        return this;
    }

    @Override
    public XCriteriaUpdate<T> where(Expression<Boolean> restriction) {
        this.checkState();
        this.commonCriteriaStructure.where(restriction);
        return this;
    }

    @Override
    public XCriteriaUpdate<T> where(Predicate ... restrictions) {
        this.checkState();
        this.commonCriteriaStructure.where(restrictions);
        return this;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCriteriaUpdate(this);
    }

    private void rootMustBeNull() {
        if (this.root != null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).rootMustBeNull(this.getClass()));
        }
    }

    private void rootMustNotBeNull() {
        if (this.root == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).rootMustNotBeNull(this.getClass()));
        }
    }

    private void pathMustBeChildOfRoot(Path<?> attribute) {
        Arguments.mustBeInstanceOfValue((String)"attribute.getModel()", (Object)attribute.getModel(), SingularAttribute.class);
        for (Path parent = attribute.getParentPath(); parent != null; parent = parent.getParentPath()) {
            if (parent != this.root) continue;
            return;
        }
        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).pathMustBeChildOfRoot(this.getClass()));
    }

    private static interface Resource {
        public String rootMustBeNull(Class<?> var1);

        public String rootMustNotBeNull(Class<?> var1);

        public String pathMustBeChildOfRoot(Class<?> var1);
    }
}

