/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.Collection;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.XCriteriaQuery;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.XSubquery;
import org.babyfish.persistence.criteria.spi.AbstractNode;
import org.babyfish.persistence.criteria.spi.AbstractVisitor;
import org.babyfish.persistence.criteria.spi.CriteriaSubqueryImpl;
import org.babyfish.persistence.criteria.spi.QueryStructure;
import org.babyfish.persistence.criteria.spi.Visitor;

public class CriteriaQueryImpl<T>
extends AbstractNode
implements XCriteriaQuery<T> {
    private static final long serialVersionUID = 5646747751090857605L;
    private QueryStructure<T> queryStructure;
    private List<Order> orderList;

    protected CriteriaQueryImpl(XCriteriaBuilder criteriaBuilder, Class<T> resultType) {
        super(criteriaBuilder);
        this.queryStructure = new QueryStructure(this, (Class)Arguments.mustNotBeNull((String)"resultType", resultType));
    }

    @Override
    public XOrderedSet<ParameterExpression<?>> getParameters() {
        LinkedHashSet parameters = new LinkedHashSet();
        this.accept(new ParameterVisitor((XOrderedSet<ParameterExpression<?>>)parameters));
        return parameters;
    }

    public Class<T> getResultType() {
        return this.queryStructure.getResultType();
    }

    public boolean isDistinct() {
        return this.queryStructure.isDistinct();
    }

    public Selection<T> getSelection() {
        return this.queryStructure.getSelection();
    }

    @Override
    public XOrderedSet<Root<?>> getRoots() {
        return this.getXRoots();
    }

    @Override
    public XOrderedSet<XRoot<?>> getXRoots() {
        return this.queryStructure.getXRoots();
    }

    public Predicate getRestriction() {
        return this.queryStructure.getRestriction();
    }

    public List<Expression<?>> getGroupList() {
        return this.queryStructure.getGroupList();
    }

    public Predicate getGroupRestriction() {
        return this.queryStructure.getGroupRestriction();
    }

    public List<Order> getOrderList() {
        List<Order> orderList = this.orderList;
        if (orderList == null) {
            return MACollections.emptyList();
        }
        return orderList;
    }

    @Override
    public XCriteriaQuery<T> distinct(boolean distinct) {
        this.checkState();
        this.queryStructure.distinct(distinct);
        return this;
    }

    @Override
    public XCriteriaQuery<T> select(Selection<? extends T> selection) {
        this.checkState();
        this.queryStructure.select(selection);
        return this;
    }

    @Override
    public XCriteriaQuery<T> multiselect(Selection<?> ... selections) {
        return this.multiselect((List)MACollections.wrap((Object[])selections));
    }

    @Override
    public XCriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        Object selection;
        this.checkState();
        if (Tuple.class.isAssignableFrom(this.getResultType())) {
            selection = this.getCriteriaBuilder().tuple(selectionList);
        } else if (this.getResultType().isArray()) {
            selection = this.getCriteriaBuilder().array(selectionList);
        } else if (Object.class.equals(this.getResultType())) {
            switch (selectionList.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    selection = selectionList.get(0);
                    break;
                }
                default: {
                    selection = this.getCriteriaBuilder().array(selectionList);
                    break;
                }
            }
        } else {
            selection = this.getCriteriaBuilder().construct(this.getResultType(), selectionList);
        }
        return this.select((Selection)selection);
    }

    @Override
    public <X> XRoot<X> from(Class<X> entityClass) {
        this.checkState();
        return this.queryStructure.from(entityClass);
    }

    @Override
    public <X> XRoot<X> from(EntityType<X> entityType) {
        this.checkState();
        return this.queryStructure.from(entityType);
    }

    @Override
    public XCriteriaQuery<T> where(Expression<Boolean> restriction) {
        this.checkState();
        this.queryStructure.where(restriction);
        return this;
    }

    @Override
    public XCriteriaQuery<T> where(Predicate ... restrictions) {
        this.checkState();
        this.queryStructure.where(restrictions);
        return this;
    }

    @Override
    public XCriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        this.checkState();
        this.queryStructure.groupBy(grouping);
        return this;
    }

    @Override
    public XCriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        this.checkState();
        this.queryStructure.groupBy(grouping);
        return this;
    }

    @Override
    public XCriteriaQuery<T> having(Expression<Boolean> restriction) {
        this.checkState();
        this.queryStructure.having(restriction);
        return this;
    }

    @Override
    public XCriteriaQuery<T> having(Predicate ... restrictions) {
        this.checkState();
        this.queryStructure.having(restrictions);
        return this;
    }

    @Override
    public XCriteriaQuery<T> orderBy(Order ... o) {
        return this.orderBy((List)MACollections.wrap((Object[])o));
    }

    @Override
    public XCriteriaQuery<T> orderBy(List<Order> o) {
        Object orderList;
        this.checkState();
        if (o != null && !o.isEmpty()) {
            orderList = new ArrayList(o.size());
            for (Order order : o) {
                if (order == null) continue;
                orderList.add(order);
            }
            orderList = orderList.isEmpty() ? null : MACollections.unmodifiable((List)orderList);
        } else {
            orderList = null;
        }
        this.orderList = orderList;
        return this;
    }

    @Override
    public <U> XSubquery<U> subquery(Class<U> type) {
        this.checkState();
        return new CriteriaSubqueryImpl<U>(this, type);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCriteriaQuery(this);
    }

    private static class ParameterVisitor
    extends AbstractVisitor {
        private Collection<ParameterExpression<?>> parameters;

        ParameterVisitor(XOrderedSet<ParameterExpression<?>> parameters) {
            this.parameters = parameters;
        }

        @Override
        public void visitParameterExpression(ParameterExpression<?> parameterExpression) {
            this.parameters.add(parameterExpression);
        }
    }
}

