/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.EntityType;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCommonAbstractCriteria;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.spi.AbstractPredicate;
import org.babyfish.persistence.criteria.spi.RootImpl;
import org.babyfish.util.LazyResource;

class CommonCriteriaStructure {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private XCommonAbstractCriteria owner;
    private Predicate restriction;

    CommonCriteriaStructure(XCommonAbstractCriteria owner) {
        this.owner = owner;
    }

    public XCommonAbstractCriteria getOwner() {
        return this.owner;
    }

    public Predicate getRestriction() {
        return this.restriction;
    }

    public <X> XRoot<X> createRoot(Class<X> entityClass) {
        EntityType entityType;
        try {
            entityType = this.owner.getCriteriaBuilder().getEntityManagerFactory().getMetamodel().entity(entityClass);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).invalidJPAEntityClass(entityClass), ex);
        }
        return this.createRoot(entityType);
    }

    public <X> XRoot<X> createRoot(EntityType<X> entity) {
        return new RootImpl(this.owner, (EntityType)Arguments.mustNotBeNull((String)"entity", entity));
    }

    public void where(Expression<Boolean> restriction) {
        Predicate predicate = this.owner.getCriteriaBuilder().isTrue(restriction);
        this.restriction = AbstractPredicate.isNullOrEmpty((Expression<Boolean>)predicate) ? null : predicate;
    }

    public void where(Predicate ... restrictions) {
        Predicate predicate = this.owner.getCriteriaBuilder().and(restrictions);
        this.restriction = AbstractPredicate.isNullOrEmpty((Expression<Boolean>)predicate) ? null : predicate;
    }

    private static interface Resource {
        public String invalidJPAEntityClass(Class<?> var1);
    }
}

