/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.XEntityManager;
import org.babyfish.persistence.XQuery;
import org.babyfish.persistence.XTypedQuery;
import org.babyfish.persistence.criteria.QueryTemplate;
import org.babyfish.persistence.criteria.XCommonAbstractCriteria;
import org.babyfish.persistence.criteria.XCriteriaQuery;

public abstract class AbstractQueryTemplate<T>
implements QueryTemplate<T> {
    private Class<T> resultType;
    private CompoundSelection<Tuple> tupleSelection;
    private String jpql;
    private Collection<LiteralParameter> literalParameters;

    protected AbstractQueryTemplate(XCommonAbstractCriteria commonAbstractCriteria) {
        if (commonAbstractCriteria instanceof XCriteriaQuery) {
            XCriteriaQuery query = (XCriteriaQuery)commonAbstractCriteria;
            this.resultType = query.getResultType();
            if (this.resultType == Tuple.class) {
                this.tupleSelection = (CompoundSelection)query.getSelection();
            }
        }
        this.init(commonAbstractCriteria);
    }

    @Override
    public Class<T> getResultType() {
        return this.resultType;
    }

    @Override
    public XTypedQuery<T> createQuery(XEntityManager entityManager) {
        XTypedQuery<T> query = entityManager.createQuery(this.jpql, this.getResultType());
        if (this.tupleSelection != null) {
            this.setTupleTransfromer(query, this.tupleSelection);
        }
        for (LiteralParameter ip : this.literalParameters) {
            query.setParameter(ip.getName(), ip.getValue());
        }
        return query;
    }

    @Override
    public Query createUpdate(XEntityManager entityManager) {
        XQuery query = entityManager.createQuery(this.jpql);
        for (LiteralParameter ip : this.literalParameters) {
            query.setParameter(ip.getName(), ip.getValue());
        }
        return query;
    }

    @Override
    public Query createDelete(XEntityManager entityManager) {
        XQuery query = entityManager.createQuery(this.jpql);
        for (LiteralParameter ip : this.literalParameters) {
            query.setParameter(ip.getName(), ip.getValue());
        }
        return query;
    }

    public String toString() {
        return this.jpql;
    }

    protected abstract void init(XCommonAbstractCriteria var1);

    protected abstract void setTupleTransfromer(XTypedQuery<?> var1, CompoundSelection<Tuple> var2);

    protected final void init(String jpql, Collection<LiteralParameter> implictParameters) {
        Arguments.mustNotBeNull((String)"jpql", (Object)jpql);
        Arguments.mustNotBeEmpty((String)"jpql", (String)jpql);
        this.jpql = jpql;
        this.literalParameters = implictParameters == null ? MACollections.emptySet() : MACollections.unmodifiable(implictParameters);
    }

    protected static final class LiteralParameter
    implements Serializable {
        private static final long serialVersionUID = 336399478255717833L;
        private String name;
        private Object value;

        public LiteralParameter(int literalPosition, Object value) {
            this.name = "babyfish_literal_" + literalPosition;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

