/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.Collection;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.collection.HashMap;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.expression.PathTypeExpression;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.PluralAttributePath;
import org.babyfish.persistence.criteria.spi.SingularAttributePath;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public abstract class AbstractPath<X>
extends AbstractExpression<X>
implements Path<X> {
    private static final long serialVersionUID = 1763608393496615508L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Path<?> parentPath;
    private Map<String, AbstractPath<?>> pathMap;
    private transient Expression<Class<? extends X>> typeExpression;

    protected AbstractPath(XCriteriaBuilder criteriaBuilder, Path<?> parentPath) {
        super(criteriaBuilder);
        this.mustUnderSameCriteriaBuilder("parentPath", parentPath);
        this.parentPath = parentPath;
    }

    protected abstract boolean isReferenceable();

    protected final <Y> Attribute<X, Y> locateAttribute(String attributeName) {
        Attribute<X, ?> attribute = this.onLocateAttribute(attributeName);
        if (attribute == null) {
            this.throwUnknowAttributeException(attributeName);
        }
        return attribute;
    }

    protected abstract Attribute<? super X, ?> onLocateAttribute(String var1);

    protected void throwIllegalReferenceException() {
        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).illegalReference());
    }

    protected void throwUnknowAttributeException(String attributeName) {
        throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).illegalAttributeName(attributeName));
    }

    public <Y> Path<Y> get(SingularAttribute<? super X, Y> attribute) {
        Map pathMap;
        SingularAttributePath<Y> path;
        if (!this.isReferenceable()) {
            this.throwIllegalReferenceException();
        }
        if ((path = (SingularAttributePath<Y>)(pathMap = this.getPathMap()).get(attribute.getName())) == null) {
            path = new SingularAttributePath<Y>(this, attribute);
            pathMap.put(attribute.getName(), path);
        }
        return path;
    }

    public <E, C extends Collection<E>> Expression<C> get(PluralAttribute<X, C, E> collection) {
        Map pathMap;
        PluralAttributePath<C> path;
        if (!this.isReferenceable()) {
            this.throwIllegalReferenceException();
        }
        if ((path = (PluralAttributePath<C>)(pathMap = this.getPathMap()).get(collection.getName())) == null) {
            path = new PluralAttributePath<C>(this, collection);
            pathMap.put(collection.getName(), path);
        }
        return path;
    }

    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<X, K, V> map) {
        Map pathMap;
        PluralAttributePath<K> path;
        if (!this.isReferenceable()) {
            this.throwIllegalReferenceException();
        }
        if ((path = (PluralAttributePath<K>)(pathMap = this.getPathMap()).get(map.getName())) == null) {
            path = new PluralAttributePath<K>(this, map);
        }
        return path;
    }

    public <Y> Path<Y> get(String attributeName) {
        Attribute<X, Y> attribute;
        if (!this.isReferenceable()) {
            this.throwIllegalReferenceException();
        }
        if ((attribute = this.locateAttribute(attributeName)).isCollection()) {
            if (((PluralAttribute)attribute).getCollectionType() == PluralAttribute.CollectionType.MAP) {
                return (Path)this.get((MapAttribute)attribute);
            }
            return (Path)this.get((PluralAttribute)attribute);
        }
        return this.get((SingularAttribute)attribute);
    }

    public Path<?> getParentPath() {
        return this.parentPath;
    }

    public Expression<Class<? extends X>> type() {
        Expression<Class<? extends X>> typeExpression = this.typeExpression;
        if (typeExpression == null) {
            this.typeExpression = typeExpression = new PathTypeExpression<X>(this.getCriteriaBuilder(), this);
        }
        return typeExpression;
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.visitPath(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Path<? super X> getTreatedParent() {
        return null;
    }

    private <Y, P extends AbstractPath<Y>> Map<String, P> getPathMap() {
        HashMap pathMap = this.pathMap;
        if (pathMap == null) {
            this.pathMap = pathMap = new HashMap();
        }
        return pathMap;
    }

    private static interface Resource {
        public String illegalReference();

        public String illegalAttributeName(String var1);
    }
}

