/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.JoinMode;
import org.babyfish.persistence.criteria.XCommonAbstractCriteria;
import org.babyfish.persistence.criteria.XFrom;
import org.babyfish.persistence.criteria.XJoin;
import org.babyfish.persistence.criteria.spi.AbstractFrom;
import org.babyfish.persistence.criteria.spi.AbstractPredicate;
import org.babyfish.util.LazyResource;

public abstract class AbstractJoin<Z, X>
extends AbstractFrom<Z, X>
implements XJoin<Z, X> {
    private static final long serialVersionUID = 1924213188607394413L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private AbstractFrom<?, Z> parent;
    private Attribute<? super Z, ?> attribute;
    private JoinType joinType;
    private JoinMode joinMode;
    private Predicate on;

    protected AbstractJoin(AbstractFrom<?, Z> parent, Attribute<? super Z, ?> attribute, JoinType joinType, JoinMode joinMode) {
        super((XCommonAbstractCriteria)parent.getCommonAbstractCriteria(), (Path<?>)((Path)Arguments.mustNotBeNull((String)"parent", parent)));
        this.parent = parent;
        this.attribute = (Attribute)Arguments.mustNotBeNull((String)"attribute", attribute);
        this.joinType = (JoinType)Arguments.mustNotBeNull((String)"joinType", (Object)joinType);
        this.joinMode = (JoinMode)((Object)Arguments.mustNotBeNull((String)"joinMode", (Object)((Object)joinMode)));
    }

    protected AbstractJoin(AbstractJoin<Z, X> correlationParent) {
        super(correlationParent);
        this.parent = correlationParent.parent;
        this.attribute = correlationParent.getAttribute();
        this.joinType = correlationParent.getJoinType();
    }

    public Attribute<? super Z, ?> getAttribute() {
        return this.attribute;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public JoinMode getJoinMode() {
        return this.joinMode;
    }

    @Override
    public XFrom<?, Z> getParent() {
        return this.parent;
    }

    @Override
    public XJoin<Z, X> getCorrelationParent() {
        return (XJoin)super.getCorrelationParent();
    }

    @Override
    public XJoin<Z, X> alias(String alias) {
        return (XJoin)super.alias(alias);
    }

    @Override
    public XJoin<Z, X> on(Expression<Boolean> restriction) {
        Predicate predicate = this.getCriteriaBuilder().isTrue(restriction);
        this.setOn(predicate);
        return this;
    }

    @Override
    public XJoin<Z, X> on(Predicate ... restrictions) {
        Predicate predicate = this.getCriteriaBuilder().and(restrictions);
        this.setOn(predicate);
        return this;
    }

    public Predicate getOn() {
        return this.on;
    }

    void mergeJoinType(JoinType joinType) {
        if (this.joinType != joinType) {
            this.joinType = JoinType.INNER;
        }
    }

    public Class<? extends X> getJavaType() {
        return this.attribute.getJavaType();
    }

    @Override
    public String toString() {
        return this.getParent().toString() + ' ' + this.joinType.name().toLowerCase() + " join(mode = " + this.joinMode.name().toLowerCase() + ") " + this.attribute.getName();
    }

    private void setOn(Predicate on) {
        if (AbstractPredicate.isNullOrEmpty((Expression<Boolean>)on)) {
            this.on = null;
        } else {
            if (!this.joinMode.isNew()) {
                throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).mergeJoinDoesNotSupportOn(JoinMode.OPTIONALLY_MERGE_EXISTS, JoinMode.REQUIRED_TO_MERGE_EXISTS));
            }
            this.on = on;
        }
    }

    private static interface Resource {
        public String mergeJoinDoesNotSupportOn(JoinMode ... var1);
    }
}

