/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;

public abstract class AbstractFunction<T>
extends AbstractExpression<T> {
    private static final long serialVersionUID = -7912944348630654988L;
    private static final List<Expression<?>> EMPTY_ARGUMENT_EXPRESSIONS = MACollections.emptyList();
    private String functionName;
    private List<Expression<?>> argumentExpressions;

    protected AbstractFunction(XCriteriaBuilder criteriaBuilder, String functionName, Expression<?> ... argumentExpressions) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"functionName", (Object)functionName);
        Arguments.mustNotBeNull((String)"argumentExpressions", argumentExpressions);
        this.functionName = functionName;
        this.initArgumentExpressions((Expression[])argumentExpressions.clone());
    }

    protected AbstractFunction(XCriteriaBuilder criteriaBuilder, String functionName, Collection<Expression<?>> argumentExpressions) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"functionName", (Object)functionName);
        Arguments.mustNotBeNull((String)"argumentExpressions", argumentExpressions);
        this.functionName = functionName;
        this.initArgumentExpressions(argumentExpressions.toArray(new Expression[argumentExpressions.size()]));
    }

    private void initArgumentExpressions(Expression<?>[] argumentExpressions) {
        if (argumentExpressions.length == 0) {
            this.argumentExpressions = EMPTY_ARGUMENT_EXPRESSIONS;
        } else {
            for (int i = 0; i < argumentExpressions.length; ++i) {
                if (argumentExpressions[i] == null) {
                    Arguments.mustNotBeNull((String)("argumentExpressions[" + i + "]"), argumentExpressions[i]);
                }
                this.mustUnderSameCriteriaBuilder("argumentExpressions[" + i + ']', argumentExpressions[i]);
            }
            this.argumentExpressions = MACollections.wrap((Object[])argumentExpressions);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Expression<?>> getArguments() {
        return this.argumentExpressions;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitFunction(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

