/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.LikeMode;
import org.babyfish.persistence.criteria.XCollectionJoin;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.XCriteriaDelete;
import org.babyfish.persistence.criteria.XCriteriaQuery;
import org.babyfish.persistence.criteria.XCriteriaUpdate;
import org.babyfish.persistence.criteria.XJoin;
import org.babyfish.persistence.criteria.XListJoin;
import org.babyfish.persistence.criteria.XMapJoin;
import org.babyfish.persistence.criteria.XRoot;
import org.babyfish.persistence.criteria.XSetJoin;
import org.babyfish.persistence.criteria.expression.AbsFunction;
import org.babyfish.persistence.criteria.expression.Aggregation;
import org.babyfish.persistence.criteria.expression.BetweenPredicate;
import org.babyfish.persistence.criteria.expression.BinaryArithmeticExpression;
import org.babyfish.persistence.criteria.expression.CoalesceExpression;
import org.babyfish.persistence.criteria.expression.ComparisonPredicate;
import org.babyfish.persistence.criteria.expression.CompoundPredicate;
import org.babyfish.persistence.criteria.expression.CompoundSelectionImpl;
import org.babyfish.persistence.criteria.expression.ConcatExpression;
import org.babyfish.persistence.criteria.expression.ConstantExpression;
import org.babyfish.persistence.criteria.expression.ConvertExpression;
import org.babyfish.persistence.criteria.expression.CurrentDateFunction;
import org.babyfish.persistence.criteria.expression.CurrentDatestampFunction;
import org.babyfish.persistence.criteria.expression.CurrentTimeFunction;
import org.babyfish.persistence.criteria.expression.ExistsPredicate;
import org.babyfish.persistence.criteria.expression.InPredicate;
import org.babyfish.persistence.criteria.expression.IsEmptyPredicate;
import org.babyfish.persistence.criteria.expression.IsMemberPredicate;
import org.babyfish.persistence.criteria.expression.IsTruePredicate;
import org.babyfish.persistence.criteria.expression.LengthFunction;
import org.babyfish.persistence.criteria.expression.LikePredicate;
import org.babyfish.persistence.criteria.expression.LiteralExpression;
import org.babyfish.persistence.criteria.expression.LocateFunction;
import org.babyfish.persistence.criteria.expression.LowerFunction;
import org.babyfish.persistence.criteria.expression.NullLiteralExpression;
import org.babyfish.persistence.criteria.expression.NullifExpression;
import org.babyfish.persistence.criteria.expression.NullnessPredicate;
import org.babyfish.persistence.criteria.expression.ParameterExpressionImpl;
import org.babyfish.persistence.criteria.expression.SearchedCaseExpression;
import org.babyfish.persistence.criteria.expression.SimpleCaseExpression;
import org.babyfish.persistence.criteria.expression.SizeExpression;
import org.babyfish.persistence.criteria.expression.SqrtFunction;
import org.babyfish.persistence.criteria.expression.SubqueryComparisonModifierExpression;
import org.babyfish.persistence.criteria.expression.SubstringFunction;
import org.babyfish.persistence.criteria.expression.TrimExpression;
import org.babyfish.persistence.criteria.expression.UnaryArithmeticExpression;
import org.babyfish.persistence.criteria.expression.UpperFunction;
import org.babyfish.persistence.criteria.ext.DependencyPredicateBuilder;
import org.babyfish.persistence.criteria.spi.AbstractFrom;
import org.babyfish.persistence.criteria.spi.AbstractFunction;
import org.babyfish.persistence.criteria.spi.CollectionAttributeJoin;
import org.babyfish.persistence.criteria.spi.CriteriaDeleteImpl;
import org.babyfish.persistence.criteria.spi.CriteriaQueryImpl;
import org.babyfish.persistence.criteria.spi.CriteriaUpdateImpl;
import org.babyfish.persistence.criteria.spi.DependencyPredicateBuilderImpl;
import org.babyfish.persistence.criteria.spi.ListAttributeJoin;
import org.babyfish.persistence.criteria.spi.MapAttributeJoin;
import org.babyfish.persistence.criteria.spi.OrderImpl;
import org.babyfish.persistence.criteria.spi.PluralAttributePath;
import org.babyfish.persistence.criteria.spi.RootImpl;
import org.babyfish.persistence.criteria.spi.SetAttributeJoin;
import org.babyfish.persistence.criteria.spi.SingularAttributeJoin;
import org.babyfish.persistence.criteria.spi.SingularAttributePath;
import org.babyfish.persistence.criteria.spi.TreatedCollectionAttributeJoin;
import org.babyfish.persistence.criteria.spi.TreatedListAttributeJoin;
import org.babyfish.persistence.criteria.spi.TreatedMapAttributeJoin;
import org.babyfish.persistence.criteria.spi.TreatedRootImpl;
import org.babyfish.persistence.criteria.spi.TreatedSetAttributeJoin;
import org.babyfish.persistence.criteria.spi.TreatedSingularAttributeJoin;
import org.babyfish.persistence.criteria.spi.TreatedSingularAttributePath;

public abstract class AbstractCriteriaBuilder
implements XCriteriaBuilder {
    private Expression<Character> defaultTrimCharacter = this.constant(Character.valueOf(' '));

    @Override
    public XCriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this, Object.class);
    }

    @Override
    public <T> XCriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new CriteriaQueryImpl<T>(this, resultClass);
    }

    @Override
    public XCriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this, Tuple.class);
    }

    @Override
    public <T> XCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new CriteriaUpdateImpl(this);
    }

    @Override
    public <T> XCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        return new CriteriaDeleteImpl(this);
    }

    @Override
    public <Y> CompoundSelection<Y> construct(Class<Y> resultClass, Iterable<Selection<?>> selections) {
        return new CompoundSelectionImpl<Y>(this, resultClass, selections);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> resultClass, Selection<?> ... selections) {
        return this.construct(resultClass, (Iterable<Selection<?>>)MACollections.wrap((Object[])selections));
    }

    @Override
    public CompoundSelection<Tuple> tuple(Iterable<Selection<?>> selections) {
        return new CompoundSelectionImpl<Tuple>(this, Tuple.class, selections);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.tuple((Iterable<Selection<?>>)MACollections.wrap((Object[])selections));
    }

    @Override
    public CompoundSelection<Object[]> array(Iterable<Selection<?>> selections) {
        return new CompoundSelectionImpl<Object[]>(this, Object[].class, selections);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.array((Iterable<Selection<?>>)MACollections.wrap((Object[])selections));
    }

    public Order asc(Expression<?> x) {
        return new OrderImpl(this, x, true);
    }

    public Order desc(Expression<?> x) {
        return new OrderImpl(this, x, false);
    }

    public <N extends Number> Expression<Double> avg(Expression<N> x) {
        return new Aggregation.Avg<N>((XCriteriaBuilder)this, x);
    }

    public <N extends Number> Expression<N> sum(Expression<N> x) {
        return new Aggregation.Sum<N>((XCriteriaBuilder)this, x);
    }

    public Expression<Long> sumAsLong(Expression<Integer> x) {
        return new Aggregation.SumAsLong((XCriteriaBuilder)this, x);
    }

    public Expression<Double> sumAsDouble(Expression<Float> x) {
        return new Aggregation.SumAsDouble((XCriteriaBuilder)this, x);
    }

    public <N extends Number> Expression<N> max(Expression<N> x) {
        return new Aggregation.Max<N>((XCriteriaBuilder)this, x);
    }

    public <N extends Number> Expression<N> min(Expression<N> x) {
        return new Aggregation.Min<N>((XCriteriaBuilder)this, x);
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> x) {
        return new Aggregation.Greatest<X>((XCriteriaBuilder)this, x);
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> x) {
        return new Aggregation.Least<X>((XCriteriaBuilder)this, x);
    }

    public Expression<Long> count(Expression<?> x) {
        return new Aggregation.Count((XCriteriaBuilder)this, x, false);
    }

    public Expression<Long> countDistinct(Expression<?> x) {
        return new Aggregation.Count((XCriteriaBuilder)this, x, true);
    }

    public Predicate exists(Subquery<?> subquery) {
        return new ExistsPredicate(this, subquery);
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression.All<Y>(this, subquery);
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression.Some<Y>(this, subquery);
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression.Any<Y>(this, subquery);
    }

    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return CompoundPredicate.of(this, Predicate.BooleanOperator.AND, this.isTrue(x), this.isTrue(y));
    }

    public Predicate and(Predicate ... restrictions) {
        return CompoundPredicate.of(this, Predicate.BooleanOperator.AND, restrictions);
    }

    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return CompoundPredicate.of(this, Predicate.BooleanOperator.OR, this.isTrue(x), this.isTrue(y));
    }

    public Predicate or(Predicate ... restrictions) {
        return CompoundPredicate.of(this, Predicate.BooleanOperator.OR, restrictions);
    }

    public Predicate not(Expression<Boolean> restriction) {
        Predicate predicate = this.isTrue(restriction);
        if (predicate != null) {
            predicate = predicate.not();
        }
        return predicate;
    }

    public Predicate conjunction() {
        return null;
    }

    public Predicate disjunction() {
        return null;
    }

    public Predicate isTrue(Expression<Boolean> x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Predicate) {
            return (Predicate)x;
        }
        return new IsTruePredicate(this, x);
    }

    public Predicate isFalse(Expression<Boolean> x) {
        return this.not((Expression<Boolean>)this.isTrue(x));
    }

    public Predicate isNull(Expression<?> x) {
        return new NullnessPredicate(this, x);
    }

    public Predicate isNotNull(Expression<?> x) {
        return this.not((Expression<Boolean>)this.isNull(x));
    }

    public Predicate equal(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate.Equal(this, x, y);
    }

    public Predicate equal(Expression<?> x, Object y) {
        return this.equal(x, this.literal(y));
    }

    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate.NotEqual(this, x, y);
    }

    public Predicate notEqual(Expression<?> x, Object y) {
        return this.notEqual(x, this.literal(y));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate.GreaterThan(this, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        return this.greaterThan(x, (Y)this.literal(y));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate.GreaterThanOrEqual(this, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.greaterThanOrEqualTo(x, (Y)this.literal(y));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate.LessThan(this, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        return this.lessThan(x, (Y)this.literal(y));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate.LessThanOrEqual(this, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.lessThanOrEqualTo(x, (Y)this.literal(y));
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Expression<? extends Y> x, Expression<? extends Y> y) {
        if (x == null && y == null) {
            return null;
        }
        return new BetweenPredicate<Y>(this, v, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Y x, Y y) {
        return this.between(v, (Y)(x != null ? this.literal(x) : null), (Y)(y != null ? this.literal(y) : null));
    }

    public Predicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate.GreaterThan(this, x, y);
    }

    public Predicate gt(Expression<? extends Number> x, Number y) {
        return this.gt(x, this.literal(y));
    }

    public Predicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate.GreaterThanOrEqual(this, x, y);
    }

    public Predicate ge(Expression<? extends Number> x, Number y) {
        return this.ge(x, this.literal(y));
    }

    public Predicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate.LessThan(this, x, y);
    }

    public Predicate lt(Expression<? extends Number> x, Number y) {
        return this.lt(x, this.literal(y));
    }

    public Predicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate.LessThanOrEqual(this, x, y);
    }

    public Predicate le(Expression<? extends Number> x, Number y) {
        return this.le(x, this.literal(y));
    }

    public <N extends Number> Expression<N> neg(Expression<N> x) {
        return new UnaryArithmeticExpression.Neg<N>(this, x);
    }

    public <N extends Number> Expression<N> abs(Expression<N> x) {
        return new AbsFunction<N>(this, x);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryArithmeticExpression.Sum(this, x, y);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, N y) {
        return this.sum((N)x, (Expression<? extends N>)this.literal(y));
    }

    public <N extends Number> Expression<N> sum(N x, Expression<? extends N> y) {
        return this.sum((N)this.literal(x), y);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryArithmeticExpression.Diff(this, x, y);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, N y) {
        return this.diff((N)x, (Expression<? extends N>)this.literal(y));
    }

    public <N extends Number> Expression<N> diff(N x, Expression<? extends N> y) {
        return this.diff((N)this.literal(x), y);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryArithmeticExpression.Prod(this, x, y);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, N y) {
        return this.prod((N)x, (Expression<? extends N>)this.literal(y));
    }

    public <N extends Number> Expression<N> prod(N x, Expression<? extends N> y) {
        return this.prod((N)this.literal(x), y);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryArithmeticExpression.Quot<Number>(this, x, y);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Number y) {
        return this.quot(x, this.literal(y));
    }

    public Expression<Number> quot(Number x, Expression<? extends Number> y) {
        return this.quot(this.literal(x), y);
    }

    public Expression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return new BinaryArithmeticExpression.Mod((XCriteriaBuilder)this, (Expression<? extends Integer>)x, (Expression<? extends Integer>)y);
    }

    public Expression<Integer> mod(Expression<Integer> x, Integer y) {
        return this.mod(x, this.literal(y));
    }

    public Expression<Integer> mod(Integer x, Expression<Integer> y) {
        return this.mod(this.literal(x), y);
    }

    public Expression<Double> sqrt(Expression<? extends Number> x) {
        return new SqrtFunction(this, x);
    }

    public Expression<Integer> toInteger(Expression<? extends Number> number) {
        return new ConvertExpression.ToInteger((XCriteriaBuilder)this, number);
    }

    public Expression<Long> toLong(Expression<? extends Number> number) {
        return new ConvertExpression.ToLong((XCriteriaBuilder)this, number);
    }

    public Expression<Float> toFloat(Expression<? extends Number> number) {
        return new ConvertExpression.ToFloat((XCriteriaBuilder)this, number);
    }

    public Expression<Double> toDouble(Expression<? extends Number> number) {
        return new ConvertExpression.ToDouble((XCriteriaBuilder)this, number);
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return new ConvertExpression.ToBigInteger((XCriteriaBuilder)this, number);
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return new ConvertExpression.ToBigDecimal((XCriteriaBuilder)this, number);
    }

    public Expression<String> toString(Expression<Character> character) {
        return new ConvertExpression.ToString((XCriteriaBuilder)this, (Expression<? extends Character>)character);
    }

    @Override
    public <T> Expression<T> literal(T value) {
        return new LiteralExpression<T>(this, value);
    }

    public <T> Expression<T> nullLiteral(Class<T> resultClass) {
        return new NullLiteralExpression<T>(this, resultClass);
    }

    @Override
    public <T> Expression<T> constant(T value) {
        return new ConstantExpression<T>(this, value);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return this.parameter(paramClass, null);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this, paramClass, name);
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collection) {
        Arguments.mustBeInstanceOfValue((String)"collection", collection, PluralAttributePath.class);
        return new IsEmptyPredicate(this, (PluralAttributePath)collection);
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collection) {
        return this.not((Expression<Boolean>)this.isEmpty(collection));
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> collection) {
        if (!(collection instanceof PluralAttributePath)) {
            Arguments.mustBeInstanceOfValue((String)"collection", collection, PluralAttributePath.class);
        }
        return new SizeExpression(this, (PluralAttributePath)collection);
    }

    public <C extends Collection<?>> Expression<Integer> size(C collection) {
        return this.literal(collection == null ? 0 : collection.size());
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elem, Expression<C> collection) {
        Arguments.mustBeInstanceOfValue((String)"collection", collection, PluralAttributePath.class);
        return new IsMemberPredicate(this, elem, (PluralAttributePath)collection);
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, Expression<C> collection) {
        return this.isMember((E)this.literal(elem), collection);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> elem, Expression<C> collection) {
        return this.not((Expression<Boolean>)this.isMember((E)elem, collection));
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, Expression<C> collection) {
        return this.not((Expression<Boolean>)this.isMember(elem, collection));
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        return this.literal(map.keySet());
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        return this.literal(map.values());
    }

    public Predicate like(Expression<String> x, Expression<String> pattern) {
        return this.like(x, pattern, null);
    }

    public Predicate like(Expression<String> x, String pattern) {
        return this.like(x, this.literal(pattern), null);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return new LikePredicate(this, x, pattern, escapeChar);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.like(x, pattern, this.literal(Character.valueOf(escapeChar)));
    }

    public Predicate like(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.like(x, this.literal(pattern), escapeChar);
    }

    public Predicate like(Expression<String> x, String pattern, char escapeChar) {
        return this.like(x, this.literal(pattern), this.literal(Character.valueOf(escapeChar)));
    }

    @Override
    public Predicate like(Expression<String> x, String pattern, LikeMode likeMode) {
        if (likeMode != null) {
            pattern = likeMode.pattern(pattern);
        }
        return this.like(x, pattern);
    }

    @Override
    public Predicate insensitivelyLike(Expression<String> x, String pattern) {
        return this.insensitivelyLike(x, pattern, null);
    }

    @Override
    public Predicate insensitivelyLike(Expression<String> x, String pattern, LikeMode likeMode) {
        if (likeMode != null) {
            pattern = likeMode.pattern(pattern);
        }
        return this.like(this.upper(x), pattern.toUpperCase());
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern) {
        return this.not((Expression<Boolean>)this.like(x, pattern));
    }

    public Predicate notLike(Expression<String> x, String pattern) {
        return this.not((Expression<Boolean>)this.like(x, pattern));
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return this.not((Expression<Boolean>)this.like(x, pattern, escapeChar));
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return this.not((Expression<Boolean>)this.like(x, pattern, escapeChar));
    }

    public Predicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return this.not((Expression<Boolean>)this.like(x, pattern, escapeChar));
    }

    public Predicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return this.not((Expression<Boolean>)this.like(x, pattern, escapeChar));
    }

    @Override
    public Predicate notLike(Expression<String> x, String pattern, LikeMode likeMode) {
        return this.not((Expression<Boolean>)this.like(x, pattern, likeMode));
    }

    @Override
    public Predicate notInsensitivelyLike(Expression<String> x, String pattern) {
        return this.not((Expression<Boolean>)this.insensitivelyLike(x, pattern));
    }

    @Override
    public Predicate notInsensitivelyLike(Expression<String> x, String pattern, LikeMode likeMode) {
        return this.not((Expression<Boolean>)this.insensitivelyLike(x, pattern, likeMode));
    }

    public Expression<String> concat(Expression<String> x, Expression<String> y) {
        return this.concat().value(x).value(y);
    }

    public Expression<String> concat(Expression<String> x, String y) {
        return this.concat(x, this.literal(y));
    }

    @Override
    public XCriteriaBuilder.Concat concat() {
        return new ConcatExpression(this);
    }

    public Expression<String> concat(String x, Expression<String> y) {
        return this.concat(this.literal(x), y);
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from) {
        return this.substring(x, from, null);
    }

    public Expression<String> substring(Expression<String> x, int from) {
        return this.substring(x, this.literal(from), null);
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from, Expression<Integer> len) {
        return new SubstringFunction((XCriteriaBuilder)this, x, from, len);
    }

    public Expression<String> substring(Expression<String> x, int from, int len) {
        return this.substring(x, this.literal(from), this.literal(len));
    }

    public Expression<String> trim(Expression<String> x) {
        return this.trim(TrimExpression.DEFAULT_TRIM_SPEC, this.defaultTrimCharacter, x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> x) {
        return this.trim(ts, this.defaultTrimCharacter, x);
    }

    public Expression<String> trim(Expression<Character> t, Expression<String> x) {
        return this.trim(TrimExpression.DEFAULT_TRIM_SPEC, t, x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> t, Expression<String> x) {
        return new TrimExpression(this, ts, t, x);
    }

    public Expression<String> trim(char t, Expression<String> x) {
        return this.trim(TrimExpression.DEFAULT_TRIM_SPEC, this.literal(Character.valueOf(t)), x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, Expression<String> x) {
        return this.trim(ts, this.literal(Character.valueOf(t)), x);
    }

    public Expression<String> lower(Expression<String> x) {
        return new LowerFunction(this, x);
    }

    public Expression<String> upper(Expression<String> x) {
        return new UpperFunction(this, x);
    }

    public Expression<Integer> length(Expression<String> x) {
        return new LengthFunction(this, x);
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern, Expression<Integer> from) {
        return new LocateFunction((XCriteriaBuilder)this, x, pattern, from);
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern) {
        return this.locate(x, pattern, null);
    }

    public Expression<Integer> locate(Expression<String> x, String pattern, int from) {
        return this.locate(x, this.literal(pattern), this.literal(from));
    }

    public Expression<Integer> locate(Expression<String> x, String pattern) {
        return this.locate(x, this.literal(pattern), null);
    }

    public Expression<Date> currentDate() {
        return new CurrentDateFunction(this);
    }

    public Expression<Timestamp> currentTimestamp() {
        return new CurrentDatestampFunction(this);
    }

    public Expression<Time> currentTime() {
        return new CurrentTimeFunction(this);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new InPredicate<T>(this, expression);
    }

    @Override
    public <T> Predicate in(Expression<? extends T> x, Iterable<T> values) {
        CriteriaBuilder.In<? extends T> in = this.in(x);
        if (values != null) {
            for (T value : values) {
                in.value(value);
            }
        }
        return in;
    }

    @Override
    public <T> Predicate in(Expression<? extends T> x, Subquery<T> subquery) {
        return this.in(x).value(subquery);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.coalesce().value(x).value(y);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Y y) {
        return this.coalesce(x, (Y)this.literal(y));
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return new CoalesceExpression(this);
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return new NullifExpression<Y>(this, x, y);
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Y y) {
        return this.nullif(x, (Y)this.literal(y));
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return new SimpleCaseExpression(this, expression);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        return new SearchedCaseExpression(this);
    }

    public <T> Expression<T> function(String name, final Class<T> type, Expression<?> ... args) {
        return new AbstractFunction<T>(this, name, args){
            private static final long serialVersionUID = 1983144347737818446L;

            public Class<? extends T> getJavaType() {
                return type;
            }
        };
    }

    public <X, T extends X> XRoot<T> treat(Root<X> root, Class<T> type) {
        return new TreatedRootImpl<T>((RootImpl)root, type);
    }

    @Override
    public <X, K, T, V extends T> XMapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        return new TreatedMapAttributeJoin((MapAttributeJoin)join, type);
    }

    @Override
    public <X, T, E extends T> XListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return new TreatedListAttributeJoin((ListAttributeJoin)join, type);
    }

    @Override
    public <X, T, E extends T> XSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return new TreatedSetAttributeJoin((SetAttributeJoin)join, type);
    }

    @Override
    public <X, T, E extends T> XCollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return new TreatedCollectionAttributeJoin((CollectionAttributeJoin)join, type);
    }

    @Override
    public <X, T, V extends T> XJoin<X, V> treat(Join<X, T> join, Class<V> type) {
        if (join instanceof MapJoin) {
            return this.treat((MapJoin)join, (Class)type);
        }
        if (join instanceof ListJoin) {
            return this.treat((ListJoin)join, (Class)type);
        }
        if (join instanceof SetJoin) {
            return this.treat((SetJoin)join, (Class)type);
        }
        if (join instanceof CollectionJoin) {
            return this.treat((CollectionJoin)join, (Class)type);
        }
        Arguments.mustBeInstanceOfValue((String)"join", join, SingularAttributeJoin.class);
        return new TreatedSingularAttributeJoin((SingularAttributeJoin)join, type);
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        if (path instanceof Join) {
            return this.treat((Join)path, (Class)type);
        }
        Arguments.mustBeInstanceOfValue((String)"path", path, SingularAttributePath.class);
        return new TreatedSingularAttributePath<T>((SingularAttributePath)path, type);
    }

    @Override
    public <X, Y> DependencyPredicateBuilder<X, Y> dependencyPredicateBuilder(From<?, X> from, Class<Y> targetType) {
        return new DependencyPredicateBuilderImpl((AbstractFrom)from, targetType);
    }
}

