/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import javax.persistence.criteria.Expression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;

public abstract class UnaryArithmeticExpression<N extends Number>
extends AbstractExpression<N> {
    private static final long serialVersionUID = 1737023137827219801L;
    private Expression<? extends N> operand;

    private UnaryArithmeticExpression(XCriteriaBuilder criteriaBuilder, Expression<? extends N> operand) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"operand", operand);
        this.mustUnderSameCriteriaBuilder("operand", operand);
        this.operand = operand;
    }

    public Expression<? extends Number> getOperand() {
        return this.operand;
    }

    public Class<? extends N> getJavaType() {
        return this.operand.getJavaType();
    }

    public abstract String getOperator();

    @Override
    public void accept(Visitor visitor) {
        visitor.visitUnaryArithmeticExpression(this);
    }

    @Override
    public int getPriority() {
        return 600;
    }

    public static class Neg<N extends Number>
    extends UnaryArithmeticExpression<N> {
        private static final long serialVersionUID = -3826035740808870643L;

        public Neg(XCriteriaBuilder criteriaBuilder, Expression<? extends N> operand) {
            super(criteriaBuilder, operand);
        }

        @Override
        public String getOperator() {
            return "-";
        }
    }
}

