/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.Expression;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractFunction;

public class SubstringFunction
extends AbstractFunction<String> {
    private static final long serialVersionUID = -8556031697688118536L;
    public static final String FUNCTION_NAME = "substring";

    public SubstringFunction(XCriteriaBuilder criteriaBuilder, Expression<String> valueExpression, Expression<Integer> startExpression, Expression<Integer> lengthExpression) {
        super(criteriaBuilder, FUNCTION_NAME, SubstringFunction.createArgumentExpressions(valueExpression, startExpression, lengthExpression));
    }

    private static Expression<?>[] createArgumentExpressions(Expression<String> valueExpression, Expression<Integer> startExpression, Expression<Integer> lengthExpression) {
        Expression[] expressionArray;
        if (lengthExpression == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = valueExpression;
            expressionArray = expressionArray2;
            expressionArray2[1] = startExpression;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = valueExpression;
            expressionArray3[1] = startExpression;
            expressionArray = expressionArray3;
            expressionArray3[2] = lengthExpression;
        }
        return expressionArray;
    }

    public Expression<String> getValue() {
        return this.getArguments().get(0);
    }

    public Expression<Integer> getStart() {
        return this.getArguments().get(1);
    }

    public Expression<Integer> getLength() {
        List<Expression<?>> argumentExpressions = this.getArguments();
        if (argumentExpressions.size() > 2) {
            return argumentExpressions.get(2);
        }
        return null;
    }

    public Class<? extends String> getJavaType() {
        return String.class;
    }
}

