/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.expression.LiteralExpression;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class SimpleCaseExpression<C, R>
extends AbstractExpression<R>
implements CriteriaBuilder.SimpleCase<C, R> {
    private static final long serialVersionUID = 6229974771157274180L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Expression<? extends C> expression;
    private List<WhenClause<C, R>> whenClauses;
    private Expression<? extends R> otherwiseResult;

    public SimpleCaseExpression(XCriteriaBuilder criteriaBuilder, Expression<? extends C> expression) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"expression", expression);
        this.mustUnderSameCriteriaBuilder("expression", expression);
        this.expression = expression;
        this.whenClauses = new ArrayList();
    }

    public Class<? extends R> getJavaType() {
        List<WhenClause<C, R>> whenClauses = this.whenClauses;
        if (whenClauses.isEmpty() || this.otherwiseResult == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).missWhenOrOtherwise(SimpleCaseExpression.class));
        }
        return whenClauses.get(0).getResult().getJavaType();
    }

    public Expression<C> getExpression() {
        return this.expression;
    }

    public List<WhenClause<C, R>> getWhenClauses() {
        return MACollections.unmodifiable(this.whenClauses);
    }

    public Expression<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        this.checkState();
        Arguments.mustNotBeNull((String)"condition", condition);
        Arguments.mustNotBeNull((String)"result", result);
        this.mustUnderSameCriteriaBuilder("result", result);
        this.whenClauses.add(new WhenClause<C, R>(condition, result));
        return this;
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (R)this.getCriteriaBuilder().constant(result));
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.checkState();
        Arguments.mustNotBeInstanceOfAnyOfValue((String)"result", (Object)this.mustUnderSameCriteriaBuilder("result", (Selection)Arguments.mustNotBeNull((String)"result", result)), (Class[])new Class[]{ParameterExpression.class, LiteralExpression.class});
        this.otherwiseResult = result;
        return this;
    }

    public Expression<R> otherwise(R result) {
        return this.otherwise((R)this.getCriteriaBuilder().constant(result));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSimpleCaseExpression(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private static interface Resource {
        public String missWhenOrOtherwise(Class<SimpleCaseExpression> var1);
    }

    public static class WhenClause<C, R> {
        private C condition;
        private Expression<? extends R> result;

        public WhenClause(C condition, Expression<? extends R> result) {
            this.condition = Arguments.mustNotBeNull((String)"condition", condition);
            this.result = (Expression)Arguments.mustNotBeInstanceOfAnyOfValue((String)"result", (Object)Arguments.mustNotBeNull((String)"result", result), (Class[])new Class[]{ParameterExpression.class, LiteralExpression.class});
        }

        public C getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

