/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.expression.LiteralExpression;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class SearchedCaseExpression<R>
extends AbstractExpression<R>
implements CriteriaBuilder.Case<R> {
    private static final long serialVersionUID = 3677272923107225348L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private List<WhenClause<R>> whenClauses = new ArrayList();
    private Expression<? extends R> otherwiseResult;

    public SearchedCaseExpression(XCriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    public Class<? extends R> getJavaType() {
        if (this.whenClauses.isEmpty() || this.otherwiseResult == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).missWhenOrOtherwise(SearchedCaseExpression.class));
        }
        return this.whenClauses.get(0).getResult().getJavaType();
    }

    public List<WhenClause<R>> getWhenClauses() {
        return MACollections.unmodifiable(this.whenClauses);
    }

    public Expression<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public CriteriaBuilder.Case<R> when(Expression<Boolean> condition, Expression<? extends R> result) {
        this.checkState();
        Arguments.mustNotBeNull((String)"condition", condition);
        Arguments.mustNotBeNull((String)"result", result);
        this.mustUnderSameCriteriaBuilder("condition", condition);
        this.mustUnderSameCriteriaBuilder("result", result);
        this.whenClauses.add(new WhenClause<R>(condition, result));
        return this;
    }

    public CriteriaBuilder.Case<R> when(Expression<Boolean> condition, R result) {
        return this.when(condition, (R)this.getCriteriaBuilder().constant(result));
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.checkState();
        Arguments.mustNotBeInstanceOfAnyOfValue((String)"result", (Object)this.mustUnderSameCriteriaBuilder("result", (Selection)Arguments.mustNotBeNull((String)"result", result)), (Class[])new Class[]{ParameterExpression.class, LiteralExpression.class});
        this.otherwiseResult = result;
        return this;
    }

    public Expression<R> otherwise(R result) {
        return this.otherwise((R)this.getCriteriaBuilder().constant(result));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSearchedCaseExpression(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private static interface Resource {
        public String missWhenOrOtherwise(Class<SearchedCaseExpression> var1);
    }

    public static class WhenClause<R> {
        private Expression<Boolean> condition;
        private Expression<? extends R> result;

        public WhenClause(Expression<Boolean> condition, Expression<? extends R> result) {
            this.condition = (Expression)Arguments.mustNotBeNull((String)"condition", condition);
            this.result = (Expression)Arguments.mustNotBeInstanceOfAnyOfValue((String)"result", (Object)Arguments.mustNotBeNull((String)"result", result), (Class[])new Class[]{ParameterExpression.class, LiteralExpression.class});
        }

        public Expression<Boolean> getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

