/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import javax.persistence.criteria.ParameterExpression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class ParameterExpressionImpl<T>
extends AbstractExpression<T>
implements ParameterExpression<T> {
    private static final long serialVersionUID = 4709437146322229160L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Class<T> parameterType;
    private String name;
    private Integer position;

    public ParameterExpressionImpl(XCriteriaBuilder criteriaBuilder, Class<T> parameterType, String name) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"parameterType", parameterType);
        if (name != null && name.startsWith("babyfish_literal_")) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).parameterCanNotStartWith("name", "babyfish_literal_"));
        }
        this.parameterType = parameterType;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends T> getJavaType() {
        return this.parameterType;
    }

    public Class<T> getParameterType() {
        return this.parameterType;
    }

    public boolean setPosition(int position) {
        Arguments.mustBeGreaterThanOrEqualToValue((String)"position", (int)position, (int)0);
        if (this.name != null) {
            throw new UnsupportedOperationException(((Resource)LAZY_RESOURCE.get()).canNotSetPositionOfNamedParameter());
        }
        if (this.position == null) {
            this.position = position;
            return true;
        }
        return false;
    }

    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitParameterExpression(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private static interface Resource {
        public String canNotSetPositionOfNamedParameter();

        public String parameterCanNotStartWith(String var1, String var2);
    }
}

