/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.Expression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractFunction;

public class LocateFunction
extends AbstractFunction<Integer> {
    private static final long serialVersionUID = 9061090638186351417L;
    public static final String FUNCTION_NAME = "locate";

    public LocateFunction(XCriteriaBuilder criteriaBuilder, Expression<String> stringExpression, Expression<String> patternExpression, Expression<Integer> startExpression) {
        super(criteriaBuilder, FUNCTION_NAME, LocateFunction.createArgumentExpressions(stringExpression, patternExpression, startExpression));
    }

    public Class<? extends Integer> getJavaType() {
        return Integer.class;
    }

    public Expression<String> getString() {
        return this.getArguments().get(0);
    }

    public Expression<String> getPattern() {
        return this.getArguments().get(1);
    }

    public Expression<Integer> getStart() {
        List<Expression<?>> argumentExpressions = this.getArguments();
        if (argumentExpressions.size() > 2) {
            return argumentExpressions.get(2);
        }
        return null;
    }

    private static Expression<?>[] createArgumentExpressions(Expression<String> stringExpression, Expression<String> patternExpression, Expression<Integer> startExpression) {
        Arguments.mustNotBeNull((String)"stringExpression", stringExpression);
        Arguments.mustNotBeNull((String)"patternExpression", patternExpression);
        if (startExpression == null) {
            return new Expression[]{stringExpression, patternExpression};
        }
        return new Expression[]{stringExpression, patternExpression, startExpression};
    }
}

