/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.XEntityManagerFactory;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.expression.ConstantExpression;
import org.babyfish.persistence.criteria.expression.LiteralExpression;
import org.babyfish.persistence.criteria.spi.AbstractSimplePredicate;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.persistence.path.spi.EntityManagerFactoryConfigurable;
import org.babyfish.util.LazyResource;

public class InPredicate<T>
extends AbstractSimplePredicate
implements CriteriaBuilder.In<T> {
    private static final long serialVersionUID = -2210373342558775003L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Expression<? extends T> expression;
    private List<Expression<? extends T>> values;
    private List<Partition<T>> partitions;
    private int maxPartitionSize;

    public InPredicate(XCriteriaBuilder criteriaBuilder, Expression<? extends T> expression) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"expression", expression);
        this.mustUnderSameCriteriaBuilder("expression", expression);
        this.expression = expression;
        this.values = new ArrayList();
        XEntityManagerFactory entityManagerFactory = criteriaBuilder.getEntityManagerFactory();
        Arguments.mustBeInstanceOfValue((String)"entityManagerFactory", (Object)entityManagerFactory, EntityManagerFactoryConfigurable.class);
        this.maxPartitionSize = ((EntityManagerFactoryConfigurable)((Object)entityManagerFactory)).getInPredicateMaxPartitionSize();
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    public List<Expression<? extends T>> getValues() {
        return MACollections.unmodifiable(this.values);
    }

    public CriteriaBuilder.In<T> value(Expression<? extends T> value) {
        this.checkState();
        if (value != null) {
            this.mustUnderSameCriteriaBuilder("value", value);
            this.values.add(value);
        }
        return this;
    }

    public CriteriaBuilder.In<T> value(T value) {
        return this.value((T)this.getCriteriaBuilder().literal(value));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInPredicate(this);
    }

    @Override
    public int getPriority() {
        return 300;
    }

    public int getMaxParationSize() {
        return this.maxPartitionSize;
    }

    public List<Partition<T>> getPartitions() {
        List<Partition<T>> partitions = this.partitions;
        if (partitions == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).methodCanOnlyBeInvokedWhenThisIsFrozen("getPartitions", InPredicate.class));
        }
        return partitions;
    }

    @Override
    protected void onFrozen() {
        int size = this.values.size();
        int maxParationSize = this.maxPartitionSize;
        int partitionCount = (int)(((long)size + (long)maxParationSize - 1L) / (long)maxParationSize);
        ArrayList partitions = new ArrayList(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            int from = i * maxParationSize;
            int to = Math.min(from + maxParationSize, size);
            partitions.add(new Partition(this.values.subList(from, to)));
        }
        this.partitions = MACollections.unmodifiable((List)partitions);
    }

    @Override
    protected void onUnfrozen() {
        this.partitions = null;
    }

    private static interface Resource {
        public String methodCanOnlyBeInvokedWhenThisIsFrozen(String var1, Class<InPredicate> var2);
    }

    public static class Partition<T> {
        private List<Expression<? extends T>> values;
        private boolean needExpand;

        private Partition(List<Expression<? extends T>> values) {
            this.values = MACollections.unmodifiable(values);
            for (Expression<? extends T> expression : this.values) {
                if (expression instanceof LiteralExpression || expression instanceof ConstantExpression) continue;
                this.needExpand = true;
                break;
            }
        }

        public List<Expression<? extends T>> getValues() {
            return this.values;
        }

        public boolean isNeedExpand() {
            return this.needExpand;
        }
    }
}

