/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;

public class ConstantExpression<T>
extends AbstractExpression<T> {
    private static final long serialVersionUID = 6757283545751309755L;
    private T value;

    public ConstantExpression(XCriteriaBuilder criteriaBuilder, T value) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"value", value);
        Arguments.mustBeInstanceOfAnyOfValue((String)"value", value, (Class[])new Class[]{Boolean.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, String.class});
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends T> getJavaType() {
        return this.value.getClass();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantExpression(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

