/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.Expression;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class ConcatExpression
extends AbstractExpression<String>
implements XCriteriaBuilder.Concat {
    private static final long serialVersionUID = 4969211180840889062L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private List<Expression<String>> values;

    public ConcatExpression(XCriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    public Class<? extends String> getJavaType() {
        return String.class;
    }

    @Override
    public XCriteriaBuilder.Concat value(Expression<String> value) {
        this.checkState();
        Arguments.mustNotBeNull((String)"value", value);
        this.mustUnderSameCriteriaBuilder("value", value);
        ArrayList values = this.values;
        if (values == null) {
            this.values = values = new ArrayList();
        }
        values.add(value);
        return this;
    }

    @Override
    public XCriteriaBuilder.Concat value(String value) {
        return this.value(this.getCriteriaBuilder().literal(value));
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConcatExpression(this);
    }

    public List<Expression<String>> getValues() {
        List<Expression<String>> values = this.values;
        if (values == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).isEmpty(ConcatExpression.class));
        }
        return MACollections.unmodifiable(values);
    }

    private static interface Resource {
        public String isEmpty(Class<ConcatExpression> var1);
    }
}

