/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.Collection;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Selection;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XList;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractSelection;
import org.babyfish.persistence.criteria.spi.Visitor;

public class CompoundSelectionImpl<X>
extends AbstractSelection<X>
implements CompoundSelection<X> {
    private static final long serialVersionUID = -1187997163043476706L;
    private Class<? extends X> javaType;
    private List<Selection<?>> compoundSelectionItems;

    public CompoundSelectionImpl(XCriteriaBuilder criteriaBuilder, Class<? extends X> javaType, Iterable<Selection<?>> compoundSelectionItems) {
        super(criteriaBuilder);
        XList list;
        Arguments.mustNotBeNull((String)"javaType", javaType);
        if (compoundSelectionItems != null) {
            list = compoundSelectionItems instanceof Collection ? new ArrayList(((Collection)compoundSelectionItems).size()) : new ArrayList();
            int index = 0;
            for (Selection<?> selection : compoundSelectionItems) {
                if (selection != null) {
                    Class subJavaType = selection.getJavaType();
                    Arguments.mustNotBeArray((String)("compoundSelectionItems[" + index + ']'), (Class)subJavaType);
                    Arguments.mustNotBeCompatibleWithValue((String)("compoundSelectionItems[" + index + ']'), (Class)subJavaType, Tuple.class);
                    this.mustUnderSameCriteriaBuilder("compoundSelectionItems[" + index + ']', selection);
                    list.add(selection);
                }
                ++index;
            }
        } else {
            list = MACollections.emptyList();
        }
        this.javaType = javaType;
        this.compoundSelectionItems = MACollections.unmodifiable((List)list);
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        return this.compoundSelectionItems;
    }

    public Class<? extends X> getJavaType() {
        return this.javaType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCompoundSelection(this);
    }
}

