/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractPredicate;
import org.babyfish.persistence.criteria.spi.Visitor;

public final class CompoundPredicate
extends AbstractPredicate {
    private static final long serialVersionUID = 3838567907423250345L;
    private Predicate.BooleanOperator operator;
    private Predicate[] predicates;

    public static Predicate of(XCriteriaBuilder criteriaBuilder, Predicate.BooleanOperator operator, Predicate ... predicates) {
        LinkedHashSet orderedSet = new LinkedHashSet((predicates.length * 4 + 2) / 3);
        int index = 0;
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            CompoundPredicate.mustUnderSameCriteriaBuilder(criteriaBuilder, "predicates[" + index + ']', predicate);
            ++index;
            orderedSet.add((Object)predicate);
        }
        if (orderedSet.isEmpty()) {
            return null;
        }
        if (orderedSet.size() == 1) {
            return (Predicate)orderedSet.iterator().next();
        }
        return new CompoundPredicate(criteriaBuilder, operator, (Predicate[])orderedSet.toArray((Object[])new Predicate[orderedSet.size()]));
    }

    private CompoundPredicate(XCriteriaBuilder criteriaBuilder, Predicate.BooleanOperator operator, Predicate[] predicates) {
        super(criteriaBuilder);
        this.operator = (Predicate.BooleanOperator)Arguments.mustNotBeNull((String)"operator", (Object)operator);
        this.predicates = predicates;
    }

    public List<Expression<Boolean>> getExpressions() {
        return MACollections.wrap((Object[])((Expression[])this.predicates));
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCompoundPredicate(this);
    }

    @Override
    public int getPriority() {
        return this.operator == Predicate.BooleanOperator.AND ? 200 : 100;
    }

    public final boolean isNegated() {
        return false;
    }

    @Override
    protected CompoundPredicate createNot() {
        Predicate.BooleanOperator booleanOperator = this.operator == Predicate.BooleanOperator.AND ? Predicate.BooleanOperator.OR : Predicate.BooleanOperator.AND;
        Predicate[] predicates = null;
        if (this.predicates != null) {
            predicates = (Predicate[])this.predicates.clone();
            for (int i = predicates.length - 1; i >= 0; --i) {
                predicates[i] = predicates[i].not();
            }
        }
        return new CompoundPredicate(this.getCriteriaBuilder(), booleanOperator, predicates);
    }
}

