/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.babyfish.collection.ArrayList;
import org.babyfish.collection.MACollections;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class CoalesceExpression<T>
extends AbstractExpression<T>
implements CriteriaBuilder.Coalesce<T> {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private static final long serialVersionUID = 1956490783274191346L;
    private Class<? extends T> javaType;
    private List<Expression<? extends T>> values = new ArrayList();

    public CoalesceExpression(XCriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    public Class<? extends T> getJavaType() {
        if (this.javaType == null) {
            throw new IllegalStateException(((Resource)LAZY_RESOURCE.get()).isEmpty(CoalesceExpression.class));
        }
        return this.javaType;
    }

    public List<Expression<? extends T>> getExpressions() {
        return MACollections.unmodifiable(this.values);
    }

    public CriteriaBuilder.Coalesce<T> value(T value) {
        if (value != null) {
            if (this.values.isEmpty()) {
                return this.value(this.getCriteriaBuilder().constant(value));
            }
            return this.value(this.getCriteriaBuilder().literal(value));
        }
        return this;
    }

    public CriteriaBuilder.Coalesce<T> value(Expression<? extends T> value) {
        if (value != null) {
            if (this.values.isEmpty()) {
                CoalesceExpression.mustHaveExplicitDataTypeWhen(((Resource)LAZY_RESOURCE.get()).whenCoalesceIsEmpty(CoalesceExpression.class), "value", value);
            }
            this.mustUnderSameCriteriaBuilder("value", value);
            if (this.javaType == null) {
                this.javaType = value.getJavaType();
            }
            this.values.add(value);
        }
        return this;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCoalesceExpression(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private static interface Resource {
        public String whenCoalesceIsEmpty(Class<CoalesceExpression> var1);

        public String isEmpty(Class<CoalesceExpression> var1);
    }
}

