/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.persistence.criteria.Expression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public abstract class BinaryArithmeticExpression<T extends Number>
extends AbstractExpression<T> {
    private static final long serialVersionUID = -7438031664893657594L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Expression<? extends Number> leftOperand;
    private Expression<? extends Number> rightOperand;
    private Class<? extends T> javaType;

    BinaryArithmeticExpression(XCriteriaBuilder criteriaBuilder, Expression<? extends Number> leftOperand, Expression<? extends Number> rightOperand) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"leftOperand", leftOperand);
        Arguments.mustNotBeNull((String)"rightOperand", rightOperand);
        this.mustUnderSameCriteriaBuilder("leftOperand", leftOperand);
        this.mustUnderSameCriteriaBuilder("rightOperand", rightOperand);
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        Class leftType = this.leftOperand.getJavaType();
        Class rightType = this.rightOperand.getJavaType();
        if (leftType == Double.class || rightType == Double.class || leftType == Double.TYPE || rightType == Double.TYPE || leftType == Float.class || rightType == Float.class || leftType == Float.TYPE || rightType == Float.TYPE) {
            this.javaType = Double.class;
        } else if (leftType == BigDecimal.class || rightType == BigDecimal.class) {
            this.javaType = BigDecimal.class;
        } else if (leftType == BigInteger.class || rightType == BigInteger.class) {
            this.javaType = BigInteger.class;
        } else if (leftType == Long.class || rightType == Long.class || leftType == Long.TYPE || rightType == Long.TYPE) {
            this.javaType = Long.class;
        } else if (leftType == Integer.class || rightType == Integer.class || leftType == Integer.TYPE || rightType == Integer.TYPE) {
            this.javaType = Integer.class;
        } else if (leftType == Short.class || rightType == Short.class || leftType == Short.TYPE || rightType == Short.TYPE) {
            this.javaType = Short.class;
        } else if (leftType == Byte.class || rightType == Byte.class || leftType == Byte.TYPE || rightType == Byte.TYPE) {
            this.javaType = Byte.class;
        } else {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).illegalBinaryArithmeticTypes(leftType, rightType));
        }
    }

    public final Expression<? extends Number> getLeftOperand() {
        return this.leftOperand;
    }

    public final Expression<? extends Number> getRightOperand() {
        return this.rightOperand;
    }

    public Class<? extends T> getJavaType() {
        return this.javaType;
    }

    public abstract String getOperator();

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBinaryArithmeticExpression(this);
    }

    private static interface Resource {
        public String illegalBinaryArithmeticTypes(Class<? extends Number> var1, Class<? extends Number> var2);
    }

    public static class Mod
    extends BinaryArithmeticExpression<Integer> {
        private static final long serialVersionUID = 7267091696695325409L;

        public Mod(XCriteriaBuilder criteriaBuilder, Expression<? extends Integer> leftOperand, Expression<? extends Integer> rightOperand) {
            super(criteriaBuilder, leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return "mod";
        }

        @Override
        public int getPriority() {
            return 500;
        }
    }

    public static class Quot<T extends Number>
    extends BinaryArithmeticExpression<T> {
        private static final long serialVersionUID = 6538695478703163288L;

        public Quot(XCriteriaBuilder criteriaBuilder, Expression<? extends Number> leftOperand, Expression<? extends Number> rightOperand) {
            super(criteriaBuilder, leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return "/";
        }

        @Override
        public int getPriority() {
            return 500;
        }
    }

    public static class Prod<T extends Number>
    extends BinaryArithmeticExpression<T> {
        private static final long serialVersionUID = 8480989312311308037L;

        public Prod(XCriteriaBuilder criteriaBuilder, Expression<? extends Number> leftOperand, Expression<? extends Number> rightOperand) {
            super(criteriaBuilder, leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return "*";
        }

        @Override
        public int getPriority() {
            return 500;
        }
    }

    public static class Diff<T extends Number>
    extends BinaryArithmeticExpression<T> {
        private static final long serialVersionUID = 4167825183168659680L;

        public Diff(XCriteriaBuilder criteriaBuilder, Expression<? extends Number> leftOperand, Expression<? extends Number> rightOperand) {
            super(criteriaBuilder, leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return "-";
        }

        @Override
        public int getPriority() {
            return 400;
        }
    }

    public static class Sum<T extends Number>
    extends BinaryArithmeticExpression<T> {
        private static final long serialVersionUID = -5240749360311053658L;

        public Sum(XCriteriaBuilder criteriaBuilder, Expression<? extends Number> leftOperand, Expression<? extends Number> rightOperand) {
            super(criteriaBuilder, leftOperand, rightOperand);
        }

        @Override
        public String getOperator() {
            return "+";
        }

        @Override
        public int getPriority() {
            return 400;
        }
    }
}

