/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import javax.persistence.criteria.Expression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractSimplePredicate;
import org.babyfish.persistence.criteria.spi.Visitor;
import org.babyfish.util.LazyResource;

public class BetweenPredicate<Y>
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1753924293482192005L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private Expression<? extends Y> expression;
    private Expression<? extends Y> lowerBound;
    private Expression<? extends Y> upperBound;

    public BetweenPredicate(XCriteriaBuilder criteriaBuilder, Expression<? extends Y> expression, Expression<? extends Y> lowerBound, Expression<? extends Y> upperBound) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"expression", expression);
        if (lowerBound == null && upperBound == null) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).bothAreNull("lowerBound", "upperBound"));
        }
        this.mustUnderSameCriteriaBuilder("expression", expression);
        this.mustUnderSameCriteriaBuilder("lowerBound", lowerBound);
        this.mustUnderSameCriteriaBuilder("upperBound", upperBound);
        this.expression = expression;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public Expression<? extends Y> getSource() {
        return this.expression;
    }

    public Expression<? extends Y> getLowerBound() {
        return this.lowerBound;
    }

    public Expression<? extends Y> getUpperBound() {
        return this.upperBound;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBetweenPredicate(this);
    }

    @Override
    public int getPriority() {
        return 300;
    }

    private static interface Resource {
        public String bothAreNull(String var1, String var2);
    }
}

