/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.criteria.expression;

import javax.persistence.criteria.Expression;
import org.babyfish.lang.Arguments;
import org.babyfish.persistence.criteria.XCriteriaBuilder;
import org.babyfish.persistence.criteria.spi.AbstractExpression;
import org.babyfish.persistence.criteria.spi.Visitor;

public abstract class Aggregation<T, A>
extends AbstractExpression<T> {
    private static final long serialVersionUID = -6583220409742987647L;
    private Expression<A> argument;

    private Aggregation(XCriteriaBuilder criteriaBuilder, Expression<A> argument) {
        super(criteriaBuilder);
        Arguments.mustNotBeNull((String)"argument", argument);
        this.mustUnderSameCriteriaBuilder("argument", argument);
        this.argument = argument;
    }

    public Expression<A> getOperand() {
        return this.argument;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAggregation(this);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public static class Max<T extends Number>
    extends Aggregation<T, T> {
        private static final long serialVersionUID = 1730549662631621484L;

        public Max(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends T> getJavaType() {
            return this.getOperand().getJavaType();
        }
    }

    public static class Min<T extends Number>
    extends Aggregation<T, T> {
        private static final long serialVersionUID = 1697085396369811386L;

        public Min(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends T> getJavaType() {
            return this.getOperand().getJavaType();
        }
    }

    public static class Greatest<T extends Comparable<? super T>>
    extends Aggregation<T, T> {
        private static final long serialVersionUID = 4614029407318424180L;

        public Greatest(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), Comparable.class);
        }

        public Class<? extends T> getJavaType() {
            return this.getOperand().getJavaType();
        }
    }

    public static class Least<T extends Comparable<? super T>>
    extends Aggregation<T, T> {
        private static final long serialVersionUID = 4614029407318424180L;

        public Least(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), Comparable.class);
        }

        public Class<? extends T> getJavaType() {
            return this.getOperand().getJavaType();
        }
    }

    public static class SumAsDouble
    extends Aggregation<Double, Float> {
        private static final long serialVersionUID = 1697085396369811386L;

        public SumAsDouble(XCriteriaBuilder criteriaBuilder, Expression<Float> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends Double> getJavaType() {
            return Double.class;
        }
    }

    public static class SumAsLong
    extends Aggregation<Long, Integer> {
        private static final long serialVersionUID = 1697085396369811386L;

        public SumAsLong(XCriteriaBuilder criteriaBuilder, Expression<Integer> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends Long> getJavaType() {
            return Long.class;
        }
    }

    public static class Sum<T extends Number>
    extends Aggregation<T, T> {
        private static final long serialVersionUID = 1697085396369811386L;

        public Sum(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends T> getJavaType() {
            return this.getOperand().getJavaType();
        }
    }

    public static class Avg<T extends Number>
    extends Aggregation<Double, T> {
        private static final long serialVersionUID = -1039456291613092964L;

        public Avg(XCriteriaBuilder criteriaBuilder, Expression<T> argument) {
            super(criteriaBuilder, argument);
            Arguments.mustBeCompatibleWithAnyOfValue((String)"argument.getJavaType()", (Class)argument.getJavaType(), (Class[])new Class[]{Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        }

        public Class<? extends Double> getJavaType() {
            return Double.class;
        }
    }

    public static class Count
    extends Aggregation<Long, Object> {
        private static final long serialVersionUID = -1039456291613092964L;
        private boolean distinct;

        public Count(XCriteriaBuilder criteriaBuilder, Expression<?> argument, boolean distinct) {
            super(criteriaBuilder, argument);
            this.distinct = distinct;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Class<? extends Long> getJavaType() {
            return Long.class;
        }
    }
}

