/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument.bytecode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.babyfish.lang.instrument.bytecode.AbstractGenerator;
import org.babyfish.lang.instrument.bytecode.GeneratorException;
import org.babyfish.lang.instrument.bytecode.Replacer;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.ClassWriter;

public abstract class NestedClassGenerator
extends AbstractGenerator {
    private String simpleName;

    protected NestedClassGenerator(AbstractGenerator parent, String simpleName) {
        super(parent, simpleName);
        this.simpleName = simpleName;
    }

    protected final String getSimpleName() {
        return this.simpleName;
    }

    protected int determineAccess() {
        return 10;
    }

    final void generate() {
        ClassWriter classWriter = new ClassWriter(3);
        this.generate(new AbstractGenerator.InnerClassClassAdapter((ClassVisitor)classWriter));
        byte[] bytecode = classWriter.toByteArray();
        File targetFile = this.targetFile();
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
            ((OutputStream)outputStream).write(bytecode);
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot write the instrumented bytecode into \"" + targetFile + "\" because of some IO exceptions", ex);
        }
    }

    protected abstract void generate(ClassVisitor var1);

    @Override
    final void visitInnerClassInSpecifiedClassVisitor(ClassVisitor cv) {
        cv.visitInnerClass(this.getInternalName(), ((AbstractGenerator)this.getParent()).getInternalName(), this.simpleName, this.determineAccess() & 0xFFFF9DFF);
    }

    private File targetFile() {
        Object replacer = this.getRoot();
        File targetFile = ((Replacer)replacer).getClassFile();
        String postfix = this.getClassName().substring(((AbstractGenerator)replacer).getClassName().length());
        String fileName = targetFile.getName();
        int lastDotIndex = fileName.lastIndexOf(46);
        fileName = lastDotIndex == -1 ? fileName + postfix : fileName.substring(0, lastDotIndex) + postfix + fileName.substring(lastDotIndex);
        return new File(targetFile.getParentFile(), fileName);
    }
}

