/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument.bytecode;

import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.lang.instrument.bytecode.NestedClassGenerator;
import org.babyfish.lang.instrument.bytecode.Replacer;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.Type;

public abstract class AbstractGenerator {
    private String className;
    private String internalName;
    private String descriptor;
    private Replacer root;
    private AbstractGenerator parentGenerator;
    private Map<String, NestedClassGenerator> childGeneratorMap;

    AbstractGenerator(String className) {
        this.root = (Replacer)this;
        this.className = className;
        this.internalName = className.replace('.', '/');
        this.descriptor = 'L' + this.internalName + ';';
    }

    AbstractGenerator(AbstractGenerator parentGenerator, String simpleName) {
        this.parentGenerator = parentGenerator;
        this.root = parentGenerator.root;
        Map<String, NestedClassGenerator> map = parentGenerator.childGeneratorMap;
        if (map == null) {
            parentGenerator.childGeneratorMap = map = new LinkedHashMap<String, NestedClassGenerator>();
        }
        if (parentGenerator.childGeneratorMap.put(simpleName, (NestedClassGenerator)this) != null) {
            throw new IllegalArgumentException("Duplicated child generators with the same simple name: " + simpleName);
        }
        this.className = parentGenerator.className + '$' + simpleName;
        this.internalName = this.className.replace('.', '/');
        this.descriptor = 'L' + this.internalName + ';';
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getInternalName() {
        return this.internalName;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public final <R extends Replacer> R getRoot() {
        return (R)this.root;
    }

    public final <G extends AbstractGenerator> G getParent() {
        return (G)this.parentGenerator;
    }

    abstract void visitInnerClassInSpecifiedClassVisitor(ClassVisitor var1);

    private void generateInnerClasses(ClassVisitor cv) {
        this.generateInnerClass(cv, true, true);
    }

    private void generateInnerClass(ClassVisitor cv, boolean up, boolean down) {
        AbstractGenerator parentGenerator = this.parentGenerator;
        if (up && parentGenerator != null) {
            parentGenerator.generateInnerClass(cv, true, false);
        }
        this.visitInnerClassInSpecifiedClassVisitor(cv);
        if (down && this.childGeneratorMap != null) {
            for (AbstractGenerator abstractGenerator : this.childGeneratorMap.values()) {
                abstractGenerator.generateInnerClass(cv, false, true);
            }
        }
    }

    final class InnerClassClassAdapter
    extends ClassVisitor {
        public InnerClassClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            super.visitAnnotation(Type.getDescriptor(Instrumented.class), false);
            AbstractGenerator.this.generateInnerClasses(this.cv);
        }

        public void visitEnd() {
            super.visitEnd();
            Map childGeneratorMap = AbstractGenerator.this.childGeneratorMap;
            if (childGeneratorMap != null) {
                for (NestedClassGenerator childGenerator : childGeneratorMap.values()) {
                    childGenerator.generate();
                }
            }
        }
    }
}

