/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.babyfish.lang.instrument.AbstractInstrumentMojo;

@Mojo(name="instrument-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresProject=false, threadSafe=true, executionStrategy="always", requiresDirectInvocation=false, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="instrument-test", phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class TestInstrumentMojo
extends AbstractInstrumentMojo {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the instrumentation of the test classes");
        } else {
            super.doExecute();
        }
    }

    @Override
    protected File getInstrumentDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected String getType() {
        return "test-classes";
    }

    @Override
    protected ClassLoader createClassLoader() {
        URL[] urls = (URL[])this.generateTestClasspaths().stream().map(AbstractInstrumentMojo::fileNameToURL).toArray(URL[]::new);
        return new URLClassLoader(urls);
    }

    private List<String> generateTestClasspaths() {
        Set artifacts = this.project.getArtifacts();
        ArrayList<String> classpaths = new ArrayList<String>(2 + artifacts.size());
        classpaths.add(this.testClassesDirectory.getAbsolutePath());
        classpaths.add(this.classesDirectory.getAbsolutePath());
        Set classpathArtifacts = artifacts;
        for (Artifact artifact : classpathArtifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpaths.add(file.getPath());
        }
        return classpaths;
    }
}

