/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.org.objectweb.asm.ClassReader;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.tree.ClassNode;

public class NoCodeClassNodeLoader {
    private Map<String, ClassNode> nameMap = new HashMap<String, ClassNode>();
    private Map<File, ClassNode> classFileMap = new HashMap<File, ClassNode>();
    private ClassLoader classLoader;

    public NoCodeClassNodeLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassNode load(String name) {
        Map<String, ClassNode> map = this.nameMap;
        ClassNode classNode = map.get(name);
        if (classNode == null) {
            String className = ASMUtils.toClassName(name);
            classNode = map.get(className);
            if (classNode == null) {
                classNode = this.create(className);
                map.put(className, classNode);
            }
            if (!name.equals(className)) {
                map.put(name, classNode);
            }
        }
        return classNode;
    }

    public ClassNode load(File classFile) {
        ClassNode classNode = this.classFileMap.get(classFile);
        if (classNode == null) {
            classNode = NoCodeClassNodeLoader.create(classFile);
            this.classFileMap.put(classFile, classNode);
            this.nameMap.put(classNode.name.replace('/', '.'), classNode);
        }
        return classNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode create(String className) {
        ClassNode classNode;
        InputStream inputStream = this.classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
        if (inputStream == null) {
            throw new IllegalArgumentException("Can't load ClassNode for \"" + className + "\"");
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            ClassNode classNode2 = new ClassNode();
            classReader.accept((ClassVisitor)classNode2, 1);
            classNode = classNode2;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException | Error | RuntimeException ex) {
                throw new IllegalArgumentException("Can't load ClassNode for \"" + className + "\"", ex);
            }
        }
        inputStream.close();
        return classNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassNode create(File classFile) {
        try (FileInputStream inputStream = new FileInputStream(classFile.getAbsolutePath());){
            ClassReader classReader = new ClassReader((InputStream)inputStream);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 1);
            ClassNode classNode2 = classNode;
            return classNode2;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Can't load ClassNode for \"" + classFile + "\"", ex);
        }
    }
}

