/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.babyfish.lang.instrument.AbstractInstrumentMojo;

@Mojo(name="instrument", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=false, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(goal="instrument", phase=LifecyclePhase.PROCESS_CLASSES)
public class MainInstrumentMojo
extends AbstractInstrumentMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.doExecute();
    }

    @Override
    protected File getInstrumentDirectory() {
        return this.classesDirectory;
    }

    @Override
    protected String getType() {
        return "main-classes";
    }

    @Override
    protected ClassLoader createClassLoader() {
        URL[] urls = (URL[])this.generateClassPaths().stream().map(AbstractInstrumentMojo::fileNameToURL).toArray(URL[]::new);
        return new URLClassLoader(urls);
    }

    private List<String> generateClassPaths() {
        Set artifacts = this.project.getArtifacts();
        ArrayList<String> classpaths = new ArrayList<String>(2 + artifacts.size());
        classpaths.add(this.classesDirectory.getAbsolutePath());
        for (Artifact artifact : artifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || "test".equalsIgnoreCase(artifact.getScope()) || (file = artifact.getFile()) == null) continue;
            classpaths.add(file.getPath());
        }
        return classpaths;
    }
}

