/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.instrument;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.babyfish.lang.bytecode.ASMTreeUtils;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.lang.instrument.Instrumenter;
import org.babyfish.lang.instrument.NoCodeClassNodeLoader;
import org.babyfish.lang.internal.Instrumented;
import org.babyfish.lang.spi.UsingInstrumenter;
import org.babyfish.org.objectweb.asm.ClassReader;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.ClassWriter;
import org.babyfish.org.objectweb.asm.Type;
import org.babyfish.org.objectweb.asm.tree.AnnotationNode;
import org.babyfish.org.objectweb.asm.tree.ClassNode;
import org.babyfish.org.objectweb.asm.tree.FieldNode;
import org.babyfish.org.objectweb.asm.tree.MethodNode;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public abstract class AbstractInstrumentMojo
extends AbstractMojo {
    private static final int CLASS_MAGIC = -889275714;
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Component
    protected MavenProject project;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        File instrumentDirectory = this.getInstrumentDirectory();
        if (instrumentDirectory == null || !instrumentDirectory.exists()) {
            this.getLog().warn((CharSequence)("Ignore the instrument for the directory \"" + instrumentDirectory + "\""));
            return;
        }
        if (!instrumentDirectory.isDirectory()) {
            throw new ArchiverException("\"" + instrumentDirectory.getAbsolutePath() + "\" is not directory");
        }
        PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
        collection.setIncludes(this.includes());
        collection.setExcludes(this.excludes());
        collection.setBaseDir(instrumentDirectory);
        collection.setIncludingEmptyDirectories(false);
        collection.setPrefix("");
        collection.setUsingDefaultExcludes(true);
        try {
            Iterator resourceItr = collection.getResources();
            this.execute(resourceItr);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to do the instrument", ex);
        }
    }

    protected abstract File getInstrumentDirectory();

    protected abstract String getType();

    protected abstract ClassLoader createClassLoader() throws Exception;

    private String[] includes() {
        String[] includes = this.includes;
        if (includes == null || includes.length == 0) {
            return DEFAULT_INCLUDES;
        }
        return includes;
    }

    private String[] excludes() {
        String[] excludes = this.excludes;
        if (excludes == null || excludes.length == 0) {
            return DEFAULT_EXCLUDES;
        }
        return excludes;
    }

    private void execute(Iterator<PlexusIoResource> resourceItr) throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        NoCodeClassNodeLoader noCodeClassNodeLoader = new NoCodeClassNodeLoader(classLoader);
        LinkedHashMap instrumenterMap = new LinkedHashMap();
        LinkedHashMap<File, LinkedHashSet<Instrumenter>> fileInstrumenterMap = new LinkedHashMap<File, LinkedHashSet<Instrumenter>>();
        while (resourceItr.hasNext()) {
            ClassNode classNode;
            File file;
            PlexusIoResource resource = resourceItr.next();
            if (!(resource instanceof PlexusIoFileResource) || !resource.getName().endsWith(".class") || !AbstractInstrumentMojo.checkMagic(file = ((PlexusIoFileResource)resource).getFile()) || ASMTreeUtils.getAnnotationNode(classNode = noCodeClassNodeLoader.load(file), Instrumented.class) != null) continue;
            Set<Class<?>> instrumenterTypes = this.getInstrumenterTypes(noCodeClassNodeLoader, classNode);
            for (Class<?> intrumenterType : instrumenterTypes) {
                Instrumenter instrumenter = (Instrumenter)instrumenterMap.get(intrumenterType);
                if (instrumenter == null) {
                    instrumenter = (Instrumenter)intrumenterType.newInstance();
                    instrumenter.setNoCodeClassNodeLoader(noCodeClassNodeLoader);
                    instrumenterMap.put(intrumenterType, instrumenter);
                }
                instrumenter.addClassFile(file);
                LinkedHashSet<Instrumenter> instrumenters = (LinkedHashSet<Instrumenter>)fileInstrumenterMap.get(file);
                if (instrumenters == null) {
                    instrumenters = new LinkedHashSet<Instrumenter>();
                    fileInstrumenterMap.put(file, instrumenters);
                }
                instrumenters.add(instrumenter);
            }
        }
        for (Instrumenter instrumenter : instrumenterMap.values()) {
            instrumenter.initialize();
        }
        for (Map.Entry entry : fileInstrumenterMap.entrySet()) {
            ClassWriter classWriter;
            File classFile = (File)entry.getKey();
            Instrumenter[] instrumenters = ((Set)entry.getValue()).toArray(new Instrumenter[((Set)entry.getValue()).size()]);
            ClassNode noCodeClassNode = noCodeClassNodeLoader.load(classFile);
            ClassWriter classVisitor = classWriter = new ClassWriter(1);
            for (int i = instrumenters.length - 1; i >= 0; --i) {
                classVisitor = instrumenters[i].createReplacer(noCodeClassNode.name.replace('/', '.'), classFile).createClassAdapter((ClassVisitor)classVisitor);
            }
            try (FileInputStream inputStream = new FileInputStream(classFile);){
                ClassReader classReader = new ClassReader((InputStream)inputStream);
                classReader.accept((ClassVisitor)classVisitor, 8);
            }
            FileOutputStream outputStream = new FileOutputStream(classFile);
            var14_19 = null;
            try {
                byte[] bytecode = classWriter.toByteArray();
                ((OutputStream)outputStream).write(bytecode);
            }
            catch (Throwable throwable) {
                var14_19 = throwable;
                throw throwable;
            }
            finally {
                if (outputStream == null) continue;
                if (var14_19 != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable) {
                        var14_19.addSuppressed(throwable);
                    }
                    continue;
                }
                ((OutputStream)outputStream).close();
            }
        }
    }

    private static boolean checkMagic(File file) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file.getAbsolutePath()));){
            boolean bl = dataInputStream.readInt() == -889275714;
            return bl;
        }
    }

    private Set<Class<?>> getInstrumenterTypes(NoCodeClassNodeLoader noCodeClassNodeLoader, ClassNode classNode) {
        LinkedHashSet instrumentTypes = new LinkedHashSet();
        String className = classNode.name.replace('/', '.');
        Class<?> instrumentType = this.determineIntrumenterType(noCodeClassNodeLoader, className, classNode);
        if (instrumentType != null) {
            instrumentTypes.add(instrumentType);
        }
        if (classNode.fields != null) {
            for (FieldNode fieldNode : classNode.fields) {
                instrumentType = this.determineIntrumenterType(noCodeClassNodeLoader, className, fieldNode);
                if (instrumentType == null) continue;
                instrumentTypes.add(instrumentType);
            }
        }
        if (classNode.methods != null) {
            for (MethodNode methodNode : classNode.methods) {
                instrumentType = this.determineIntrumenterType(noCodeClassNodeLoader, className, methodNode);
                if (instrumentType == null) continue;
                instrumentTypes.add(instrumentType);
            }
        }
        return instrumentTypes;
    }

    private Class<?> determineIntrumenterType(NoCodeClassNodeLoader noCodeClassNodeLoader, String className, Object asmTreeNode) {
        AnnotationNodeConsumer consumer = new AnnotationNodeConsumer(noCodeClassNodeLoader, className, asmTreeNode);
        ASMTreeUtils.consumeAnnotationNodes(asmTreeNode, (Consumer<AnnotationNode>)consumer);
        if (consumer.instrumenterTypeName != null) {
            Class<?> instrumenterType;
            try {
                instrumenterType = Class.forName(consumer.instrumenterTypeName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalClassException("The annotation \"" + consumer.annotationTypeName + "\" is illegal, its argument \"typeName\" is specified as \"" + consumer.instrumenterTypeName + "\" which is not a class", ex);
            }
            if (!Instrumenter.class.isAssignableFrom(instrumenterType)) {
                throw new IllegalClassException("The annotation \"" + consumer.annotationTypeName + "\" is illegal, its argument \"typeName\" is specified as \"" + consumer.instrumenterTypeName + "\" which does not implements the interface \"" + Instrumenter.class.getName() + "\"");
            }
            return instrumenterType;
        }
        return null;
    }

    private static IllegalClassException conflictAnnotationException(String className, Object asmTreeNode, String annotationTypeName1, String annotationTypeName2) {
        String nodeName;
        String nodeTypeName;
        if (asmTreeNode instanceof FieldNode) {
            nodeTypeName = "field";
            String string = className + '.' + ((FieldNode)asmTreeNode).name;
        }
        if (asmTreeNode instanceof MethodNode) {
            nodeTypeName = "method";
            MethodNode methodNode = (MethodNode)asmTreeNode;
            StringBuilder builder = new StringBuilder();
            builder.append(className).append('.').append(methodNode.name).append('(');
            boolean addComma = false;
            for (Type type : Type.getArgumentTypes((String)methodNode.desc)) {
                if (addComma) {
                    builder.append(", ");
                    continue;
                }
                builder.append(type.getClassName());
            }
            builder.append(')');
            nodeName = builder.toString();
        } else {
            nodeTypeName = "class";
            nodeName = className;
        }
        return new IllegalClassException("The " + nodeTypeName + " \"" + nodeName + "\" is illegal, it's marked by the annotation \"@" + annotationTypeName1 + "\" and @\"" + annotationTypeName2 + "\", both of those two annotations are marked by the annotation \"@" + UsingInstrumenter.class + "\", this is not allowed");
    }

    protected static URL fileNameToURL(String fileName) {
        try {
            return new File(fileName).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("\"" + fileName + "\" cannot be translated to valid URL", ex);
        }
    }

    private static class AnnotationNodeConsumer
    implements Consumer<AnnotationNode> {
        private NoCodeClassNodeLoader noCodeClassNodeLoader;
        private Object asmTreeNode;
        private String className;
        String annotationTypeName;
        String instrumenterTypeName;

        public AnnotationNodeConsumer(NoCodeClassNodeLoader noCodeClassNodeLoader, String className, Object asmTreeNode) {
            this.noCodeClassNodeLoader = noCodeClassNodeLoader;
            this.asmTreeNode = asmTreeNode;
            this.className = className;
        }

        @Override
        public void accept(AnnotationNode annotationNode) {
            ClassNode annotationClassNode = this.noCodeClassNodeLoader.load(annotationNode.desc);
            AnnotationNode usingInsrumenterAnnotationNode = ASMTreeUtils.getAnnotationNode(annotationClassNode, UsingInstrumenter.class);
            if (usingInsrumenterAnnotationNode != null) {
                if (this.annotationTypeName != null) {
                    throw AbstractInstrumentMojo.conflictAnnotationException(this.className, this.asmTreeNode, this.annotationTypeName, ASMUtils.toClassName(annotationNode.desc));
                }
                this.annotationTypeName = ASMUtils.toClassName(annotationNode.desc);
                this.instrumenterTypeName = ASMUtils.toClassName((String)ASMTreeUtils.getAnnotationValue(usingInsrumenterAnnotationNode, "value"));
            }
        }
    }
}

