/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.i18n.metadata;

import java.util.List;
import org.babyfish.lang.I18N;
import org.babyfish.lang.i18n.metadata.MetadataClass;
import org.babyfish.lang.instrument.IllegalClassException;
import org.babyfish.org.objectweb.asm.Type;
import org.babyfish.org.objectweb.asm.tree.MethodNode;
import org.babyfish.org.objectweb.asm.tree.ParameterNode;

public class MetadataMethod {
    private MetadataClass declaringClass;
    private String name;
    private int parameterSlotCount;
    private String[] parameterDescriptors;
    private String[] parameterInternalNames;
    private String[] parameterTypeNames;
    private String[] parameterNames;
    private transient String toString;

    MetadataMethod(MetadataClass declaringClass, MethodNode methodNode) {
        this.declaringClass = declaringClass;
        this.name = methodNode.name;
        this.parameterSlotCount = (Type.getArgumentsAndReturnSizes((String)methodNode.desc) >> 2) - 1;
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        String[] descArr = new String[argumentTypes.length];
        for (int i = descArr.length - 1; i >= 0; --i) {
            descArr[i] = argumentTypes[i].getDescriptor();
        }
        this.parameterDescriptors = descArr;
        String[] internalNameArr = new String[argumentTypes.length];
        String[] typeArr = new String[argumentTypes.length];
        for (int i = typeArr.length - 1; i >= 0; --i) {
            internalNameArr[i] = MetadataMethod.internalName(argumentTypes[i]);
            typeArr[i] = argumentTypes[i].getClassName();
        }
        this.parameterInternalNames = internalNameArr;
        this.parameterTypeNames = typeArr;
        List parameterNodes = methodNode.parameters;
        if (parameterNodes != null) {
            String[] nameArr = new String[parameterNodes.size()];
            for (int i = nameArr.length - 1; i >= 0; --i) {
                nameArr[i] = ((ParameterNode)parameterNodes.get((int)i)).name;
            }
            this.parameterNames = nameArr;
        }
        this.validate(methodNode);
    }

    public String getName() {
        return this.name;
    }

    public int getParameterCount() {
        return this.parameterTypeNames.length;
    }

    public int getParameterSlotCount() {
        return this.parameterSlotCount;
    }

    public String getParameterDescriptor(int index) {
        return this.parameterDescriptors[index];
    }

    public String getParameterInternalName(int index) {
        return this.parameterInternalNames[index];
    }

    public String getParameterTypeName(int index) {
        return this.parameterTypeNames[index];
    }

    public String getParameterName(int index) {
        if (this.parameterNames == null) {
            if (index < 0 || index >= this.parameterTypeNames.length) {
                throw new IndexOutOfBoundsException("index must between 0 and " + this.parameterTypeNames.length);
            }
            return "arg" + index;
        }
        return this.parameterNames[index];
    }

    private void validate(MethodNode methodNode) {
        int access = methodNode.access;
        if ((access & 8) == 0) {
            throw new IllegalClassException("The method \"" + this + "\" must be static because it's marked by \"@" + I18N.class.getName() + "\"");
        }
        if ((access & 0x100) == 0) {
            throw new IllegalClassException("The method \"" + this + "\" must be native because it's marked by \"@" + I18N.class.getName() + "\"");
        }
        if (!methodNode.desc.endsWith(")Ljava/lang/String;")) {
            throw new IllegalClassException("The method \"" + this + "\" must return \"java.lang.String\" because it's marked by \"@" + I18N.class.getName() + "\"");
        }
        if (methodNode.exceptions != null && !methodNode.exceptions.isEmpty()) {
            throw new IllegalClassException("The method \"" + this + "\"can't throw any exception because it's marked by \"@" + I18N.class.getName() + "\"");
        }
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            this.toString = toString = this.calcString();
        }
        return toString;
    }

    private String calcString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.declaringClass.getClassName()).append('.').append(this.name).append('(');
        String[] typeArr = this.parameterTypeNames;
        String[] nameArr = this.parameterNames;
        int len = typeArr.length;
        boolean addComma = false;
        for (int i = 0; i < len; ++i) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(typeArr[i]);
            if (nameArr == null) continue;
            builder.append(' ').append(nameArr[i]);
        }
        builder.append(')');
        return builder.toString();
    }

    private static String internalName(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type.getDescriptor();
            }
        }
        return type.getInternalName();
    }
}

