/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.i18n.instrument;

import java.io.File;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.bytecode.ScopedMethodVisitor;
import org.babyfish.lang.bytecode.ScopedMethodVisitorBuilder;
import org.babyfish.lang.i18n.instrument.ASMConstants;
import org.babyfish.lang.i18n.instrument.TypedI18NInstrumenter;
import org.babyfish.lang.i18n.metadata.MetadataClass;
import org.babyfish.lang.i18n.metadata.MetadataMethod;
import org.babyfish.lang.instrument.bytecode.Replacer;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.Label;
import org.babyfish.org.objectweb.asm.MethodVisitor;

public class TypedI18NReplacer
extends Replacer {
    private MetadataClass metadataClass;

    protected TypedI18NReplacer(TypedI18NInstrumenter instrumenter, String className, File classFile) {
        super(instrumenter, className, classFile);
        this.metadataClass = instrumenter.getMetadataClass(className);
    }

    @Override
    protected ClassVisitor onCreateClassAdapter(ClassVisitor cv) {
        return new ClassAdapter(cv);
    }

    private class ClassAdapter
    extends ClassVisitor {
        public ClassAdapter(ClassVisitor cv) {
            super(327680, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.cv.visitField(10, "{resourceBundle}", ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR, null, null).visitEnd();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MetadataMethod metadataMethod = TypedI18NReplacer.this.metadataClass.getDeclaredMethod(name, desc);
            if (metadataMethod == null) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            ScopedMethodVisitorBuilder builder = new ScopedMethodVisitorBuilder(access & 0xFFFFFEFF, name, new String[0]).output("Ljava/lang/String;");
            int parameterCount = metadataMethod.getParameterCount();
            for (int i = 0; i < parameterCount; ++i) {
                builder.parameter(metadataMethod.getParameterName(i), metadataMethod.getParameterDescriptor(i));
            }
            try (ScopedMethodVisitor mv = builder.build(this.cv);){
                mv.visitCode();
                this.generateI18NInsns(mv, metadataMethod);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            return null;
        }

        private void generateI18NInsns(ScopedMethodVisitor mv, MetadataMethod metadataMethod) {
            String internalName = TypedI18NReplacer.this.getInternalName();
            Label bundleIsLoadedLabel = new Label();
            mv.declare("bundle", ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR);
            mv.visitFieldInsn(178, internalName, "{resourceBundle}", ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR);
            mv.store("bundle");
            mv.load("bundle");
            mv.visitJumpInsn(199, bundleIsLoadedLabel);
            mv.visitLdcInsn(internalName);
            mv.visitMethodInsn(184, ASMConstants.RESOURCE_BUNDLE_INTERNAL_NAME, "getBundle", "(Ljava/lang/String;)" + ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR, false);
            mv.store("bundle");
            mv.load("bundle");
            mv.visitFieldInsn(179, internalName, "{resourceBundle}", ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR);
            mv.visitLabel(bundleIsLoadedLabel);
            mv.visitFrame(1, 1, new Object[]{ASMConstants.RESOURCE_BUNDLE_INTERNAL_NAME}, 0, null);
            mv.visitFieldInsn(178, internalName, "{resourceBundle}", ASMConstants.RESOURCE_BUNDLE_DESCRIPTOR);
            mv.visitLdcInsn(metadataMethod.getName());
            mv.visitMethodInsn(182, ASMConstants.RESOURCE_BUNDLE_INTERNAL_NAME, "getString", "(Ljava/lang/String;)Ljava/lang/String;", false);
            int parameterCount = metadataMethod.getParameterCount();
            if (parameterCount != 0) {
                int slot = 0;
                for (int i = 0; i < parameterCount; ++i) {
                    String boxTypeInternalName;
                    String pDesc;
                    mv.visitLdcInsn("{" + i + "}");
                    switch (pDesc = metadataMethod.getParameterDescriptor(i)) {
                        case "Z": {
                            boxTypeInternalName = "java/lang/Boolean";
                            break;
                        }
                        case "C": {
                            boxTypeInternalName = "java/lang/Character";
                            break;
                        }
                        case "B": {
                            boxTypeInternalName = "java/lang/Byte";
                            break;
                        }
                        case "S": {
                            boxTypeInternalName = "java/lang/Short";
                            break;
                        }
                        case "I": {
                            boxTypeInternalName = "java/lang/Integer";
                            break;
                        }
                        case "J": {
                            boxTypeInternalName = "java/lang/Long";
                            break;
                        }
                        case "F": {
                            boxTypeInternalName = "java/lang/Float";
                            break;
                        }
                        case "D": {
                            boxTypeInternalName = "java/lang/Double";
                            break;
                        }
                        default: {
                            boxTypeInternalName = null;
                        }
                    }
                    if (boxTypeInternalName != null) {
                        mv.visitVarInsn(ASMUtils.getLoadCode(pDesc), slot);
                        mv.visitMethodInsn(184, boxTypeInternalName, "toString", '(' + pDesc + ")Ljava/lang/String;", false);
                    } else {
                        mv.visitVarInsn(25, slot);
                        mv.visitMethodInsn(184, ASMConstants.I18N_INTERNAL_NAME, "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
                    }
                    mv.visitMethodInsn(182, "java/lang/String", "replace", '(' + ASMConstants.CHAR_SEQUENCE_DESCRIPTOR + ASMConstants.CHAR_SEQUENCE_DESCRIPTOR + ")Ljava/lang/String;", false);
                    slot += ASMUtils.getSlotCount(pDesc);
                }
            }
            mv.visitInsn(176);
        }
    }
}

