/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.bytecode;

import java.util.HashSet;
import java.util.function.Consumer;
import org.babyfish.lang.bytecode.ASMUtils;
import org.babyfish.lang.bytecode.VariableScope;
import org.babyfish.lang.bytecode.VariableScopeBuilder;
import org.babyfish.org.objectweb.asm.Label;
import org.babyfish.org.objectweb.asm.MethodVisitor;

public class ScopedMethodVisitor
extends MethodVisitor
implements VariableScope {
    private VariableScopeBuilder scopeBuilder;
    private VariableScope scope;

    ScopedMethodVisitor(VariableScopeBuilder scopeBuilder, MethodVisitor mv) {
        super(327680, mv);
        this.scopeBuilder = scopeBuilder;
    }

    private ScopedMethodVisitor(VariableScope scope, MethodVisitor mv) {
        super(327680, mv);
        this.scope = scope;
    }

    public void visitTryCatch(Consumer<ScopedMethodVisitor> tryGenerationLambda, Catch ... catches) {
        this.visitTryCatch("ex", tryGenerationLambda, catches);
    }

    public void visitTryCatch(String exVariableName, Consumer<ScopedMethodVisitor> tryGenerationLambda, Catch ... catches) {
        int i;
        if (catches.length == 0) {
            tryGenerationLambda.accept(this);
            return;
        }
        HashSet<String> exTypeSet = new HashSet<String>();
        for (Catch katch : catches) {
            if (exTypeSet.add(katch.exceptionInternalName)) continue;
            throw new IllegalArgumentException("Duplicated catches for \"" + katch.exceptionInternalName + "\"");
        }
        Label beginTryLabel = new Label();
        Label endTryLabel = new Label();
        Label[] handleLabels = new Label[catches.length];
        for (int i2 = handleLabels.length - 1; i2 >= 0; --i2) {
            handleLabels[i2] = new Label();
        }
        Label finalEndLabel = new Label();
        this.mv.visitLabel(beginTryLabel);
        tryGenerationLambda.accept(this);
        this.mv.visitJumpInsn(167, finalEndLabel);
        this.mv.visitLabel(endTryLabel);
        for (i = 0; i < catches.length; ++i) {
            this.mv.visitLabel(handleLabels[i]);
            try (ScopedMethodVisitor subMV = this.createSubScope();){
                subMV.declare(exVariableName, ASMUtils.toDescriptor(catches[i].exceptionInternalName));
                subMV.store(exVariableName);
                catches[i].generationLambda.accept(subMV);
                this.mv.visitJumpInsn(167, finalEndLabel);
                continue;
            }
        }
        this.mv.visitLabel(finalEndLabel);
        for (i = 0; i < catches.length; ++i) {
            this.mv.visitTryCatchBlock(beginTryLabel, endTryLabel, handleLabels[i], catches[i].exceptionInternalName);
        }
    }

    public void visitTryFinally(Consumer<ScopedMethodVisitor> tryGenerationLambda, Consumer<ScopedMethodVisitor> finallyGenerationLambda) {
        Label tryLabel = new Label();
        Label catchLabel = new Label();
        Label finallyLabel = new Label();
        this.mv.visitLabel(tryLabel);
        tryGenerationLambda.accept(new NoReturningMethodVisitor(this.scope, this.mv));
        this.mv.visitJumpInsn(167, finallyLabel);
        this.mv.visitLabel(catchLabel);
        try (ScopedMethodVisitor subMV = this.createSubScope();){
            String hiddenName = subMV.allocateHiddenName();
            subMV.declare(hiddenName, "Ljava/lang/Throwable;");
            subMV.store(hiddenName);
            finallyGenerationLambda.accept(this);
            subMV.load(hiddenName);
            this.mv.visitInsn(191);
        }
        this.mv.visitLabel(finallyLabel);
        finallyGenerationLambda.accept(this);
        this.mv.visitTryCatchBlock(tryLabel, catchLabel, catchLabel, null);
    }

    @Override
    public ScopedMethodVisitor declare(String name, String desc) {
        this.scope.declare(name, desc);
        return this;
    }

    @Override
    public ScopedMethodVisitor declare(String name, String desc, String signature) {
        this.scope.declare(name, desc, signature);
        return this;
    }

    @Override
    public VariableScope declareImmediately(String name, String desc) {
        this.scope.declareImmediately(name, desc);
        return this;
    }

    @Override
    public VariableScope declareImmediately(String name, String desc, String signature) {
        this.scope.declareImmediately(name, desc, signature);
        return this;
    }

    @Override
    public ScopedMethodVisitor store(String name) {
        this.scope.store(name);
        return this;
    }

    @Override
    public ScopedMethodVisitor load(String name) {
        this.scope.load(name);
        return this;
    }

    @Override
    public int slot(String name) {
        return this.scope.slot(name);
    }

    @Override
    public String descriptor(String name) {
        return this.scope.descriptor(name);
    }

    @Override
    public String allocateHiddenName() {
        return this.scope.allocateHiddenName();
    }

    @Override
    public ScopedMethodVisitor createSubScope() {
        return new ScopedMethodVisitor(this.scope.createSubScope(), this.mv);
    }

    public void visitCode() {
        super.visitCode();
        if (this.scopeBuilder == null) {
            throw new IllegalStateException("'visitCode' can only be supported by root ScopedMethodVisitor");
        }
        if (this.scope != null) {
            throw new IllegalStateException("'visitCode' has been already been executed");
        }
        this.scope = this.scopeBuilder.build(this.mv);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.scope == null) {
            throw new IllegalStateException("'visitCode' has not been executed before exeute the 'visitMaxs'");
        }
        this.scope.close();
        this.scopeBuilder = null;
        this.scope = null;
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void close() {
        if (this.scopeBuilder != null) {
            throw new IllegalStateException("root ScopedMethodVisitor requires the 'visitMaxs' before closing");
        }
        if (this.scope != null) {
            this.scope.close();
        }
    }

    private static class NoReturningMethodVisitor
    extends ScopedMethodVisitor {
        NoReturningMethodVisitor(VariableScope scope, MethodVisitor mv) {
            super(scope, mv);
        }

        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    throw new UnsupportedOperationException("Can't generate returning statement in the try block of try-finally statement");
                }
            }
            super.visitInsn(opcode);
        }
    }

    public static final class Catch {
        String exceptionInternalName;
        Consumer<ScopedMethodVisitor> generationLambda;

        public Catch(Consumer<ScopedMethodVisitor> generationLambda) {
            this.exceptionInternalName = "java/lang/Throwable";
            this.generationLambda = generationLambda;
        }

        public Catch(String exceptionInternalName, Consumer<ScopedMethodVisitor> generationLambda) {
            if (exceptionInternalName == null || exceptionInternalName.isEmpty()) {
                exceptionInternalName = "java/lang/Throwable";
            }
            this.exceptionInternalName = exceptionInternalName;
            this.generationLambda = generationLambda;
        }
    }
}

