/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.bytecode;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.babyfish.org.objectweb.asm.Handle;
import org.babyfish.org.objectweb.asm.Label;
import org.babyfish.org.objectweb.asm.MethodVisitor;
import org.babyfish.org.objectweb.asm.Type;

public class ASMUtils {
    public static int getSlotCount(String desc) {
        return "D".equals(desc) || "J".equals(desc) ? 2 : 1;
    }

    public static int getLoadCode(String desc) {
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 21;
            }
            case 'J': {
                return 22;
            }
            case 'F': {
                return 23;
            }
            case 'D': {
                return 24;
            }
        }
        return 25;
    }

    public static int getStoreCode(String desc) {
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 54;
            }
            case 'J': {
                return 55;
            }
            case 'F': {
                return 56;
            }
            case 'D': {
                return 57;
            }
        }
        return 58;
    }

    public static int getDefaultCode(String desc) {
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 3;
            }
            case 'J': {
                return 9;
            }
            case 'F': {
                return 11;
            }
            case 'D': {
                return 14;
            }
        }
        return 1;
    }

    public static int getReturnCode(String desc) {
        switch (desc.charAt(0)) {
            case 'V': {
                return 177;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 172;
            }
            case 'J': {
                return 173;
            }
            case 'F': {
                return 174;
            }
            case 'D': {
                return 175;
            }
        }
        return 176;
    }

    public static String toClassName(String name) {
        if (name.charAt(0) == '[') {
            throw new IllegalArgumentException("laxClassName can't start with '['");
        }
        if (name.endsWith("[]")) {
            throw new IllegalArgumentException("laxClassName can't end with '[]'");
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        return name.replace('/', '.');
    }

    public static String toInternalName(String name) {
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        return name.replace('.', '/');
    }

    public static String toDescriptor(String name) {
        switch (name.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case '[': {
                return name;
            }
            case 'L': {
                if (name.charAt(name.length() - 1) != ';') break;
                return name;
            }
        }
        return 'L' + name.replace('.', '/') + ';';
    }

    public static void visitClassLdc(MethodVisitor mv, Class<?> clazz) {
        if (clazz == null) {
            mv.visitInsn(1);
            return;
        }
        ASMUtils.visitClassLdc(mv, Type.getDescriptor(clazz));
    }

    public static void visitClassLdc(MethodVisitor mv, String descriptor) {
        if (descriptor == null || descriptor.isEmpty()) {
            mv.visitInsn(1);
            return;
        }
        switch (descriptor.charAt(0)) {
            case 'Z': {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'C': {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'B': {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'S': {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'I': {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'J': {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'F': {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 'D': {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            default: {
                mv.visitLdcInsn((Object)Type.getType((String)descriptor));
            }
        }
    }

    public static <E extends Enum<E>> void visitEnumLdc(MethodVisitor mv, Enum<E> enumValue) {
        if (enumValue == null) {
            mv.visitInsn(1);
            return;
        }
        Class<?> eventClass = enumValue.getClass();
        mv.visitFieldInsn(178, eventClass.getName().replace('.', '/'), enumValue.name(), Type.getDescriptor(eventClass));
    }

    public static void visitLambda(MethodVisitor mv, String lambdaDesc, String lambdaMethodName, String lambdaMethodErasedDesc, String lambdaMethodRuntimeDesc, String[] lambdaHighLevelVariableDescs, int targetTag, String targetOwner, String targetMethodName, String targetMethodDesc) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        if (lambdaHighLevelVariableDescs != null) {
            for (String lambdaHighLevelVariableDesc : lambdaHighLevelVariableDescs) {
                builder.append(lambdaHighLevelVariableDesc);
            }
        }
        builder.append(')');
        builder.append(lambdaDesc);
        mv.visitInvokeDynamicInsn(lambdaMethodName, builder.toString(), new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"), new Object[]{Type.getMethodType((String)lambdaMethodErasedDesc), new Handle(targetTag, targetOwner, targetMethodName, targetMethodDesc), Type.getMethodType((String)lambdaMethodRuntimeDesc)});
    }

    public static void visitBox(MethodVisitor mv, String descriptor, Consumer<MethodVisitor> loadVarLabmda) {
        String initDesc;
        String boxInternalName;
        if (descriptor.equals("V")) {
            throw new IllegalArgumentException("descriptor cannot be 'V'");
        }
        switch (descriptor.charAt(0)) {
            case 'Z': {
                boxInternalName = "java/lang/Boolean";
                initDesc = "(Z)V";
                break;
            }
            case 'C': {
                boxInternalName = "java/lang/Character";
                initDesc = "(C)V";
                break;
            }
            case 'B': {
                boxInternalName = "java/lang/Byte";
                initDesc = "(B)V";
                break;
            }
            case 'S': {
                boxInternalName = "java/lang/Short";
                initDesc = "(S)V";
                break;
            }
            case 'I': {
                boxInternalName = "java/lang/Integer";
                initDesc = "(I)V";
                break;
            }
            case 'J': {
                boxInternalName = "java/lang/Long";
                initDesc = "(J)V";
                break;
            }
            case 'F': {
                boxInternalName = "java/lang/Float";
                initDesc = "(F)V";
                break;
            }
            case 'D': {
                boxInternalName = "java/lang/Double";
                initDesc = "(D)V";
                break;
            }
            default: {
                loadVarLabmda.accept(mv);
                return;
            }
        }
        mv.visitTypeInsn(187, boxInternalName);
        mv.visitInsn(89);
        loadVarLabmda.accept(mv);
        mv.visitMethodInsn(183, boxInternalName, "<init>", initDesc, false);
    }

    public static void visitEquals(MethodVisitor mv, String descriptor, boolean nullable, Consumer<MethodVisitor> equalBranchLambda) {
        if (descriptor.equals("V")) {
            throw new IllegalArgumentException("descriptor cannot be 'V'");
        }
        if ("Z".equals(descriptor) || "C".equals(descriptor) || "B".equals(descriptor) || "S".equals(descriptor) || "I".equals(descriptor)) {
            Label notEqualLabel = new Label();
            mv.visitJumpInsn(160, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        } else if ("J".equals(descriptor)) {
            Label notEqualLabel = new Label();
            mv.visitInsn(148);
            mv.visitJumpInsn(154, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        } else if ("F".equals(descriptor)) {
            Label notEqualLabel = new Label();
            mv.visitInsn(149);
            mv.visitJumpInsn(154, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        } else if ("D".equals(descriptor)) {
            Label notEqualLabel = new Label();
            mv.visitInsn(151);
            mv.visitJumpInsn(154, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        } else if (descriptor.charAt(0) == '[') {
            String arrayDesc;
            switch (descriptor.charAt(1)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    arrayDesc = descriptor;
                    break;
                }
                default: {
                    arrayDesc = "[Ljava/lang/Object;";
                }
            }
            Label notEqualLabel = new Label();
            mv.visitMethodInsn(184, Type.getInternalName(Arrays.class), "equals", '(' + arrayDesc + arrayDesc + ")Z", false);
            mv.visitJumpInsn(153, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        } else {
            Label notEqualLabel = new Label();
            if (nullable) {
                mv.visitMethodInsn(184, Type.getInternalName(Objects.class), "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            } else {
                mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            }
            mv.visitJumpInsn(153, notEqualLabel);
            equalBranchLambda.accept(mv);
            mv.visitLabel(notEqualLabel);
        }
    }

    public static void visitUnbox(MethodVisitor mv, String descriptor, boolean needCheckcast) {
        String unboxDesc;
        String unboxName;
        String boxInternalName;
        switch (descriptor.charAt(0)) {
            case 'Z': {
                boxInternalName = "java/lang/Boolean";
                unboxName = "booleanValue";
                unboxDesc = "()Z";
                break;
            }
            case 'C': {
                boxInternalName = "java/lang/Character";
                unboxName = "charValue";
                unboxDesc = "()C";
                break;
            }
            case 'B': {
                boxInternalName = "java/lang/Byte";
                unboxName = "byteValue";
                unboxDesc = "()B";
                break;
            }
            case 'S': {
                boxInternalName = "java/lang/Short";
                unboxName = "shortValue";
                unboxDesc = "()S";
                break;
            }
            case 'I': {
                boxInternalName = "java/lang/Integer";
                unboxName = "intValue";
                unboxDesc = "()I";
                break;
            }
            case 'J': {
                boxInternalName = "java/lang/Long";
                unboxName = "longValue";
                unboxDesc = "()J";
                break;
            }
            case 'F': {
                boxInternalName = "java/lang/Float";
                unboxName = "floatValue";
                unboxDesc = "()F";
                break;
            }
            case 'D': {
                boxInternalName = "java/lang/Double";
                unboxName = "doubleValue";
                unboxDesc = "()D";
                break;
            }
            default: {
                if (needCheckcast) {
                    mv.visitTypeInsn(192, ASMUtils.toInternalName(descriptor));
                }
                return;
            }
        }
        if (needCheckcast) {
            mv.visitTypeInsn(192, boxInternalName);
        }
        mv.visitMethodInsn(182, boxInternalName, unboxName, unboxDesc, false);
    }

    private ASMUtils() {
    }
}

