/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.lang.bytecode;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.org.objectweb.asm.Type;
import org.babyfish.org.objectweb.asm.tree.AnnotationNode;
import org.babyfish.org.objectweb.asm.tree.ClassNode;
import org.babyfish.org.objectweb.asm.tree.FieldNode;
import org.babyfish.org.objectweb.asm.tree.MethodNode;

public class ASMTreeUtils {
    @Deprecated
    protected ASMTreeUtils() {
        throw new UnsupportedOperationException();
    }

    public static List<AnnotationNode> getVisibleAnnotations(Object node) {
        List list = null;
        if (node instanceof ClassNode) {
            list = ((ClassNode)node).visibleAnnotations;
        } else if (node instanceof FieldNode) {
            list = ((FieldNode)node).visibleAnnotations;
        } else if (node instanceof MethodNode) {
            list = ((MethodNode)node).visibleAnnotations;
        } else {
            throw new IllegalArgumentException("node must be instance of \"" + ClassNode.class.getName() + "\", \"" + MethodNode.class.getName() + "\" or \"" + FieldNode.class.getName() + "\"");
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static List<AnnotationNode> getInvisibleAnnotations(Object node) {
        List list = null;
        if (node instanceof ClassNode) {
            list = ((ClassNode)node).invisibleAnnotations;
        } else if (node instanceof FieldNode) {
            list = ((FieldNode)node).invisibleAnnotations;
        } else if (node instanceof MethodNode) {
            list = ((MethodNode)node).invisibleAnnotations;
        } else {
            throw new IllegalArgumentException("node must be instance of \"" + ClassNode.class.getName() + "\", \"" + MethodNode.class.getName() + "\" or \"" + FieldNode.class.getName() + "\"");
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static void consumeAnnotationNodes(Object asmTreeNode, Consumer<AnnotationNode> consumer) {
        if (asmTreeNode instanceof ClassNode) {
            ASMTreeUtils.consumeAnnotationNodes((ClassNode)asmTreeNode, consumer);
        } else if (asmTreeNode instanceof FieldNode) {
            ASMTreeUtils.consumeAnnotationNodes((FieldNode)asmTreeNode, consumer);
        } else if (asmTreeNode instanceof MethodNode) {
            ASMTreeUtils.consumeAnnotationNodes((MethodNode)asmTreeNode, consumer);
        } else {
            throw new IllegalArgumentException("\"asmTreeNode\" must be instance of \"" + ClassNode.class.getName() + "\", \"" + FieldNode.class.getName() + "\" or \"" + MethodNode.class.getName() + "\"");
        }
    }

    public static void consumeAnnotationNodes(ClassNode classNode, Consumer<AnnotationNode> consumer) {
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : classNode.invisibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
    }

    public static void consumeAnnotationNodes(FieldNode fieldNode, Consumer<AnnotationNode> consumer) {
        if (fieldNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.visibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
        if (fieldNode.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : fieldNode.invisibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
    }

    public static void consumeAnnotationNodes(MethodNode methodNode, Consumer<AnnotationNode> consumer) {
        if (methodNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : methodNode.visibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
        if (methodNode.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : methodNode.invisibleAnnotations) {
                consumer.accept(annotationNode);
            }
        }
    }

    public static AnnotationNode getAnnotationNode(Object node, Class<?> annotationType) {
        String desc = Type.getDescriptor(annotationType);
        for (AnnotationNode annotationNode : ASMTreeUtils.getVisibleAnnotations(node)) {
            if (!annotationNode.desc.equals(desc)) continue;
            return annotationNode;
        }
        for (AnnotationNode annotationNode : ASMTreeUtils.getInvisibleAnnotations(node)) {
            if (!annotationNode.desc.equals(desc)) continue;
            return annotationNode;
        }
        return null;
    }

    public static <T> T getAnnotationValue(AnnotationNode annotationNode, String name) {
        if (annotationNode.values != null) {
            Iterator itr = annotationNode.values.iterator();
            while (itr.hasNext()) {
                String n = (String)itr.next();
                Object v = itr.next();
                if (v == null || !n.equals(name)) continue;
                return (T)v;
            }
        }
        return null;
    }

    public static <T> T getAnnotationValue(AnnotationNode annotationNode, String name, T defaultValue) {
        T value = ASMTreeUtils.getAnnotationValue(annotationNode, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <E extends Enum<E>> E getAnnotationEnumValue(Class<E> enumType, AnnotationNode annotationNode, String name) {
        String[] pair = (String[])ASMTreeUtils.getAnnotationValue(annotationNode, name);
        if (pair != null) {
            return Enum.valueOf(enumType, pair[1]);
        }
        return null;
    }

    public static <E extends Enum<E>> E getAnnotationEnumValue(Class<E> enumType, AnnotationNode annotationNode, String name, E defaultValue) {
        E value = ASMTreeUtils.getAnnotationEnumValue(enumType, annotationNode, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

