/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.path;

import java.lang.reflect.Array;
import org.babyfish.lang.Arguments;
import org.babyfish.lang.Nulls;
import org.babyfish.persistence.path.FetchPath;
import org.babyfish.persistence.path.SimpleOrderPath;
import org.babyfish.persistence.path.TypedQueryPath;

public class TypedQueryPaths {
    protected TypedQueryPaths() {
        throw new UnsupportedOperationException();
    }

    public static <R, P extends TypedQueryPath<R>> P[] combine(P[] pathArr1, P ... pathArr2) {
        if (Nulls.isNullOrEmpty((Object[])pathArr1)) {
            return pathArr2;
        }
        if (Nulls.isNullOrEmpty((Object[])pathArr2)) {
            return pathArr1;
        }
        TypedQueryPath[] arr = (TypedQueryPath[])Array.newInstance(pathArr1.getClass().getComponentType(), pathArr1.length + pathArr2.length);
        System.arraycopy(pathArr1, 0, arr, 0, pathArr1.length);
        System.arraycopy(pathArr2, 0, arr, pathArr1.length, pathArr2.length);
        return arr;
    }

    public static <R, P extends TypedQueryPath<R>> P[] combine(P path, P ... pathArr) {
        if (path == null) {
            return pathArr;
        }
        Arguments.mustNotBeNull((String)"pathArr", pathArr);
        TypedQueryPath[] arr = (TypedQueryPath[])Array.newInstance(pathArr.getClass().getComponentType(), pathArr.length + 1);
        arr[0] = path;
        System.arraycopy(pathArr, 0, arr, 1, pathArr.length);
        return arr;
    }

    public static <R, P extends TypedQueryPath<R>> P[] fetchPaths(P ... pathArr) {
        if (Nulls.isNullOrEmpty((Object[])pathArr)) {
            return pathArr;
        }
        int len = 0;
        for (P queryPath : pathArr) {
            if (!(queryPath instanceof FetchPath)) continue;
            ++len;
        }
        if (len == pathArr.length) {
            return pathArr;
        }
        TypedQueryPath[] arr = (TypedQueryPath[])Array.newInstance(pathArr.getClass().getComponentType(), len);
        len = 0;
        for (P queryPath : pathArr) {
            if (!(queryPath instanceof FetchPath)) continue;
            arr[len++] = queryPath;
        }
        return arr;
    }

    public static <R, P extends TypedQueryPath<R>> P[] simpleOrderPaths(P ... pathArr) {
        if (Nulls.isNullOrEmpty((Object[])pathArr)) {
            return pathArr;
        }
        int len = 0;
        for (P queryPath : pathArr) {
            if (!(queryPath instanceof SimpleOrderPath)) continue;
            ++len;
        }
        if (len == pathArr.length) {
            return pathArr;
        }
        TypedQueryPath[] arr = (TypedQueryPath[])Array.newInstance(pathArr.getClass().getComponentType(), len);
        len = 0;
        for (P queryPath : pathArr) {
            if (!(queryPath instanceof SimpleOrderPath)) continue;
            arr[len++] = queryPath;
        }
        return arr;
    }
}

