/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.model.metadata;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.Transient;
import org.babyfish.collection.EqualityComparator;
import org.babyfish.collection.FrozenContext;
import org.babyfish.collection.FrozenEqualityComparator;
import org.babyfish.collection.HashMap;
import org.babyfish.collection.LinkedHashMap;
import org.babyfish.collection.MACollection;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.MAList;
import org.babyfish.collection.MAMap;
import org.babyfish.collection.MANavigableMap;
import org.babyfish.collection.MANavigableSet;
import org.babyfish.collection.MAOrderedMap;
import org.babyfish.collection.MAOrderedSet;
import org.babyfish.collection.MASet;
import org.babyfish.collection.MASortedMap;
import org.babyfish.collection.MASortedSet;
import org.babyfish.collection.XCollection;
import org.babyfish.collection.XList;
import org.babyfish.collection.XMap;
import org.babyfish.collection.XNavigableMap;
import org.babyfish.collection.XNavigableSet;
import org.babyfish.collection.XOrderedMap;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.collection.XSet;
import org.babyfish.collection.XSortedMap;
import org.babyfish.collection.XSortedSet;
import org.babyfish.lang.Action;
import org.babyfish.lang.Arguments;
import org.babyfish.lang.IllegalProgramException;
import org.babyfish.lang.reflect.ClassInfo;
import org.babyfish.lang.reflect.GenericTypes;
import org.babyfish.lang.reflect.NoSuchPropertyInfoException;
import org.babyfish.lang.reflect.PropertyInfo;
import org.babyfish.lang.reflect.asm.ASM;
import org.babyfish.lang.reflect.asm.XMethodVisitor;
import org.babyfish.model.ObjectModel;
import org.babyfish.model.metadata.AssociationProperty;
import org.babyfish.model.metadata.Contravariance;
import org.babyfish.model.metadata.Metadatas;
import org.babyfish.model.metadata.ObjectModelMetadata;
import org.babyfish.model.metadata.ObjectModelMode;
import org.babyfish.model.metadata.Property;
import org.babyfish.model.metadata.ScalarProperty;
import org.babyfish.model.metadata.spi.AbstractWrapperMetadatas;
import org.babyfish.model.spi.ObjectModelFactoryProvider;
import org.babyfish.org.objectweb.asm.ClassVisitor;
import org.babyfish.org.objectweb.asm.Label;
import org.babyfish.org.objectweb.asm.MethodVisitor;
import org.babyfish.org.objectweb.asm.Type;
import org.babyfish.persistence.model.metadata.EntityId;
import org.babyfish.persistence.model.metadata.IndexMapping;
import org.babyfish.persistence.model.metadata.Inverse;
import org.babyfish.persistence.model.metadata.JPAAssociationProperty;
import org.babyfish.persistence.model.metadata.JPAObjectModelMetadata;
import org.babyfish.persistence.model.metadata.JPAProperty;
import org.babyfish.persistence.model.metadata.JPAScalarProperty;
import org.babyfish.persistence.model.metadata.KeyMapping;
import org.babyfish.persistence.model.metadata.LazyBehavior;
import org.babyfish.persistence.model.metadata.Mapping;
import org.babyfish.persistence.model.metadata.OptimisticLock;
import org.babyfish.persistence.model.metadata.spi.JPADefaultOwnerEqualityComparatorWritingReplacement;
import org.babyfish.reference.Reference;
import org.babyfish.util.LazyResource;

public class JPAMetadatas
extends AbstractWrapperMetadatas {
    private static final long serialVersionUID = 7028574829375482316L;
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private static final JPAMetadatas INSTANCE = (JPAMetadatas)JPAMetadatas.getInstance(JPAMetadatas.class);
    private static final String NAME_POSTFIX = "92B8C17E_BF4E_4135_B596_5A76E0FEBF4E";
    private static final String REPLACEMENT = "{REPLACEMENT}";
    private static final Map<String, JPAAssociationProperty> ROLE_ASSOCIATION_CACHE = new HashMap();
    private static final ReadWriteLock ROLE_ASSOCIATION_CACHE_LOCK = new ReentrantReadWriteLock();

    protected JPAMetadatas() {
    }

    public static JPAObjectModelMetadata of(Class<?> ownerClass) {
        return (JPAObjectModelMetadata)INSTANCE.getWrapperObjectModelMetadataImpl(ownerClass);
    }

    public static JPAObjectModelMetadata of(String entityName) {
        try {
            return JPAMetadatas.of(Class.forName(entityName));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).illegalEntityName(entityName), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPAAssociationProperty ofRole(String role) {
        JPAAssociationProperty property = null;
        Lock lock = ROLE_ASSOCIATION_CACHE_LOCK.readLock();
        lock.lock();
        try {
            property = ROLE_ASSOCIATION_CACHE.get(role);
        }
        finally {
            lock.unlock();
        }
        if (property == null) {
            lock = ROLE_ASSOCIATION_CACHE_LOCK.writeLock();
            lock.lock();
            try {
                property = ROLE_ASSOCIATION_CACHE.get(role);
                if (property == null) {
                    int lastIndexOfDot = role.lastIndexOf(46);
                    String ownerClassName = role.substring(0, lastIndexOfDot);
                    String hibernatePropertyName = role.substring(lastIndexOfDot + 1);
                    JPAObjectModelMetadata objectModelMetadata = JPAMetadatas.of(ownerClassName);
                    property = (JPAAssociationProperty)objectModelMetadata.getDeclaredMappingSources().get(hibernatePropertyName);
                    ROLE_ASSOCIATION_CACHE.put(role, property);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return property;
    }

    protected AbstractWrapperMetadatas.AbstractWrapperObjectModelMetadataImpl createWrapperObjectModelMetadataImpl(Class<?> rawClass, AbstractWrapperMetadatas.PreContext context) {
        return new JPAObjectModelMetadataImpl(Metadatas.of(rawClass), context);
    }

    private static interface Resource {
        public String unidirectionalAssociationCanNotBeInverse(Method var1, Class<Inverse> var2);

        public String tooManyInverseAnnotations(Method var1, Method var2, Class<Inverse> var3);

        public String noInverseAnnotation(Method var1, Method var2, Class<Inverse> var3);

        public String conflictScalarAnnotation(Class<?> var1, Method var2, Class<?> var3, Class<?> var4);

        public String entityIdHasBeenDeclaredInSuperMetadata(Method var1, Class<EntityId> var2, Class<?> var3);

        public String duplicatedEntityIdAnnotation(Class<?> var1, Method var2, Method var3, Class<EntityId> var4);

        public String noEntityIdAnnotation(Class<?> var1, Class<EntityId> var2);

        public String entityIdIsPrimitive(Class<?> var1, Method var2, Class<EntityId> var3);

        public String optimisticLockHasBeenDeclaredInSuperMetadata(Method var1, Class<OptimisticLock> var2, Class<?> var3);

        public String duplicatedOptimisticLockAnnotation(Class<?> var1, Method var2, Method var3, Class<OptimisticLock> var4);

        public String illegalEntityName(String var1);

        public String duplicatedJAPPropertyMapping(Class<?> var1, String var2, String var3, Class<?> var4, String var5);

        public String duplicatedJAPPropertyMappings(Class<?> var1, String var2, Class<?> var3, String var4, Class<?> var5, String var6);

        public String noOwnerScalarProperty(Method var1, Class<Mapping> var2, String var3, ClassInfo<?> var4);

        public String ownerScalarPropertyIsStatic(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerScalarPropertyMissGetterOrSetter(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerScalarPropertyReturnIllegalType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, java.lang.reflect.Type var5, java.lang.reflect.Type var6);

        public String noOwnerAssociationProperty(Method var1, Class<Mapping> var2, String var3, ClassInfo<?> var4);

        public String ownerAssociationPropertyIsStatic(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerAssociationPropertyMissGetter(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerReferencePropertyReturnIllegalType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, Class<?> var5, Class<?> var6);

        public String ownerReferencePropertyMissSetter(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerCollectionPropertyMustReturnList(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerCollectionPropertyMustReturnParameterizedType(Method var1, Class<Mapping> var2, String var3, Class<?> var4);

        public String ownerCollectionPropertyReturnNotAllowedType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, Class<?>[] var5, Class<?>[] var6);

        public String ownerCollectionPropertyReturnIllegalType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, Class<?> var5, Class<?> var6);

        public String ownerCollectionPropertyReturnIllegalElementType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, Class<?> var5, Class<?> var6);

        public String ownerCollectionPropertyReturnIllegalKeyType(Method var1, Class<Mapping> var2, String var3, Class<?> var4, Class<?> var5, Class<?> var6);

        public String noOwnerIndexProperty(Method var1, Class<IndexMapping> var2, String var3, ClassInfo<?> var4);

        public String ownerIndexPropertyIsStatic(Method var1, Class<IndexMapping> var2, String var3, Class<?> var4);

        public String ownerIndexPropertyMissGetterOrSetter(Method var1, Class<IndexMapping> var2, String var3, Class<?> var4);

        public String ownerIndexPropertyReturnIllegalType(Method var1, Class<IndexMapping> var2, String var3, Class<?> var4, Class<?> var5);

        public String noOwnerKeyProperty(Method var1, Class<KeyMapping> var2, String var3, ClassInfo<?> var4);

        public String ownerKeyPropertyIsStatic(Method var1, Class<KeyMapping> var2, String var3, Class<?> var4);

        public String ownerKeyPropertyMissGetterOrSetter(Method var1, Class<KeyMapping> var2, String var3, Class<?> var4);

        public String ownerKeyPropertyReturnIllegalType(Method var1, Class<KeyMapping> var2, String var3, Class<?> var4, Class<?> var5, Class<?> var6);

        public String lazyRowLimitMustBeGEZero(Method var1, Class<LazyBehavior> var2);

        public String lazyCountLimitMustBeGEZero(Method var1, Class<LazyBehavior> var2);

        public String lazyCountLimitMustBeLElazyRowLimit(Method var1, Class<LazyBehavior> var2);

        public String lazyBehaviorCanOnlyBeUsedOnInverseProperty(Method var1, Class<LazyBehavior> var2);

        public String contravarianceMustBeMappedAsTransient(Method var1, Class<Contravariance> var2, Method var3, Class<Transient> var4);

        public String contravarianceCanNotBeUsedWith(Method var1, Class<Contravariance> var2, Class<? extends Annotation> var3);
    }

    private static class DefaultOwnerEqualityComparatorForReferenceModeGenerator {
        private JPAObjectModelMetadata objectModelMetadata;
        private JPAScalarProperty idProperty;
        private String className;
        private String internalName;
        private String ownerInternalName;
        private String ownerDescriptor;
        private String objectModelInternalName;
        private FrozenEqualityComparator<?> frozenEqualityComparator;

        public DefaultOwnerEqualityComparatorForReferenceModeGenerator(JPAObjectModelMetadata jpaObjectModelMetadata) {
            Arguments.mustNotBeNull((String)"objectModelMetadata.getEntityIdProperty()", (Object)jpaObjectModelMetadata.getEntityIdProperty());
            JPAObjectModelMetadata superObjectModelMetadata = jpaObjectModelMetadata.getSuperMetadata();
            if (superObjectModelMetadata != null && superObjectModelMetadata.getMode() == ObjectModelMode.REFERENCE) {
                throw new AssertionError();
            }
            this.objectModelMetadata = jpaObjectModelMetadata;
            this.idProperty = jpaObjectModelMetadata.getEntityIdProperty();
            this.className = this.objectModelMetadata.getOwnerClass().getName() + "{defaultJPAFrozenEqualityComparator" + ':' + JPAMetadatas.NAME_POSTFIX + '}';
            this.internalName = this.className.replace('.', '/');
            this.ownerInternalName = ASM.getInternalName((Class)jpaObjectModelMetadata.getOwnerClass());
            this.ownerDescriptor = ASM.getDescriptor((Class)jpaObjectModelMetadata.getOwnerClass());
            this.objectModelInternalName = ASM.getInternalName((Class)jpaObjectModelMetadata.getObjectModelClass());
            this.frozenEqualityComparator = this.generate();
        }

        public FrozenEqualityComparator<?> getFrozenEqualityComparator() {
            return this.frozenEqualityComparator;
        }

        private FrozenEqualityComparator<?> generate() {
            Action<ClassVisitor> cvAction = new Action<ClassVisitor>(){

                public void run(ClassVisitor cv) {
                    DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.generate(cv);
                }
            };
            Class clazz = ASM.loadDynamicClass((ClassLoader)this.objectModelMetadata.getObjectModelClass().getClassLoader(), (String)this.className, (ProtectionDomain)this.objectModelMetadata.getObjectModelClass().getProtectionDomain(), (Action)cvAction);
            try {
                return (FrozenEqualityComparator)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        private void generate(ClassVisitor cv) {
            cv.visit(51, 1, this.className.replace('.', '/'), null, "java/lang/Object", new String[]{ASM.getInternalName(FrozenEqualityComparator.class), ASM.getInternalName(Serializable.class)});
            this.generateSerialVersionUID(cv);
            this.generateReplacement(cv);
            this.generateClinit(cv);
            this.generateInit(cv);
            this.generateHashCodeBridge(cv);
            this.generateHashCode(cv);
            this.generateEqualsBridge(cv);
            this.generateEquals(cv);
            this.generateFreezeBridge(cv, true);
            this.generateFreeze(cv, true);
            this.generateFreezeBridge(cv, false);
            this.generateFreeze(cv, false);
            this.generateWriteReplace(cv);
            cv.visitEnd();
        }

        private void generateSerialVersionUID(ClassVisitor cv) {
            long serialVersionUID = 0L;
            for (int i = this.internalName.length() - 1; i >= 0; --i) {
                serialVersionUID = serialVersionUID * 31L + (long)this.internalName.charAt(i);
            }
            cv.visitField(26, "serialVersionUID", "J", null, (Object)serialVersionUID).visitEnd();
        }

        private void generateReplacement(ClassVisitor cv) {
            cv.visitField(26, JPAMetadatas.REPLACEMENT, "Ljava/lang/Object;", null, null).visitEnd();
        }

        private void generateClinit(ClassVisitor cv) {
            MethodVisitor mv = cv.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, ASM.getInternalName(JPADefaultOwnerEqualityComparatorWritingReplacement.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)Type.getType((String)this.ownerDescriptor));
            mv.visitLdcInsn((Object)0);
            mv.visitIntInsn(188, 10);
            mv.visitMethodInsn(183, ASM.getInternalName(JPADefaultOwnerEqualityComparatorWritingReplacement.class), "<init>", "(Ljava/lang/Class;[I)V", false);
            mv.visitFieldInsn(179, this.internalName, JPAMetadatas.REPLACEMENT, "Ljava/lang/Object;");
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateInit(ClassVisitor cv) {
            MethodVisitor mv = cv.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateHashCodeBridge(ClassVisitor cv) {
            XMethodVisitor mv = ASM.visitMethod((ClassVisitor)cv, (int)4161, (String)"hashCode", (String)"(Ljava/lang/Object;)I", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, this.ownerInternalName);
            mv.visitMethodInsn(182, this.className.replace('.', '/'), "hashCode", '(' + this.ownerDescriptor + ")I", false);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateHashCode(ClassVisitor cv) {
            XMethodVisitor mv = ASM.visitMethod((ClassVisitor)cv, (int)1, (String)"hashCode", (String)('(' + this.ownerDescriptor + ")I"), null, null);
            mv.visitCode();
            final int omIndex = mv.aSlot("om");
            int idIndex = mv.aSlot("id");
            ObjectModelFactoryProvider.visitGetObjectModel((MethodVisitor)mv, (ObjectModelMetadata)this.objectModelMetadata, (int)1);
            mv.visitTypeInsn(192, this.objectModelInternalName);
            mv.visitVarInsn(58, omIndex);
            Action<MethodVisitor> idAction = new Action<MethodVisitor>(){

                public void run(MethodVisitor mv) {
                    mv.visitVarInsn(25, omIndex);
                    mv.visitMethodInsn(185, DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.objectModelInternalName, DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.idProperty.getGetterName(), "()" + ASM.getDescriptor((Class)DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.idProperty.getReturnClass()), true);
                }
            };
            if (this.idProperty.getReturnObjectModelMetadata() != null) {
                ObjectModelFactoryProvider.visitGetObjectModel((MethodVisitor)mv, (ObjectModelMetadata)this.idProperty.getReturnObjectModelMetadata(), (Action)idAction);
            } else {
                idAction.run((Object)mv);
            }
            mv.visitVarInsn(58, idIndex);
            Label idIsNullLabel = new Label();
            mv.visitVarInsn(25, idIndex);
            mv.visitJumpInsn(198, idIsNullLabel);
            mv.visitVarInsn(25, idIndex);
            mv.visitHashCode(Object.class, false);
            mv.visitInsn(172);
            mv.visitLabel(idIsNullLabel);
            mv.visitVarInsn(25, omIndex);
            mv.visitMethodInsn(184, ASM.getInternalName(System.class), "identityHashCode", "(Ljava/lang/Object;)I", false);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateEqualsBridge(ClassVisitor cv) {
            XMethodVisitor mv = ASM.visitMethod((ClassVisitor)cv, (int)4161, (String)"equals", (String)"(Ljava/lang/Object;Ljava/lang/Object;)Z", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, this.ownerInternalName);
            mv.visitVarInsn(25, 2);
            mv.visitTypeInsn(192, this.ownerInternalName);
            mv.visitMethodInsn(182, this.className.replace('.', '/'), "equals", '(' + this.ownerDescriptor + this.ownerDescriptor + ")Z", false);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private XMethodVisitor generateEquals(ClassVisitor cv) {
            XMethodVisitor mv = ASM.visitMethod((ClassVisitor)cv, (int)4161, (String)"equals", (String)('(' + this.ownerDescriptor + this.ownerDescriptor + ")Z"), null, null);
            mv.visitCode();
            int om1Index = mv.aSlot("om1");
            int om2Index = mv.aSlot("om2");
            int id1Index = mv.aSlot("id1");
            int id2Index = mv.aSlot("id2");
            for (int i = 0; i < 2; ++i) {
                int owIndex = i == 0 ? 1 : 2;
                final int omIndex = i == 0 ? om1Index : om2Index;
                int idIndex = i == 0 ? id1Index : id2Index;
                ObjectModelFactoryProvider.visitGetObjectModel((MethodVisitor)mv, (ObjectModelMetadata)this.objectModelMetadata, (int)owIndex);
                mv.visitTypeInsn(192, this.objectModelInternalName);
                mv.visitVarInsn(58, omIndex);
                Action<MethodVisitor> idAction = new Action<MethodVisitor>(){

                    public void run(MethodVisitor mv) {
                        mv.visitVarInsn(25, omIndex);
                        mv.visitMethodInsn(185, DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.objectModelInternalName, DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.idProperty.getGetterName(), "()" + ASM.getDescriptor((Class)DefaultOwnerEqualityComparatorForReferenceModeGenerator.this.idProperty.getReturnClass()), true);
                    }
                };
                if (this.idProperty.getReturnObjectModelMetadata() != null) {
                    ObjectModelFactoryProvider.visitGetObjectModel((MethodVisitor)mv, (ObjectModelMetadata)this.idProperty.getReturnObjectModelMetadata(), (Action)idAction);
                } else {
                    idAction.run((Object)mv);
                }
                mv.visitVarInsn(58, idIndex);
            }
            Label notAllNullLabel = new Label();
            mv.visitVarInsn(25, id1Index);
            mv.visitJumpInsn(199, notAllNullLabel);
            mv.visitVarInsn(25, id2Index);
            mv.visitJumpInsn(199, notAllNullLabel);
            mv.visitVarInsn(25, om1Index);
            mv.visitVarInsn(25, om2Index);
            Label sameOMRefLabel = new Label();
            mv.visitJumpInsn(165, sameOMRefLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(sameOMRefLabel);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(notAllNullLabel);
            mv.visitVarInsn(25, id1Index);
            mv.visitVarInsn(25, id2Index);
            mv.visitEquals(this.idProperty.getReturnClass(), true);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            return mv;
        }

        private void generateFreezeBridge(ClassVisitor cv, boolean freeze) {
            MethodVisitor mv = cv.visitMethod(4161, freeze ? "freeze" : "unfreeze", "(Ljava/lang/Object;" + ASM.getDescriptor(FrozenContext.class) + ")V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, this.ownerInternalName);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, this.className.replace('.', '/'), freeze ? "freeze" : "unfreeze", '(' + this.ownerDescriptor + ASM.getDescriptor(FrozenContext.class) + ")V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateFreeze(ClassVisitor cv, boolean freeze) {
            MethodVisitor mv = cv.visitMethod(4161, freeze ? "freeze" : "unfreeze", '(' + this.ownerDescriptor + ASM.getDescriptor(FrozenContext.class) + ")V", null, null);
            mv.visitCode();
            ObjectModelFactoryProvider.visitGetObjectModel((MethodVisitor)mv, (ObjectModelMetadata)this.objectModelMetadata, (int)1);
            mv.visitTypeInsn(192, ASM.getInternalName(ObjectModel.class));
            mv.visitLdcInsn((Object)this.objectModelMetadata.getEntityIdProperty().getId());
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, ASM.getInternalName(ObjectModel.class), freeze ? "freezeScalar" : "unfreezeScalar", "(I" + ASM.getDescriptor(FrozenContext.class) + ")V", true);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateWriteReplace(ClassVisitor cv) {
            MethodVisitor mv = cv.visitMethod(4, "writeReplace", "()Ljava/lang/Object;", null, new String[]{ASM.getInternalName(ObjectStreamException.class)});
            mv.visitCode();
            mv.visitFieldInsn(178, this.internalName, JPAMetadatas.REPLACEMENT, "Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private static class JPAAssociationPropertyImpl
    extends AbstractWrapperMetadatas.WrapperAssociationPropertyImpl
    implements JPAAssociationProperty {
        private static final long serialVersionUID = -3175893847806034042L;
        private static final String REFERENCE_POSTFIX = "Reference";
        private PropertyInfo ownerProperty;
        private PropertyInfo ownerIndexProperty;
        private PropertyInfo ownerKeyProperty;
        private boolean inverse;

        protected JPAAssociationPropertyImpl(AssociationProperty baseAssociationProperty, AbstractWrapperMetadatas.PreContext context) {
            super(baseAssociationProperty, context);
        }

        @Override
        public JPAObjectModelMetadata getDeclaringObjectModelMetadata() {
            return (JPAObjectModelMetadata)this.declaringWrapperObjectModelMetadata();
        }

        @Override
        public JPAAssociationProperty getOppositeProperty() {
            return (JPAAssociationProperty)this.oppositeProperty();
        }

        @Override
        public JPAAssociationProperty getCovarianceProperty() {
            return (JPAAssociationProperty)this.covarianceProperty();
        }

        @Override
        public JPAObjectModelMetadata getKeyObjectModelMetadata() {
            return (JPAObjectModelMetadata)this.keyObjectModelMetadata();
        }

        @Override
        public JPAObjectModelMetadata getReturnObjectModelMetadata() {
            return (JPAObjectModelMetadata)this.returnObjectModelMetadata();
        }

        @Override
        public PropertyInfo getOwnerProperty() {
            return this.ownerProperty;
        }

        @Override
        public PropertyInfo getOwnerIndexProperty() {
            return this.ownerIndexProperty;
        }

        @Override
        public PropertyInfo getOwnerKeyProperty() {
            return this.ownerKeyProperty;
        }

        @Override
        public boolean isInverse() {
            return this.inverse;
        }

        @Override
        public LazyBehavior getLazyBehavior() {
            return this.getGetterMethod().getAnnotation(LazyBehavior.class);
        }

        protected void parse() {
            AssociationProperty baseAssociationProperty = (AssociationProperty)this.baseProperty;
            Method getterMethod = this.getGetterMethod();
            this.processMapping();
            if (baseAssociationProperty.getCovarianceProperty() != null) {
                if (getterMethod.isAnnotationPresent(IndexMapping.class)) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).contravarianceCanNotBeUsedWith(getterMethod, Contravariance.class, IndexMapping.class));
                }
                if (getterMethod.isAnnotationPresent(KeyMapping.class)) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).contravarianceCanNotBeUsedWith(getterMethod, Contravariance.class, KeyMapping.class));
                }
            } else {
                this.processIndexMapping();
                this.processKeyMapping();
                this.inverse = getterMethod.isAnnotationPresent(Inverse.class);
                LazyBehavior lazyBehavior = getterMethod.getAnnotation(LazyBehavior.class);
                if (this.inverse) {
                    if (lazyBehavior != null) {
                        int rowLimit = lazyBehavior.rowLimit();
                        if (rowLimit < 0) {
                            throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).lazyRowLimitMustBeGEZero(getterMethod, LazyBehavior.class));
                        }
                        int countLimit = lazyBehavior.countLimit();
                        if (countLimit < 0) {
                            throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).lazyCountLimitMustBeGEZero(getterMethod, LazyBehavior.class));
                        }
                        if (countLimit > rowLimit) {
                            throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).lazyCountLimitMustBeLElazyRowLimit(getterMethod, LazyBehavior.class));
                        }
                    }
                } else if (lazyBehavior != null) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).lazyBehaviorCanOnlyBeUsedOnInverseProperty(getterMethod, LazyBehavior.class));
                }
            }
        }

        protected void afterParsing(AbstractWrapperMetadatas.PostContext postContext) {
            if (this.getCovarianceProperty() != null) {
                this.inverse = this.getCovarianceProperty().isInverse();
            } else {
                JPAAssociationProperty oppositeAssociationProperty = this.getOppositeProperty();
                if (this.inverse) {
                    if (oppositeAssociationProperty == null) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).unidirectionalAssociationCanNotBeInverse(this.getGetterMethod(), Inverse.class));
                    }
                    if (oppositeAssociationProperty.isInverse()) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).tooManyInverseAnnotations(this.getGetterMethod(), this.oppositeProperty().getGetterMethod(), Inverse.class));
                    }
                } else if (oppositeAssociationProperty != null && !oppositeAssociationProperty.isInverse()) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noInverseAnnotation(this.getGetterMethod(), this.oppositeProperty().getGetterMethod(), Inverse.class));
                }
            }
        }

        private void processMapping() {
            PropertyInfo ownerProperty;
            String mappingValue;
            Mapping mapping = this.getGetterMethod().getAnnotation(Mapping.class);
            Class standardReturnClass = this.getStandardReturnClass();
            ClassInfo classInfo = ClassInfo.of((java.lang.reflect.Type)this.getDeclaringObjectModelMetadata().getOwnerClass());
            String string = mappingValue = mapping != null ? mapping.value() : "";
            if (mappingValue.length() == 0 && (mappingValue = this.getName()).endsWith(REFERENCE_POSTFIX) && Reference.class.isAssignableFrom(standardReturnClass)) {
                mappingValue = mappingValue.substring(0, mappingValue.length() - REFERENCE_POSTFIX.length());
            }
            try {
                ownerProperty = classInfo.getDeclaredErasedProperty(mappingValue, new Class[0]);
            }
            catch (NoSuchPropertyInfoException ex) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noOwnerAssociationProperty(this.getGetterMethod(), Mapping.class, mappingValue, classInfo));
            }
            if (ownerProperty.getModifiers().isStatic()) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerAssociationPropertyIsStatic(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (ownerProperty.getGetter() == null) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerAssociationPropertyMissGetter(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            Class ownerPropertyClass = GenericTypes.eraseGenericType((java.lang.reflect.Type)ownerProperty.getGenericReturnType());
            if (Reference.class.isAssignableFrom(standardReturnClass)) {
                if (ownerPropertyClass != this.getElementClass()) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerReferencePropertyReturnIllegalType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getElementClass(), ownerPropertyClass));
                }
                if (ownerProperty.getSetter() == null) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerReferencePropertyMissSetter(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
                }
            } else {
                Class ownerReturnKeyClass;
                if (!(ownerProperty.getGenericReturnType() instanceof ParameterizedType)) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyMustReturnParameterizedType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
                }
                if (!ownerPropertyClass.isAssignableFrom(this.getReturnClass())) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyReturnIllegalType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getReturnClass(), ownerPropertyClass));
                }
                if (ownerPropertyClass != Collection.class && ownerPropertyClass != Set.class && ownerPropertyClass != List.class && ownerPropertyClass != Map.class) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyReturnNotAllowedType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), new Class[]{Collection.class, Set.class, List.class, Map.class}, new Class[]{Collection.class, List.class, Set.class, SortedSet.class, NavigableSet.class, Map.class, SortedMap.class, NavigableMap.class, XCollection.class, XList.class, XSet.class, XOrderedSet.class, XSortedSet.class, XNavigableSet.class, XMap.class, XOrderedMap.class, XSortedMap.class, XNavigableMap.class, MACollection.class, MAList.class, MASet.class, MAOrderedSet.class, MASortedSet.class, MANavigableSet.class, MAMap.class, MAOrderedMap.class, MASortedMap.class, MANavigableMap.class}));
                }
                if (ownerPropertyClass == Collection.class && this.getStandardReturnClass() == List.class) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyMustReturnList(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
                }
                java.lang.reflect.Type[] ownerReturnTypeArguments = ((ParameterizedType)ownerProperty.getGenericReturnType()).getActualTypeArguments();
                Class ownerReturnElementClass = GenericTypes.eraseGenericType((java.lang.reflect.Type)ownerReturnTypeArguments[ownerReturnTypeArguments.length - 1]);
                if (ownerReturnElementClass != this.getElementClass()) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyReturnIllegalElementType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getElementClass(), ownerReturnElementClass));
                }
                if (Map.class.isAssignableFrom(standardReturnClass) && (ownerReturnKeyClass = GenericTypes.eraseGenericType((java.lang.reflect.Type)ownerReturnTypeArguments[0])) != this.getKeyClass()) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerCollectionPropertyReturnIllegalKeyType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getKeyClass(), ownerReturnKeyClass));
                }
            }
            this.ownerProperty = ownerProperty;
            if (this.covarianceProperty() != null && !ownerProperty.isAnnotationPresent(Transient.class)) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).contravarianceMustBeMappedAsTransient(this.getGetterMethod(), Contravariance.class, ownerProperty.getGetter().getRawMethod(), Transient.class));
            }
        }

        private void processIndexMapping() {
            PropertyInfo ownerProperty;
            IndexMapping indexMapping = this.getGetterMethod().getAnnotation(IndexMapping.class);
            if (indexMapping == null) {
                return;
            }
            ClassInfo classInfo = ClassInfo.of((java.lang.reflect.Type)this.getDeclaringObjectModelMetadata().getOwnerClass());
            String indexMappingValue = indexMapping.value();
            try {
                ownerProperty = classInfo.getDeclaredErasedProperty(indexMappingValue, new Class[0]);
            }
            catch (NoSuchPropertyInfoException ex) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noOwnerIndexProperty(this.getGetterMethod(), IndexMapping.class, indexMappingValue, classInfo));
            }
            if (ownerProperty.getModifiers().isStatic()) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerIndexPropertyIsStatic(this.getGetterMethod(), IndexMapping.class, indexMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (ownerProperty.getGetter() == null || ownerProperty.getSetter() == null) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerIndexPropertyMissGetterOrSetter(this.getGetterMethod(), IndexMapping.class, indexMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (ownerProperty.getReturnType() != Integer.TYPE) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerIndexPropertyReturnIllegalType(this.getGetterMethod(), IndexMapping.class, indexMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), ownerProperty.getReturnType()));
            }
            this.ownerIndexProperty = ownerProperty;
        }

        private void processKeyMapping() {
            PropertyInfo ownerProperty;
            KeyMapping keyMapping = this.getGetterMethod().getAnnotation(KeyMapping.class);
            if (keyMapping == null) {
                return;
            }
            ClassInfo classInfo = ClassInfo.of((java.lang.reflect.Type)this.getDeclaringObjectModelMetadata().getOwnerClass());
            String keyMappingValue = keyMapping.value();
            try {
                ownerProperty = classInfo.getDeclaredErasedProperty(keyMappingValue, new Class[0]);
            }
            catch (NoSuchPropertyInfoException ex) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noOwnerKeyProperty(this.getGetterMethod(), KeyMapping.class, keyMappingValue, classInfo));
            }
            if (ownerProperty.getModifiers().isStatic()) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerKeyPropertyIsStatic(this.getGetterMethod(), KeyMapping.class, keyMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (ownerProperty.getGetter() == null || ownerProperty.getSetter() == null) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerKeyPropertyMissGetterOrSetter(this.getGetterMethod(), KeyMapping.class, keyMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (ownerProperty.getReturnType() != this.getKeyClass()) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerKeyPropertyReturnIllegalType(this.getGetterMethod(), KeyMapping.class, keyMappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getKeyClass(), ownerProperty.getReturnType()));
            }
            this.ownerKeyProperty = ownerProperty;
        }
    }

    private static class JPAScalarPropertyImpl
    extends AbstractWrapperMetadatas.WrapperScalarPropertyImpl
    implements JPAScalarProperty {
        private static final long serialVersionUID = -2384590689306754913L;
        private PropertyInfo ownerProperty;
        private boolean entityId;
        private boolean optimisticLock;

        public JPAScalarPropertyImpl(ScalarProperty baseProperty, AbstractWrapperMetadatas.PreContext context) {
            super(baseProperty, context);
            this.processMapping();
            this.entityId = this.getGetterMethod().isAnnotationPresent(EntityId.class);
            this.optimisticLock = this.getGetterMethod().isAnnotationPresent(OptimisticLock.class);
            if (this.entityId && this.optimisticLock) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).conflictScalarAnnotation(baseProperty.getDeclaringObjectModelMetadata().getObjectModelClass(), this.getGetterMethod(), EntityId.class, OptimisticLock.class));
            }
        }

        @Override
        public JPAObjectModelMetadata getReturnObjectModelMetadata() {
            return (JPAObjectModelMetadata)this.returnObjectModelMetadata();
        }

        @Override
        public boolean isEntityId() {
            return this.entityId;
        }

        @Override
        public boolean isOptimisticLock() {
            return this.optimisticLock;
        }

        @Override
        public JPAObjectModelMetadata getDeclaringObjectModelMetadata() {
            return (JPAObjectModelMetadata)this.declaringWrapperObjectModelMetadata();
        }

        @Override
        public PropertyInfo getOwnerProperty() {
            return this.ownerProperty;
        }

        private void processMapping() {
            PropertyInfo property;
            String mappingValue;
            Mapping mapping = this.getGetterMethod().getAnnotation(Mapping.class);
            ClassInfo classInfo = ClassInfo.of((java.lang.reflect.Type)this.getDeclaringObjectModelMetadata().getOwnerClass());
            String string = mappingValue = mapping != null ? mapping.value() : "";
            if (mappingValue.length() == 0) {
                mappingValue = this.getName();
            }
            try {
                property = classInfo.getDeclaredErasedProperty(mappingValue, new Class[0]);
            }
            catch (NoSuchPropertyInfoException ex) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noOwnerScalarProperty(this.getGetterMethod(), Mapping.class, mappingValue, classInfo));
            }
            if (property.getModifiers().isStatic()) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerScalarPropertyIsStatic(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (property.getGetter() == null || property.getSetter() == null) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerScalarPropertyMissGetterOrSetter(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass()));
            }
            if (!property.getResolvedGenericReturnType().equals(this.getReturnType())) {
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).ownerScalarPropertyReturnIllegalType(this.getGetterMethod(), Mapping.class, mappingValue, this.getDeclaringObjectModelMetadata().getOwnerClass(), this.getReturnType(), property.getResolvedGenericReturnType()));
            }
            this.ownerProperty = property;
        }
    }

    private static class JPAObjectModelMetadataImpl
    extends AbstractWrapperMetadatas.AbstractWrapperObjectModelMetadataImpl
    implements JPAObjectModelMetadata {
        private static final long serialVersionUID = 8078938452378452380L;
        private static final Object ENTITY_ID_RESOLVED_METATATAS = new Object();
        private static final Object OPTIMISTIC_ID_RESOLVED_METATATAS = new Object();
        private static final Object DEFAULT_OWNER_FROZEN_EQUALITY_COMPARATOR_RESOLVED_METATATAS = new Object();
        JPAScalarProperty declaredEntityIdProperty;
        JPAScalarProperty declaredOptimisticLockProperty;
        private FrozenEqualityComparator<?> defaultOwnerFrozenEqualityComparator;
        private Map<String, JPAProperty> declaredMappingSources;
        private Map<String, JPAAssociationProperty> declaredIndexMappingSources;
        private Map<String, JPAAssociationProperty> declaredKeyMappingSources;
        private Map<String, JPAProperty> mappingSources;
        private Map<String, JPAAssociationProperty> indexMappingSources;
        private Map<String, JPAAssociationProperty> keyMappingSources;

        protected JPAObjectModelMetadataImpl(ObjectModelMetadata baseObjectModelMetadata, AbstractWrapperMetadatas.PreContext context) {
            super(baseObjectModelMetadata, context);
        }

        @Override
        public JPAObjectModelMetadata getSuperMetadata() {
            return (JPAObjectModelMetadata)this.superMetadata();
        }

        @Override
        public Map<String, JPAProperty> getDeclaredMappingSources() {
            return this.declaredMappingSources;
        }

        @Override
        public Map<String, JPAAssociationProperty> getDeclaredIndexMappingSources() {
            return this.declaredIndexMappingSources;
        }

        @Override
        public Map<String, JPAAssociationProperty> getDeclaredKeyMappingSources() {
            return this.declaredKeyMappingSources;
        }

        @Override
        public JPAScalarProperty getDeclaredEntityIdProperty() {
            return this.declaredEntityIdProperty;
        }

        @Override
        public JPAScalarProperty getDeclaredOptimisticLockProperty() {
            return this.declaredOptimisticLockProperty;
        }

        @Override
        public Map<String, JPAProperty> getMappingSources() {
            Object mappingSources = this.mappingSources;
            if (mappingSources == null) {
                JPAObjectModelMetadata superMetadata = this.getSuperMetadata();
                if (superMetadata == null) {
                    mappingSources = this.declaredMappingSources;
                    this.mappingSources = mappingSources;
                } else {
                    mappingSources = new LinkedHashMap(((superMetadata.getMappingSources().size() + this.declaredMappingSources.size()) * 4 + 2) / 3);
                    mappingSources.putAll(superMetadata.getMappingSources());
                    mappingSources.putAll(this.declaredMappingSources);
                    mappingSources = MACollections.unmodifiable((Map)mappingSources);
                    this.mappingSources = mappingSources;
                }
            }
            return mappingSources;
        }

        @Override
        public Map<String, JPAAssociationProperty> getIndexMappingSources() {
            Object indexMappingSources = this.indexMappingSources;
            if (indexMappingSources == null) {
                JPAObjectModelMetadata superMetadata = this.getSuperMetadata();
                if (superMetadata == null) {
                    indexMappingSources = this.declaredIndexMappingSources;
                    this.indexMappingSources = indexMappingSources;
                } else {
                    indexMappingSources = new LinkedHashMap(((superMetadata.getIndexMappingSources().size() + this.declaredIndexMappingSources.size()) * 4 + 2) / 3);
                    indexMappingSources.putAll(superMetadata.getIndexMappingSources());
                    indexMappingSources.putAll(this.declaredIndexMappingSources);
                    indexMappingSources = MACollections.unmodifiable((Map)indexMappingSources);
                    this.indexMappingSources = indexMappingSources;
                }
            }
            return indexMappingSources;
        }

        @Override
        public Map<String, JPAAssociationProperty> getKeyMappingSources() {
            Object keyMappingSources = this.keyMappingSources;
            if (keyMappingSources == null) {
                JPAObjectModelMetadata superMetadata = this.getSuperMetadata();
                if (superMetadata == null) {
                    keyMappingSources = this.declaredKeyMappingSources;
                    this.keyMappingSources = keyMappingSources;
                } else {
                    keyMappingSources = new LinkedHashMap(((superMetadata.getKeyMappingSources().size() + this.declaredKeyMappingSources.size()) * 4 + 2) / 3);
                    keyMappingSources.putAll(superMetadata.getKeyMappingSources());
                    keyMappingSources.putAll(this.declaredKeyMappingSources);
                    keyMappingSources = MACollections.unmodifiable((Map)keyMappingSources);
                    this.keyMappingSources = keyMappingSources;
                }
            }
            return keyMappingSources;
        }

        @Override
        public JPAProperty getDeclaredProperty(String name) {
            return (JPAProperty)this.declaredProperty(name);
        }

        @Override
        public JPAScalarProperty getDeclaredScalarProperty(String name) {
            return (JPAScalarProperty)this.declaredScalarProperty(name);
        }

        @Override
        public JPAAssociationProperty getDeclaredAssociationProperty(String name) {
            return (JPAAssociationProperty)this.declaredAssociationProperty(name);
        }

        @Override
        public JPAProperty getDeclaredProperty(int id) {
            return (JPAProperty)this.declaredProperty(id);
        }

        @Override
        public JPAScalarProperty getDeclaredScalarProperty(int id) {
            return (JPAScalarProperty)this.declaredScalarProperty(id);
        }

        @Override
        public JPAAssociationProperty getDeclaredAssociationProperty(int id) {
            return (JPAAssociationProperty)this.declaredAssociationProperty(id);
        }

        @Override
        public JPAScalarProperty getEntityIdProperty() {
            if (this.declaredEntityIdProperty != null) {
                return this.declaredEntityIdProperty;
            }
            JPAObjectModelMetadata superMetadata = this.getSuperMetadata();
            if (superMetadata != null) {
                return superMetadata.getEntityIdProperty();
            }
            return null;
        }

        @Override
        public JPAScalarProperty getOptimisticLockProperty() {
            if (this.declaredOptimisticLockProperty != null) {
                return this.declaredOptimisticLockProperty;
            }
            JPAObjectModelMetadata superMetadata = this.getSuperMetadata();
            if (superMetadata != null) {
                return superMetadata.getOptimisticLockProperty();
            }
            return null;
        }

        @Override
        public JPAProperty getProperty(String name) {
            return (JPAProperty)this.property(name);
        }

        @Override
        public JPAScalarProperty getScalarProperty(String name) {
            return (JPAScalarProperty)this.scalarProperty(name);
        }

        @Override
        public JPAAssociationProperty getAssociationProperty(String name) {
            return (JPAAssociationProperty)this.associationProperty(name);
        }

        @Override
        public JPAProperty getProperty(int id) {
            return (JPAProperty)this.property(id);
        }

        @Override
        public JPAScalarProperty getScalarProperty(int id) {
            return (JPAScalarProperty)this.scalarProperty(id);
        }

        @Override
        public JPAAssociationProperty getAssociationProperty(int id) {
            return (JPAAssociationProperty)this.associationProperty(id);
        }

        protected <O> EqualityComparator<O> getDefaultOwnerEqualityComparatorForReferenceMode() {
            return this.defaultOwnerFrozenEqualityComparator;
        }

        protected AbstractWrapperMetadatas.WrapperScalarPropertyImpl createWrapperScalarPropertyImpl(ScalarProperty baseScalarProperty, AbstractWrapperMetadatas.PreContext context) {
            return new JPAScalarPropertyImpl(baseScalarProperty, context);
        }

        protected AbstractWrapperMetadatas.WrapperAssociationPropertyImpl createWrapperAssociationPropertyImpl(AssociationProperty baseAssociationProperty, AbstractWrapperMetadatas.PreContext context) {
            return new JPAAssociationPropertyImpl(baseAssociationProperty, context);
        }

        protected boolean afterParsing(AbstractWrapperMetadatas.PostContext postContext) {
            switch (postContext.getPhase()) {
                case 0: {
                    this.buildEntityId(postContext);
                    this.buildOptimisticLock(postContext);
                    return true;
                }
            }
            this.buildDeclaredMappingSourceMaps();
            this.buildDefaultOwnerFrozenEqualityComparatorForReferenceMode(postContext);
            return false;
        }

        private void buildEntityId(AbstractWrapperMetadatas.PostContext postContext) {
            if (postContext.isProcessed(ENTITY_ID_RESOLVED_METATATAS, (AbstractWrapperMetadatas.AbstractWrapperObjectModelMetadataImpl)this)) {
                return;
            }
            JPAObjectModelMetadataImpl superMetadata = (JPAObjectModelMetadataImpl)this.superMetadata();
            if (superMetadata != null) {
                superMetadata.buildEntityId(postContext);
            }
            if (superMetadata != null && superMetadata.getEntityIdProperty() != null) {
                for (ScalarProperty scalarProperty : this.getDeclaredScalarProperties().values()) {
                    JPAScalarPropertyImpl jpaScalarProperty = (JPAScalarPropertyImpl)scalarProperty;
                    if (!jpaScalarProperty.isEntityId()) continue;
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).entityIdHasBeenDeclaredInSuperMetadata(jpaScalarProperty.getGetterMethod(), EntityId.class, superMetadata.getObjectModelClass()));
                }
            } else {
                JPAScalarPropertyImpl entityIdPropertyImpl = null;
                for (ScalarProperty scalarProperty : this.getDeclaredScalarProperties().values()) {
                    JPAScalarPropertyImpl jpaScalarProperty = (JPAScalarPropertyImpl)scalarProperty;
                    if (!jpaScalarProperty.isEntityId()) continue;
                    if (entityIdPropertyImpl != null) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedEntityIdAnnotation(this.getObjectModelClass(), entityIdPropertyImpl.getGetterMethod(), jpaScalarProperty.getGetterMethod(), EntityId.class));
                    }
                    entityIdPropertyImpl = jpaScalarProperty;
                }
                if (this.getMode() == ObjectModelMode.REFERENCE) {
                    if (entityIdPropertyImpl == null) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).noEntityIdAnnotation(this.getObjectModelClass(), EntityId.class));
                    }
                    if (entityIdPropertyImpl.getReturnClass().isPrimitive()) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).entityIdIsPrimitive(this.getObjectModelClass(), entityIdPropertyImpl.getGetterMethod(), EntityId.class));
                    }
                }
                this.declaredEntityIdProperty = entityIdPropertyImpl;
            }
        }

        private void buildOptimisticLock(AbstractWrapperMetadatas.PostContext postContext) {
            if (postContext.isProcessed(OPTIMISTIC_ID_RESOLVED_METATATAS, (AbstractWrapperMetadatas.AbstractWrapperObjectModelMetadataImpl)this)) {
                return;
            }
            JPAObjectModelMetadataImpl superMetadata = (JPAObjectModelMetadataImpl)this.superMetadata();
            if (superMetadata != null) {
                superMetadata.buildOptimisticLock(postContext);
            }
            if (superMetadata != null && superMetadata.getOptimisticLockProperty() != null) {
                for (ScalarProperty scalarProperty : this.getDeclaredScalarProperties().values()) {
                    JPAScalarPropertyImpl jpaScalarProperty = (JPAScalarPropertyImpl)scalarProperty;
                    if (!jpaScalarProperty.isOptimisticLock()) continue;
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).optimisticLockHasBeenDeclaredInSuperMetadata(jpaScalarProperty.getGetterMethod(), OptimisticLock.class, superMetadata.getObjectModelClass()));
                }
            } else {
                JPAScalarPropertyImpl optimisticLockPropertyImpl = null;
                for (ScalarProperty scalarProperty : this.getDeclaredScalarProperties().values()) {
                    JPAScalarPropertyImpl jpaScalarProperty = (JPAScalarPropertyImpl)scalarProperty;
                    if (!jpaScalarProperty.isOptimisticLock()) continue;
                    if (optimisticLockPropertyImpl != null) {
                        throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedOptimisticLockAnnotation(this.getObjectModelClass(), optimisticLockPropertyImpl.getGetterMethod(), jpaScalarProperty.getGetterMethod(), OptimisticLock.class));
                    }
                    optimisticLockPropertyImpl = jpaScalarProperty;
                }
                this.declaredOptimisticLockProperty = optimisticLockPropertyImpl;
            }
        }

        private void buildDeclaredMappingSourceMaps() {
            JPAProperty conflictProperty;
            String name;
            LinkedHashMap declaredMappingSources = new LinkedHashMap();
            LinkedHashMap declaredIndexMappingSources = new LinkedHashMap();
            LinkedHashMap declaredKeyMappingSources = new LinkedHashMap();
            for (Property property : this.getDeclaredProperties().values()) {
                String keyName;
                String indexName;
                JPAProperty conflictJPAProperty;
                String name2;
                JPAProperty conflictJPAProperty2;
                JPAProperty jpaProperty = (JPAProperty)property;
                if (jpaProperty.getOwnerProperty() != null && (conflictJPAProperty2 = declaredMappingSources.put(name2 = jpaProperty.getOwnerProperty().getName(), jpaProperty)) != null) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMapping(this.getObjectModelClass(), jpaProperty.getName(), conflictJPAProperty2.getName(), Mapping.class, name2));
                }
                if (!(property instanceof JPAAssociationProperty)) continue;
                JPAAssociationProperty jpaAssociationProperty = (JPAAssociationProperty)property;
                if (jpaAssociationProperty.getOwnerIndexProperty() != null && (conflictJPAProperty = (JPAProperty)declaredIndexMappingSources.put(indexName = jpaAssociationProperty.getOwnerIndexProperty().getName(), jpaAssociationProperty)) != null) {
                    throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMapping(this.getObjectModelClass(), jpaProperty.getName(), conflictJPAProperty.getName(), IndexMapping.class, indexName));
                }
                if (jpaAssociationProperty.getOwnerKeyProperty() == null || (conflictJPAProperty = (JPAProperty)declaredKeyMappingSources.put(keyName = jpaAssociationProperty.getOwnerKeyProperty().getName(), jpaAssociationProperty)) == null) continue;
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMapping(this.getObjectModelClass(), jpaProperty.getName(), conflictJPAProperty.getName(), KeyMapping.class, keyName));
            }
            for (Map.Entry entry : declaredMappingSources.entrySet()) {
                name = (String)entry.getKey();
                conflictProperty = (JPAProperty)declaredIndexMappingSources.get(name);
                if (conflictProperty == null) continue;
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMappings(this.getObjectModelClass(), ((JPAProperty)entry.getValue()).getName(), Mapping.class, conflictProperty.getName(), IndexMapping.class, name));
            }
            for (Map.Entry entry : declaredIndexMappingSources.entrySet()) {
                name = (String)entry.getKey();
                conflictProperty = (JPAProperty)declaredKeyMappingSources.get(name);
                if (conflictProperty == null) continue;
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMappings(this.getObjectModelClass(), ((JPAAssociationProperty)entry.getValue()).getName(), IndexMapping.class, conflictProperty.getName(), KeyMapping.class, name));
            }
            for (Map.Entry entry : declaredKeyMappingSources.entrySet()) {
                name = (String)entry.getKey();
                conflictProperty = (JPAProperty)declaredMappingSources.get(name);
                if (conflictProperty == null) continue;
                throw new IllegalProgramException(((Resource)LAZY_RESOURCE.get()).duplicatedJAPPropertyMappings(this.getObjectModelClass(), ((JPAAssociationProperty)entry.getValue()).getName(), KeyMapping.class, conflictProperty.getName(), Mapping.class, name));
            }
            this.declaredMappingSources = MACollections.unmodifiable((Map)declaredMappingSources);
            this.declaredIndexMappingSources = MACollections.unmodifiable((Map)declaredIndexMappingSources);
            this.declaredKeyMappingSources = MACollections.unmodifiable((Map)declaredKeyMappingSources);
        }

        private void buildDefaultOwnerFrozenEqualityComparatorForReferenceMode(AbstractWrapperMetadatas.PostContext postContext) {
            if (postContext.isProcessed(DEFAULT_OWNER_FROZEN_EQUALITY_COMPARATOR_RESOLVED_METATATAS, (AbstractWrapperMetadatas.AbstractWrapperObjectModelMetadataImpl)this)) {
                return;
            }
            JPAObjectModelMetadataImpl superMetadata = (JPAObjectModelMetadataImpl)this.superMetadata();
            if (superMetadata != null) {
                superMetadata.buildDefaultOwnerFrozenEqualityComparatorForReferenceMode(postContext);
            }
            if (this.getMode() == ObjectModelMode.REFERENCE) {
                this.defaultOwnerFrozenEqualityComparator = superMetadata != null && superMetadata.getMode() == ObjectModelMode.REFERENCE ? superMetadata.defaultOwnerFrozenEqualityComparator : new DefaultOwnerEqualityComparatorForReferenceModeGenerator(this).getFrozenEqualityComparator();
            }
        }
    }
}

