/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.persistence.model;

import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.babyfish.collection.EqualityComparator;
import org.babyfish.collection.HashMap;
import org.babyfish.collection.LinkedHashSet;
import org.babyfish.collection.MACollections;
import org.babyfish.collection.XOrderedSet;
import org.babyfish.lang.Arguments;
import org.babyfish.lang.Nulls;
import org.babyfish.model.ObjectModel;
import org.babyfish.model.ObjectModelFactory;
import org.babyfish.model.metadata.Metadatas;
import org.babyfish.model.metadata.ObjectModelMetadata;
import org.babyfish.model.metadata.ObjectModelMode;
import org.babyfish.model.metadata.Property;
import org.babyfish.model.metadata.ScalarProperty;
import org.babyfish.persistence.model.metadata.JPAMetadatas;
import org.babyfish.persistence.model.metadata.JPAObjectModelMetadata;
import org.babyfish.persistence.model.metadata.JPAProperty;
import org.babyfish.persistence.model.metadata.JPAScalarProperty;
import org.babyfish.reference.Reference;
import org.babyfish.util.LazyResource;

public class JPAEntities {
    private static final LazyResource<Resource> LAZY_RESOURCE = LazyResource.of(Resource.class);
    private static final String LINE_PREFIX = System.getProperty("line.separator") + '\t';
    private static final int FG_REQURED = 1;
    private static final int FG_NOT_NULL = 2;
    private static final int FG_NOT_EMPTY = 6;
    private static final String VALIDATE_METHOD = "validateMaxEnabledRange";
    private static final String SPECIAL_ATTRIBUTE_METHODS = "required, notNull, notEmpty";

    @Deprecated
    protected JPAEntities() {
        throw new UnsupportedOperationException();
    }

    public static void disableAll(Object entity) {
        JPAEntities.validateArgument("entity", entity);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        if (objectModelMetadata.getMode() != ObjectModelMode.REFERENCE) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustBeReferenceObjectModel("entity", ObjectModelMode.REFERENCE));
        }
        ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
        for (Property property : objectModelMetadata.getProperties().values()) {
            objectModel.disable(property.getId());
        }
    }

    @SafeVarargs
    public static <E> void enable(E entity, Attribute<? super E, ?> ... attributes) {
        JPAEntities.validateArgument("entity", entity);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        if (objectModelMetadata.getMode() != ObjectModelMode.REFERENCE) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustBeReferenceObjectModel("entity", ObjectModelMode.REFERENCE));
        }
        ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
        for (Attribute<? super E, ?> attribute : attributes) {
            if (attribute instanceof SpecialAttribute) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustNotContainSpecialAttribute("attributes", VALIDATE_METHOD, Attribute.class, SPECIAL_ATTRIBUTE_METHODS));
            }
            objectModel.enable(JPAEntities.getProperty(objectModelMetadata, attribute).getId());
        }
    }

    @SafeVarargs
    public static <E> void disable(E entity, Attribute<? super E, ?> ... attributes) {
        JPAEntities.validateArgument("entity", entity);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        if (objectModelMetadata.getMode() != ObjectModelMode.REFERENCE) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustBeReferenceObjectModel("entity", ObjectModelMode.REFERENCE));
        }
        ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
        for (Attribute<? super E, ?> attribute : attributes) {
            if (attribute instanceof SpecialAttribute) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustNotContainSpecialAttribute("attributes", VALIDATE_METHOD, Attribute.class, SPECIAL_ATTRIBUTE_METHODS));
            }
            objectModel.disable(JPAEntities.getProperty(objectModelMetadata, attribute).getId());
        }
    }

    @SafeVarargs
    public static <E> Comparator<E> comparator(Class<E> entityType, Attribute<? super E, ?> ... attributes) {
        Arguments.mustNotBeNull((String)"entityType", entityType);
        Arguments.mustNotBeNull((String)"attributes", attributes);
        Arguments.mustNotBeEmpty((String)"attributes", (Object[])attributes);
        JPAObjectModelMetadata objectModelMetadata = JPAMetadatas.of(entityType);
        LinkedHashSet propertyIdSet = new LinkedHashSet();
        for (Attribute<? super E, ?> attribute : attributes) {
            Arguments.mustNotBeNull((String)"attributes[?]", attribute);
            if (attribute instanceof SpecialAttribute) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustNotContainSpecialAttribute("attributes", VALIDATE_METHOD, Attribute.class, SPECIAL_ATTRIBUTE_METHODS));
            }
            JPAProperty property = JPAEntities.getProperty(objectModelMetadata, attribute);
            if (!(property instanceof ScalarProperty)) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustBeScalarAttribute("attributes", attribute.getName(), property, ScalarProperty.class));
            }
            propertyIdSet.add(property.getId());
        }
        int[] propertyIds = MACollections.toIntArray((Collection)propertyIdSet);
        return objectModelMetadata.getOwnerComparator(propertyIds);
    }

    @SafeVarargs
    public static <E> EqualityComparator<E> equalityComparator(Class<E> entityType, Attribute<? super E, ?> ... attributes) {
        Arguments.mustNotBeNull((String)"entityType", entityType);
        JPAObjectModelMetadata objectModelMetadata = JPAMetadatas.of(entityType);
        if (Nulls.isNullOrEmpty((Object[])attributes)) {
            return objectModelMetadata.getOwnerEqualityComparator();
        }
        LinkedHashSet propertyIdSet = new LinkedHashSet();
        for (Attribute<? super E, ?> attribute : attributes) {
            Arguments.mustNotBeNull((String)"attributes[?]", attribute);
            if (attribute instanceof SpecialAttribute) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustNotContainSpecialAttribute("attributes", VALIDATE_METHOD, Attribute.class, SPECIAL_ATTRIBUTE_METHODS));
            }
            JPAProperty property = JPAEntities.getProperty(objectModelMetadata, attribute);
            if (!(property instanceof ScalarProperty)) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).mustBeScalarAttribute("attributes", attribute.getName(), property, ScalarProperty.class));
            }
            propertyIdSet.add(property.getId());
        }
        int[] propertyIds = MACollections.toIntArray((Collection)propertyIdSet);
        return objectModelMetadata.getOwnerEqualityComparator(propertyIds);
    }

    @SafeVarargs
    public static <E> void validateMaxEnabledRange(E entity, Attribute<? super E, ?> ... maxEnabledAttributeRange) {
        JPAEntities.validateArgument("entity", entity);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        JPAScalarProperty entityIdProperty = objectModelMetadata.getEntityIdProperty();
        HashMap map = new HashMap((maxEnabledAttributeRange.length * 4 + 2) / 3);
        for (Attribute<? super E, ?> attribute : maxEnabledAttributeRange) {
            SpecialAttribute sa;
            int flags = 0;
            if (attribute instanceof SpecialAttribute && (sa = (SpecialAttribute)attribute) != null) {
                flags = sa.flags;
            }
            map.put(JPAEntities.getProperty(objectModelMetadata, attribute).getId(), flags);
        }
        ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
        StringBuilder builder = null;
        for (Property property : objectModel.getObjectModelMetadata().getProperties().values()) {
            if (property == entityIdProperty) continue;
            JPAProperty jpaProperty = (JPAProperty)property;
            int propertyId = property.getId();
            Integer flags = (Integer)map.get(property.getId());
            if (flags == null) {
                if (objectModel.isDisabled(propertyId)) continue;
                builder = JPAEntities.lazyAppend(builder, objectModelMetadata, ((Resource)LAZY_RESOURCE.get()).mustBeDisabled(jpaProperty.getOwnerProperty().getName()));
                continue;
            }
            if (objectModel.isDisabled(propertyId)) {
                if ((flags & 1) == 0) continue;
                builder = JPAEntities.lazyAppend(builder, objectModelMetadata, ((Resource)LAZY_RESOURCE.get()).mustBeEnabled(jpaProperty.getOwnerProperty().getName()));
                continue;
            }
            if ((flags & 0xFFFFFFFE) == 0) continue;
            Object propertyValue = property instanceof ScalarProperty ? objectModel.getScalar(propertyId) : objectModel.getAssociation(propertyId);
            if ((flags & 2) != 0 && propertyValue == null) {
                builder = JPAEntities.lazyAppend(builder, objectModelMetadata, ((Resource)LAZY_RESOURCE.get()).mustNotBeNull(jpaProperty.getOwnerProperty().getName()));
            }
            if ((flags & 6) == 0) continue;
            boolean isEmpty = false;
            if (propertyValue instanceof String) {
                isEmpty = ((String)propertyValue).isEmpty();
            } else if (propertyValue instanceof Collection) {
                isEmpty = ((Collection)propertyValue).isEmpty();
            } else if (propertyValue instanceof Map) {
                isEmpty = ((Map)propertyValue).isEmpty();
            } else if (propertyValue != null && propertyValue.getClass().isArray()) {
                boolean bl = isEmpty = Array.getLength(propertyValue) == 0;
            }
            if (!isEmpty) continue;
            builder = JPAEntities.lazyAppend(builder, objectModelMetadata, ((Resource)LAZY_RESOURCE.get()).mustNotBeEmpty(jpaProperty.getOwnerProperty().getName()));
        }
        if (builder != null) {
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static StringBuilder lazyAppend(StringBuilder builder, ObjectModelMetadata objectModelMetadata, String message) {
        if (builder == null) {
            builder = new StringBuilder(((Resource)LAZY_RESOURCE.get()).validationErrorMessagePrefix(objectModelMetadata.getOwnerClass()));
        }
        builder.append(LINE_PREFIX).append(message);
        return builder;
    }

    public static <E> boolean isEnabled(E entity, Attribute<? super E, ?> attribute) {
        return !JPAEntities.isDisabled(entity, attribute);
    }

    public static <E> boolean isDisabled(E entity, Attribute<? super E, ?> attribute) {
        JPAEntities.validateArgument("entity", entity);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
        return objectModel.isDisabled(JPAEntities.getProperty(objectModelMetadata, attribute).getId());
    }

    public static <E> boolean isIdEquals(E entity1, E entity2) {
        JPAEntities.validateArgument("entity1", entity1);
        JPAEntities.validateArgument("entity2", entity2);
        ObjectModelFactory objectModelFactory = Metadatas.of(entity1.getClass()).getFactory();
        ObjectModelFactory objectModelFactory2 = Metadatas.of(entity2.getClass()).getFactory();
        if (objectModelFactory != objectModelFactory2) {
            return false;
        }
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        ObjectModel objectModel1 = (ObjectModel)objectModelFactory.get(entity1);
        ObjectModel objectModel2 = (ObjectModel)objectModelFactory.get(entity2);
        int entityIdPropertyId = objectModelMetadata.getEntityIdProperty().getId();
        Object id1 = objectModel1.getScalar(entityIdPropertyId);
        Object id2 = objectModel2.getScalar(entityIdPropertyId);
        return Nulls.equals((Object)id1, (Object)id2);
    }

    public static <E> E createFakeEntity(Class<E> entityType, Object id) {
        E entity;
        Arguments.mustNotBeNull((String)"entityType", entityType);
        Arguments.mustNotBeNull((String)"id", (Object)id);
        ObjectModelFactory objectModelFactory = Metadatas.of(entityType).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        JPAScalarProperty entityIdProperty = objectModelMetadata.getEntityIdProperty();
        try {
            entity = entityType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).newObjectFailed(entityType), ex);
        }
        JPAEntities.disableAll(entity);
        ((ObjectModel)objectModelFactory.get(entity)).setScalar(entityIdProperty.getId(), id);
        return entity;
    }

    public static <E> Set<E> createFakeEntities(Class<E> entityType, Iterable<?> ids) {
        Arguments.mustNotBeNull((String)"entityType", entityType);
        if (Nulls.isNullOrEmpty(ids)) {
            return MACollections.emptySet();
        }
        LinkedHashSet entities = ids instanceof Iterable ? new LinkedHashSet((((Collection)ids).size() * 4 + 2) / 3) : new LinkedHashSet();
        ObjectModelFactory objectModelFactory = Metadatas.of(entityType).getFactory();
        JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
        JPAScalarProperty entityIdProperty = objectModelMetadata.getEntityIdProperty();
        int entityIdPropertyId = entityIdProperty.getId();
        for (Object id : ids) {
            E entity;
            try {
                entity = entityType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).newObjectFailed(entityType), ex);
            }
            JPAEntities.disableAll(entity);
            ((ObjectModel)objectModelFactory.get(entity)).setScalar(entityIdPropertyId, id);
            entities.add(entity);
        }
        return entities;
    }

    public static <E> Set<E> createFakeEntities(Class<E> entityType, Object ... ids) {
        return JPAEntities.createFakeEntities(entityType, MACollections.wrap((Object[])ids));
    }

    public static <E, A> XOrderedSet<A> extractAttribute(Collection<E> entities, SingularAttribute<? super E, A> attribute) {
        LinkedHashSet values = entities.size() < 1024 ? new LinkedHashSet((entities.size() * 4 + 2) / 3) : new LinkedHashSet();
        for (E entity : entities) {
            JPAEntities.validateArgument("entity", entity);
            ObjectModelFactory objectModelFactory = Metadatas.of(entity.getClass()).getFactory();
            JPAObjectModelMetadata objectModelMetadata = (JPAObjectModelMetadata)objectModelFactory.getObjectModelMetadata();
            ObjectModel objectModel = (ObjectModel)objectModelFactory.get(entity);
            JPAProperty property = JPAEntities.getProperty(objectModelMetadata, attribute);
            if (property instanceof ScalarProperty) {
                values.add(objectModel.getScalar(property.getId()));
                continue;
            }
            Reference reference = (Reference)objectModel.getAssociation(property.getId());
            values.add(reference.get());
        }
        return values;
    }

    public static <E> Attribute<E, ?> required(Attribute<E, ?> attribute) {
        return JPAEntities.specialAttribute(attribute, 1);
    }

    public static <E> Attribute<E, ?> notNull(Attribute<E, ?> attribute) {
        return JPAEntities.specialAttribute(attribute, 2);
    }

    public static <E> Attribute<E, ?> notEmpty(Attribute<E, ?> attribute) {
        return JPAEntities.specialAttribute(attribute, 6);
    }

    private static <E> Attribute<E, ?> specialAttribute(Attribute<E, ?> attribute, int flags) {
        Arguments.mustNotBeNull((String)"attribute", attribute);
        int oldFlags = attribute instanceof SpecialAttribute ? ((SpecialAttribute)attribute).flags : 0;
        return new SpecialAttribute<E>(attribute, flags | oldFlags);
    }

    private static void validateArgument(String name, Object entity) {
        Arguments.mustNotBeNull((String)name, (Object)entity);
        Arguments.mustNotBeArray((String)name, entity.getClass());
        Arguments.mustNotBePrimitive((String)name, entity.getClass());
    }

    private static JPAProperty getProperty(JPAObjectModelMetadata objectModelMetadata, Attribute<?, ?> attribute) {
        String attributeName = attribute.getName();
        JPAProperty property = objectModelMetadata.getMappingSources().get(attributeName);
        if (property == null && (property = (JPAProperty)objectModelMetadata.getIndexMappingSources().get(attributeName)) == null && (property = (JPAProperty)objectModelMetadata.getKeyMappingSources().get(attributeName)) == null) {
            throw new IllegalArgumentException(((Resource)LAZY_RESOURCE.get()).noAttribute(objectModelMetadata.getOwnerClass(), attribute.getName()));
        }
        return property;
    }

    private static interface Resource {
        public String validationErrorMessagePrefix(Class<?> var1);

        public String mustBeDisabled(String var1);

        public String mustBeEnabled(String var1);

        public String mustNotBeNull(String var1);

        public String mustNotBeEmpty(String var1);

        public String mustBeReferenceObjectModel(String var1, ObjectModelMode var2);

        public String mustNotContainSpecialAttribute(String var1, String var2, Class<Attribute> var3, String var4);

        public String mustBeScalarAttribute(String var1, String var2, Property var3, Class<ScalarProperty> var4);

        public String newObjectFailed(Class<?> var1);

        public String noAttribute(Class<?> var1, String var2);
    }

    private static class SpecialAttribute<E>
    implements Attribute<E, Object> {
        Attribute<E, ?> raw;
        int flags;

        public SpecialAttribute(Attribute<E, ?> raw, int flags) {
            if (raw instanceof SpecialAttribute) {
                SpecialAttribute sa = (SpecialAttribute)raw;
                this.raw = sa.raw;
                this.flags = sa.flags | flags;
            } else {
                this.raw = raw;
                this.flags = flags;
            }
        }

        public ManagedType<E> getDeclaringType() {
            return this.raw.getDeclaringType();
        }

        public Member getJavaMember() {
            return this.raw.getJavaMember();
        }

        public Class<Object> getJavaType() {
            return this.raw.getJavaType();
        }

        public String getName() {
            return this.raw.getName();
        }

        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return this.raw.getPersistentAttributeType();
        }

        public boolean isAssociation() {
            return this.raw.isAssociation();
        }

        public boolean isCollection() {
            return this.raw.isCollection();
        }
    }
}

