/*
 * BabyFish, Object Model Framework for Java and JPA.
 * https://github.com/babyfish-ct/babyfish
 *
 * Copyright (c) 2008-2015, Tao Chen
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * Please visit "http://opensource.org/licenses/LGPL-3.0" to know more.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 */
package org.babyfish.persistence.instrument;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Tao Chen
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface JPAObjectModelInstrument {
    
    /**
     * @return The order of properities
     * 
     * Two ways to use it
     * 
     * <ul>
     *  <li>&#64;JPAObjectModelInstrument(declaredPropertiesOrder = "a, b, c")</li>
     *  <li>&#64;JPAObjectModelInstrument(declaredPropertiesOrder = { "a", "b", "c" })</li>
     * </ul>
     * 
     * Generically, it's unnecessary to specify this argument,
     * BabyFish can read the order of members by from byte-code.
     */
    String[] declaredPropertiesOrder() default {};
    
    boolean allowEagerReferences() default false;
    
    boolean allowEagerLobs() default false;
}
