/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WormFile {
    private static Map<Path, WormFile> mapWormFile = new HashMap<Path, WormFile>();
    private Path pathFile;
    private ReadWriteLock readWriteLock;
    private FileLock fileLock;
    private int readCount;
    private boolean indWrite;

    private WormFile(Path pathFile) {
        this.pathFile = pathFile;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public static synchronized WormFile get(Path pathFile) {
        Path pathFileCanonicalized = pathFile.toAbsolutePath().normalize();
        WormFile wormFile = mapWormFile.get(pathFileCanonicalized);
        if (wormFile == null) {
            wormFile = new WormFile(pathFileCanonicalized);
            mapWormFile.put(pathFileCanonicalized, wormFile);
        }
        return wormFile;
    }

    public static WormFileCache getCache(Path pathFile) {
        return new WormFileCache(WormFile.get(pathFile));
    }

    public InputStream getInputStream() {
        if (!this.indWrite && this.readCount == 0) {
            throw new RuntimeException("Access to WormFile " + this.pathFile + " must be reserved.");
        }
        try {
            if (this.indWrite) {
                FileChannel fileChannel = this.fileLock.channel();
                fileChannel.position(0L);
                return Channels.newInputStream(fileChannel);
            }
            return new FileInputStream(this.pathFile.toFile());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public OutputStream getOutputStream() {
        if (!this.indWrite) {
            throw new RuntimeException("Access to WormFile " + this.pathFile + " must be reserved for writing.");
        }
        try {
            FileChannel fileChannel = this.fileLock.channel();
            fileChannel.position(0L);
            return Channels.newOutputStream(fileChannel);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessHandle reserveAccess(boolean indWriteRequest) {
        if (indWriteRequest) {
            this.readWriteLock.writeLock().lock();
            if (this.indWrite || this.readCount != 0 || this.fileLock != null) {
                throw new RuntimeException("Access to WormFile for " + this.pathFile + " should not be reserved.");
            }
            this.indWrite = true;
            try {
                if (!this.pathFile.toFile().exists()) {
                    this.pathFile.getParent().toFile().mkdirs();
                }
                this.fileLock = FileChannel.open(this.pathFile, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE).lock();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return new AccessHandle();
        }
        this.readWriteLock.readLock().lock();
        if (this.indWrite) {
            throw new RuntimeException("Access to WormFile for " + this.pathFile + " should not be reserved for writing.");
        }
        WormFile wormFile = this;
        synchronized (wormFile) {
            if (this.readCount++ == 0) {
                if (this.fileLock != null) {
                    throw new RuntimeException("Access to WormFile for " + this.pathFile + " should not be reserved.");
                }
                try {
                    this.fileLock = FileChannel.open(this.pathFile, StandardOpenOption.READ).lock(0L, Long.MAX_VALUE, true);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            } else if (this.fileLock == null || !this.fileLock.isValid() || !this.fileLock.isShared()) {
                throw new RuntimeException("Access to WormFile for " + this.pathFile + " should already be reserved for reading.");
            }
        }
        return new AccessHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAccess() {
        if (this.fileLock == null || !this.fileLock.isValid()) {
            throw new RuntimeException("Access to WormFile for " + this.pathFile + " not reserved for writing.");
        }
        if (this.indWrite) {
            if (this.fileLock.isShared()) {
                throw new RuntimeException("Access to WormFile for " + this.pathFile + " not reserved for writing.");
            }
            try {
                this.fileLock.release();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.fileLock = null;
            this.readWriteLock.writeLock().unlock();
            this.indWrite = false;
        } else {
            if (this.readCount == 0 || !this.fileLock.isShared()) {
                throw new RuntimeException("Access to WormFile for " + this.pathFile + " not reserved for reading.");
            }
            WormFile wormFile = this;
            synchronized (wormFile) {
                if (--this.readCount == 0) {
                    try {
                        this.fileLock.release();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    this.fileLock = null;
                }
            }
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean isExists() {
        return this.pathFile.toFile().exists();
    }

    public class AccessHandle {
        private boolean indActive = true;
        WormFileCache wormFileCache;

        AccessHandle() {
        }

        private void setWormFileCache(WormFileCache wormFileCache) {
            this.wormFileCache = wormFileCache;
        }

        public void release() {
            if (!this.indActive) {
                throw new RuntimeException("Handle not active.");
            }
            WormFile.this.releaseAccess();
            this.indActive = false;
            this.wormFileCache.updateLastModifiedTimestamp();
        }
    }

    public static class WormFileCache {
        WormFile wormFile;
        private long lastModifiedTimestamp;

        private WormFileCache(WormFile wormFile) {
            this.wormFile = wormFile;
        }

        public InputStream getInputStream() {
            return this.wormFile.getInputStream();
        }

        public OutputStream getOutputStream() {
            return this.wormFile.getOutputStream();
        }

        public AccessHandle reserveAccess(boolean indWriteRequest) {
            AccessHandle accessHandle = this.wormFile.reserveAccess(indWriteRequest);
            accessHandle.setWormFileCache(this);
            return accessHandle;
        }

        public boolean isExists() {
            return this.wormFile.isExists();
        }

        public boolean isModified() {
            return this.lastModifiedTimestamp == 0L || this.lastModifiedTimestamp != this.wormFile.pathFile.toFile().lastModified();
        }

        private void updateLastModifiedTimestamp() {
            this.lastModifiedTimestamp = this.wormFile.pathFile.toFile().lastModified();
        }
    }
}

