/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.model.plugin.NodePluginFactory;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.AlwaysNeverYesNoAskUserResponse;
import org.azyva.dragom.util.YesAlwaysNoUserResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    public static final String RUNTIME_PROPERTY_IND_NO_CONFIRM = "IND_NO_CONFIRM";
    public static final String RUNTIME_PROPERTY_IND_ABORT = "IND_ABORT";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_UPDATE_REFERENCE = "UPDATE_REFERENCE";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_CREATE_STATIC_VERSION = "CREATE_STATIC_VERSION";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_CREATE_DYNAMIC_VERSION = "CREATE_DYNAMIC_VERSION";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_MERGE = "MERGE";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_REFERENCE_CHANGE_AFTER_SWITCHING = "REFERENCE_CHANGE_AFTER_SWITCHING";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_COMMIT = "COMMIT";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_UNSYNC_REMOTE_CHANGES_WHILE_COMMIT = "UNSYNC_REMOTE_CHANGES_WHILE_COMMIT";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES = "DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_DELETE_WORKSPACE_DIRECTORY = "DELETE_WORKSPACE_DIRECTORY";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_MAY_LOOSE_COMMITS = "MAY_LOOSE_COMMITS";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_SWITCH_WITH_UNSYNC_LOCAL_CHANGES = "SWITCH_WITH_UNSYNC_LOCAL_CHANGES";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_NON_STATIC_VERSIONS_REFERENCE_PATH = "NON_STATIC_VERSIONS_REFERENCE_PATH";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_USE_CURRENT_HOTFIX_VERSION = "USE_CURRENT_HOTFIX_VERSION";
    public static final String DO_YOU_WANT_TO_CONTINUE_CONTEXT_COMMIT_REFERENCE_CHANGE_AFTER_ABORT = "COMMIT_REFERENCE_CHANGE_AFTER_ABORT";
    private static final String DRAGOM_PROPERTIES_RESOURCE = "/META-INF/dragom.properties";
    private static final String DRAGOM_DEFAULT_INIT_PROPERTIES_RESOURCE = "/META-INF/dragom-init.properties";
    public static final String MSG_PATTERN_KEY_ALWAYS_NEVER_ASK_RESPONSE_CHOICES = "ALWAYS_NEVER_ASK_RESPONSE_CHOICES";
    public static final String MSG_PATTERN_KEY_YES_RESPONSE = "YES_RESPONSE";
    public static final String MSG_PATTERN_KEY_YES_ALWAYS_RESPONSE = "YES_ALWAYS_RESPONSE";
    public static final String MSG_PATTERN_KEY_NEVER_RESPONSE = "NEVER_RESPONSE";
    public static final String MSG_PATTERN_KEY_ALWAYS_NEVER_YES_NO_ASK_RESPONSE_CHOICES = "ALWAYS_NEVER_YES_NO_ASK_RESPONSE_CHOICES";
    public static final String MSG_PATTERN_KEY_NO_RESPONSE = "NO_RESPONSE";
    public static final String MSG_PATTERN_KEY_YES_ALWAYS_NO_RESPONSE_CHOICES = "YES_ALWAYS_NO_RESPONSE_CHOICES";
    public static final String MSG_PATTERN_KEY_YES_ALWAYS_NO_ABORT_RESPONSE_CHOICES = "YES_ALWAYS_NO_ABORT_RESPONSE_CHOICES";
    public static final String MSG_PATTERN_KEY_NO_ABORT_RESPONSE = "NO_ABORT_RESPONSE";
    public static final String MSG_PATTERN_KEY_YES_NO_RESPONSE_CHOICES = "YES_NO_RESPONSE_CHOICES";
    public static final String MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN = "INVALID_RESPONSE_TRY_AGAIN";
    public static final String MSG_PATTERN_KEY_VERSION_FORMAT_HELP = "VERSION_FORMAT_HELP";
    public static final String MSG_PATTERN_KEY_VERSION_FORMAT_HELP_VERSION_MUST_EXIST = "VERSION_FORMAT_HELP_VERSION_MUST_EXIST";
    public static final String MSG_PATTERN_KEY_INCORRECT_VERSION_TYPE = "INCORRECT_VERSION_TYPE";
    public static final String MSG_PATTERN_KEY_VERSION_DOES_NOT_EXIST = "VERSION_DOES_NOT_EXIST";
    public static final String MSG_PATTERN_KEY_TRY_AGAIN = "TRY_AGAIN";
    public static final String MSG_PATTERN_DO_YOU_WANT_TO_CONTINUE = "DO_YOU_WANT_TO_CONTINUE";
    public static final String MSG_PATTERN_KEY_STARTING_JOB = "STARTING_JOB";
    public static final String MSG_PATTERN_KEY_JOB_COMPLETED = "JOB_COMPLETED";
    public static final String MSG_PATTERN_KEY_JOB_ABORTED_BY_USER = "JOB_ABORTED_BY_USER";
    public static final String MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_NOT_SYNC = "WORKSPACE_DIRECTORY_NOT_SYNC";
    public static final String MSG_PATTERN_KEY_PREVIOUS_CHANGE_COMMITTED_SCM = "PREVIOUS_CHANGE_COMMITTED_SCM";
    public static final String MSG_PATTERN_KEY_PREVIOUS_CHANGE_SCM = "PREVIOUS_CHANGE_SCM";
    public static final String MSG_PATTERN_KEY_EXCEPTION_THROWN_WHILE_VISITING = "EXCEPTION_THROWN_WHILE_VISITING";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(Util.class.getName() + "ResourceBundle");
    private static boolean indDragomPropertiesLoaded;
    private static Properties propertiesDefaultInit;
    private static Boolean indWindows;
    private static Boolean indPosix;
    private static final StringBuilder stringBuilderSpaces;
    private static final ReentrantReadWriteLock readWriteLockStringBuilderSpaces;

    public static String inferGroupIdSegmentFromNodePath(NodePath nodePath) {
        StringBuilder stringBuilder = new StringBuilder();
        int nodeCount = nodePath.getNodeCount();
        if (!nodePath.isPartial()) {
            --nodeCount;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (i != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(Util.convertPascalCaseToLowercaseWithDashes(nodePath.getNodeName(i)));
        }
        return stringBuilder.toString();
    }

    public static String convertPascalCaseToLowercaseWithDashes(String stringPascalCase) {
        StringBuilder stringBuilder = new StringBuilder();
        int charCount = stringPascalCase.length();
        for (int i = 0; i < charCount; ++i) {
            char character = stringPascalCase.charAt(i);
            if (Character.isUpperCase(character)) {
                if (i != 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(Character.toLowerCase(character));
                continue;
            }
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }

    public static boolean isDirectoryEmpty(Path path) {
        DirectoryStream<Path> directoryStream;
        try {
            directoryStream = Files.newDirectoryStream(path);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return !directoryStream.iterator().hasNext();
    }

    public static void applyDragomSystemProperties() {
        if (!indDragomPropertiesLoaded) {
            try (InputStream inputStream = Util.class.getResourceAsStream(DRAGOM_PROPERTIES_RESOURCE);){
                if (inputStream != null) {
                    logger.debug("Loading properties from classpath resource /META-INF/dragom.properties into system properties.");
                    Properties propertiesDragom = new Properties();
                    propertiesDragom.load(inputStream);
                    for (Map.Entry<Object, Object> mapEntry : propertiesDragom.entrySet()) {
                        String key = (String)mapEntry.getKey();
                        if (System.getProperty(key) != null) continue;
                        System.setProperty(key, (String)mapEntry.getValue());
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static Properties getPropertiesDefaultInit() {
        if (propertiesDefaultInit == null) {
            try (InputStream inputStream = Util.class.getResourceAsStream(DRAGOM_DEFAULT_INIT_PROPERTIES_RESOURCE);){
                if (inputStream != null) {
                    logger.debug("Loading initialization properties from classpath resource /META-INF/dragom-init.properties.");
                    propertiesDefaultInit = new Properties();
                    propertiesDefaultInit.load(inputStream);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return propertiesDefaultInit;
    }

    public static Map<String, String> getJsonAttr(String message, Map<String, String> mapAttr) {
        JsonNode jsonNode;
        if (message.length() == 0 || message.charAt(0) != '{') {
            return Collections.emptyMap();
        }
        int indexClosingBrace = message.indexOf(125);
        try {
            jsonNode = new ObjectMapper().readTree(message.substring(0, indexClosingBrace + 1));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (mapAttr == null) {
            mapAttr = new HashMap<String, String>();
        }
        Iterator iteratorFieldName = jsonNode.fieldNames();
        while (iteratorFieldName.hasNext()) {
            String fieldName = (String)iteratorFieldName.next();
            JsonNode jsonNodeFieldValue = jsonNode.get(fieldName);
            if (jsonNodeFieldValue == null || !jsonNodeFieldValue.isTextual()) continue;
            mapAttr.put(fieldName, jsonNodeFieldValue.asText());
        }
        return mapAttr;
    }

    public static String getCommitMessageWithoutAttr(String commitMessage) {
        if (commitMessage.length() == 0 || commitMessage.charAt(0) != '{') {
            return commitMessage;
        }
        int indexClosingBrace = commitMessage.indexOf(125);
        return commitMessage.substring(indexClosingBrace + 1);
    }

    public static boolean isNotNullAndTrue(Boolean aBoolean) {
        return aBoolean != null && aBoolean != false;
    }

    public static boolean isNotNullAndTrue(String stringBoolean) {
        return stringBoolean != null && Boolean.valueOf(stringBoolean) != false;
    }

    public static String getLocalizedMsgPattern(String msgPatternKey) {
        return resourceBundle.getString(msgPatternKey);
    }

    public static AlwaysNeverAskUserResponse getInfoAlwaysNeverAskUserResponse(UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, AlwaysNeverAskUserResponse alwaysNeverAskUserResponseDefaultValue) {
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponse;
        String alwaysNeverAskResponseChoices = resourceBundle.getString(MSG_PATTERN_KEY_ALWAYS_NEVER_ASK_RESPONSE_CHOICES);
        String alwaysResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_RESPONSE);
        String neverResponse = resourceBundle.getString(MSG_PATTERN_KEY_NEVER_RESPONSE);
        String askResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_RESPONSE);
        if (prompt.endsWith("*")) {
            String defaultValue = null;
            switch (alwaysNeverAskUserResponseDefaultValue) {
                case ALWAYS: {
                    defaultValue = alwaysResponse;
                    break;
                }
                case NEVER: {
                    defaultValue = neverResponse;
                    break;
                }
                case YES_ASK: {
                    defaultValue = askResponse;
                }
            }
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + alwaysNeverAskResponseChoices + ") [" + defaultValue + "]? ";
        }
        while (true) {
            block11: {
                String userResponse = userInteractionCallbackPlugin.getInfoWithDefault(prompt, alwaysNeverAskUserResponseDefaultValue.toString());
                userResponse = userResponse.toUpperCase().trim();
                alwaysNeverAskUserResponse = null;
                try {
                    alwaysNeverAskUserResponse = AlwaysNeverAskUserResponse.valueOf(userResponse);
                }
                catch (IllegalArgumentException iae) {
                    if (userResponse.equals(alwaysResponse) || userResponse.equals("1")) {
                        alwaysNeverAskUserResponse = AlwaysNeverAskUserResponse.ALWAYS;
                    }
                    if (userResponse.equals(neverResponse) || userResponse.equals("0")) {
                        alwaysNeverAskUserResponse = AlwaysNeverAskUserResponse.NEVER;
                    }
                    if (!userResponse.equals(askResponse)) break block11;
                    alwaysNeverAskUserResponse = AlwaysNeverAskUserResponse.YES_ASK;
                }
            }
            if (alwaysNeverAskUserResponse != null) break;
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN));
        }
        return alwaysNeverAskUserResponse;
    }

    public static AlwaysNeverAskUserResponse getInfoAlwaysNeverAskUserResponseAndHandleAsk(RuntimePropertiesPlugin runtimePropertiesPlugin, String runtimeProperty, UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt) {
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponse = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty(null, runtimeProperty));
        if (alwaysNeverAskUserResponse.isAsk() && !(alwaysNeverAskUserResponse = Util.getInfoAlwaysNeverAskUserResponse(userInteractionCallbackPlugin, prompt, AlwaysNeverAskUserResponse.YES_ASK)).isAsk()) {
            runtimePropertiesPlugin.setProperty(null, runtimeProperty, alwaysNeverAskUserResponse.toString());
        }
        return alwaysNeverAskUserResponse;
    }

    public static AlwaysNeverYesNoAskUserResponse getInfoAlwaysNeverYesNoAskUserResponse(UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponseDefaultValue) {
        AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponse;
        String alwaysNeverYesNoAskResponseChoices = resourceBundle.getString(MSG_PATTERN_KEY_ALWAYS_NEVER_YES_NO_ASK_RESPONSE_CHOICES);
        String alwaysResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_RESPONSE);
        String neverResponse = resourceBundle.getString(MSG_PATTERN_KEY_NEVER_RESPONSE);
        String yesAskResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_RESPONSE);
        String noAskResponse = resourceBundle.getString(MSG_PATTERN_KEY_NO_RESPONSE);
        if (prompt.endsWith("*")) {
            String defaultValue = null;
            switch (alwaysNeverYesNoAskUserResponseDefaultValue) {
                case ALWAYS: {
                    defaultValue = alwaysResponse;
                    break;
                }
                case NEVER: {
                    defaultValue = neverResponse;
                    break;
                }
                case YES_ASK: {
                    defaultValue = yesAskResponse;
                    break;
                }
                case NO_ASK: {
                    defaultValue = noAskResponse;
                }
            }
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + alwaysNeverYesNoAskResponseChoices + ") [" + defaultValue + "]? ";
        }
        while (true) {
            block13: {
                String userResponse = userInteractionCallbackPlugin.getInfoWithDefault(prompt, alwaysNeverYesNoAskUserResponseDefaultValue.toString());
                userResponse = userResponse.toUpperCase().trim();
                alwaysNeverYesNoAskUserResponse = null;
                try {
                    alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.valueOf(userResponse);
                }
                catch (IllegalArgumentException iae) {
                    if (userResponse.equals(alwaysResponse) || userResponse.equals("1")) {
                        alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.ALWAYS;
                    }
                    if (userResponse.equals(neverResponse) || userResponse.equals("0")) {
                        alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.NEVER;
                    }
                    if (userResponse.equals(yesAskResponse)) {
                        alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.YES_ASK;
                    }
                    if (!userResponse.equals(noAskResponse)) break block13;
                    alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.NO_ASK;
                }
            }
            if (alwaysNeverYesNoAskUserResponse != null) break;
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN));
        }
        return alwaysNeverYesNoAskUserResponse;
    }

    public static AlwaysNeverYesNoAskUserResponse getInfoAlwaysNeverYesNoAskUserResponseAndHandleAsk(RuntimePropertiesPlugin runtimePropertiesPlugin, String runtimeProperty, UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt) {
        AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponse = AlwaysNeverYesNoAskUserResponse.valueOfWithYesAskDefault(runtimePropertiesPlugin.getProperty(null, runtimeProperty));
        if (alwaysNeverYesNoAskUserResponse.isAsk()) {
            AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponseOrg = alwaysNeverYesNoAskUserResponse;
            if ((alwaysNeverYesNoAskUserResponse = Util.getInfoAlwaysNeverYesNoAskUserResponse(userInteractionCallbackPlugin, prompt, alwaysNeverYesNoAskUserResponse)) != alwaysNeverYesNoAskUserResponseOrg) {
                runtimePropertiesPlugin.setProperty(null, runtimeProperty, alwaysNeverYesNoAskUserResponse.toString());
            }
        }
        return alwaysNeverYesNoAskUserResponse;
    }

    public static YesAlwaysNoUserResponse getInfoYesAlwaysNoUserResponse(UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, YesAlwaysNoUserResponse yesAlwaysNoUserResponseDefaultValue) {
        YesAlwaysNoUserResponse yesAlwaysNoUserResponse;
        String yesAlwaysNoResponseChoices = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_NO_RESPONSE_CHOICES);
        String yesResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_RESPONSE);
        String yesAlwaysResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_RESPONSE);
        String noResponse = resourceBundle.getString(MSG_PATTERN_KEY_NO_RESPONSE);
        if (prompt.endsWith("*")) {
            String defaultValue = null;
            switch (yesAlwaysNoUserResponseDefaultValue) {
                case YES: {
                    defaultValue = yesResponse;
                    break;
                }
                case YES_ALWAYS: {
                    defaultValue = yesAlwaysResponse;
                    break;
                }
                case NO: {
                    defaultValue = noResponse;
                    break;
                }
                case NO_ABORT: {
                    throw new RuntimeException("NO_ABORT is not supported by this method.");
                }
            }
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + yesAlwaysNoResponseChoices + ") [" + defaultValue + "]? ";
        }
        while (true) {
            block12: {
                String userResponse = userInteractionCallbackPlugin.getInfoWithDefault(prompt, yesAlwaysNoUserResponseDefaultValue.toString());
                userResponse = userResponse.toUpperCase().trim();
                yesAlwaysNoUserResponse = null;
                try {
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.valueOf(userResponse);
                }
                catch (IllegalArgumentException iae) {
                    if (userResponse.equals(yesResponse)) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.YES;
                    }
                    if (userResponse.equals(yesAlwaysResponse) || userResponse.equals("1")) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.YES_ALWAYS;
                    }
                    if (!userResponse.equals(noResponse) && !userResponse.equals("0")) break block12;
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.NO;
                }
            }
            if (yesAlwaysNoUserResponse != null) break;
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN));
        }
        return yesAlwaysNoUserResponse;
    }

    public static YesAlwaysNoUserResponse getInfoYesAlwaysNoAbortUserResponse(UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, YesAlwaysNoUserResponse yesAlwaysNoUserResponseDefaultValue) {
        YesAlwaysNoUserResponse yesAlwaysNoUserResponse;
        String yesAlwaysNoAbortResponseChoices = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_NO_ABORT_RESPONSE_CHOICES);
        String yesResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_RESPONSE);
        String yesAlwaysResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_ALWAYS_RESPONSE);
        String noResponse = resourceBundle.getString(MSG_PATTERN_KEY_NO_RESPONSE);
        String noAbortResponse = resourceBundle.getString(MSG_PATTERN_KEY_NO_ABORT_RESPONSE);
        if (prompt.endsWith("*")) {
            String defaultValue = null;
            switch (yesAlwaysNoUserResponseDefaultValue) {
                case YES: {
                    defaultValue = yesResponse;
                    break;
                }
                case YES_ALWAYS: {
                    defaultValue = yesAlwaysResponse;
                    break;
                }
                case NO: {
                    defaultValue = noResponse;
                    break;
                }
                case NO_ABORT: {
                    defaultValue = noAbortResponse;
                }
            }
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + yesAlwaysNoAbortResponseChoices + ") [" + defaultValue + "]? ";
        }
        while (true) {
            block13: {
                String userResponse = userInteractionCallbackPlugin.getInfoWithDefault(prompt, yesAlwaysNoUserResponseDefaultValue.toString());
                userResponse = userResponse.toUpperCase().trim();
                yesAlwaysNoUserResponse = null;
                try {
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.valueOf(userResponse);
                }
                catch (IllegalArgumentException iae) {
                    if (userResponse.equals(yesResponse)) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.YES;
                    }
                    if (userResponse.equals(yesAlwaysResponse) || userResponse.equals("1")) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.YES_ALWAYS;
                    }
                    if (userResponse.equals(noResponse)) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.NO;
                    }
                    if (!userResponse.equals(noAbortResponse) && !userResponse.equals("0")) break block13;
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.NO_ABORT;
                }
            }
            if (yesAlwaysNoUserResponse != null) break;
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN));
        }
        return yesAlwaysNoUserResponse;
    }

    public static YesAlwaysNoUserResponse getInfoYesNoUserResponse(UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, YesAlwaysNoUserResponse yesAlwaysNoUserResponseDefaultValue) {
        YesAlwaysNoUserResponse yesAlwaysNoUserResponse;
        String yesNoResponseChoices = resourceBundle.getString(MSG_PATTERN_KEY_YES_NO_RESPONSE_CHOICES);
        String yesResponse = resourceBundle.getString(MSG_PATTERN_KEY_YES_RESPONSE);
        String noResponse = resourceBundle.getString(MSG_PATTERN_KEY_NO_RESPONSE);
        if (prompt.endsWith("*")) {
            String defaultValue = null;
            switch (yesAlwaysNoUserResponseDefaultValue) {
                case YES: {
                    defaultValue = yesResponse;
                    break;
                }
                case YES_ALWAYS: {
                    throw new RuntimeException("YES_ALWAYS is not supported by this method.");
                }
                case NO: {
                    defaultValue = noResponse;
                    break;
                }
                case NO_ABORT: {
                    throw new RuntimeException("NO_ABORT is not supported by this method.");
                }
            }
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + yesNoResponseChoices + ") [" + defaultValue + "]? ";
        }
        while (true) {
            block12: {
                String userResponse = userInteractionCallbackPlugin.getInfoWithDefault(prompt, yesAlwaysNoUserResponseDefaultValue.toString());
                userResponse = userResponse.toUpperCase().trim();
                yesAlwaysNoUserResponse = null;
                try {
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.valueOf(userResponse);
                    if (yesAlwaysNoUserResponse == YesAlwaysNoUserResponse.YES_ALWAYS) {
                        yesAlwaysNoUserResponse = null;
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (userResponse.equals(yesResponse) || userResponse.equals("1")) {
                        yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.YES;
                    }
                    if (!userResponse.equals(noResponse) && !userResponse.equals("0")) break block12;
                    yesAlwaysNoUserResponse = YesAlwaysNoUserResponse.NO;
                }
            }
            if (yesAlwaysNoUserResponse != null) break;
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_INVALID_RESPONSE_TRY_AGAIN));
        }
        return yesAlwaysNoUserResponse;
    }

    public static Version getInfoVersion(VersionType versionType, ScmPlugin scmPlugin, UserInteractionCallbackPlugin userInteractionCallbackPlugin, String prompt, Version versionDefaultValue) {
        Version version = null;
        String msgPatternVersionFormatHelp = scmPlugin != null ? resourceBundle.getString(MSG_PATTERN_KEY_VERSION_FORMAT_HELP_VERSION_MUST_EXIST) : resourceBundle.getString(MSG_PATTERN_KEY_VERSION_FORMAT_HELP);
        if (prompt.endsWith("*")) {
            String stringVersionType;
            if (versionType == null) {
                stringVersionType = "S|D";
            } else if (versionType == VersionType.STATIC) {
                stringVersionType = "S";
            } else if (versionType == VersionType.DYNAMIC) {
                stringVersionType = "D";
            } else {
                throw new RuntimeException("Must not get here.");
            }
            String defaultValue = versionDefaultValue != null ? " [" + versionDefaultValue.toString() + "]" : "";
            prompt = prompt.substring(0, prompt.length() - 1) + " (" + MessageFormat.format(msgPatternVersionFormatHelp, stringVersionType) + ")" + defaultValue + "? ";
        }
        while (true) {
            String userResponse = versionDefaultValue != null ? userInteractionCallbackPlugin.getInfoWithDefault(prompt, versionDefaultValue.toString()) : userInteractionCallbackPlugin.getInfo(prompt);
            try {
                version = Version.parse((String)userResponse);
            }
            catch (ParseException pe) {
                userInteractionCallbackPlugin.provideInfo(pe.getMessage());
                userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_TRY_AGAIN));
                continue;
            }
            if (versionType != null && version.getVersionType() != versionType) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INCORRECT_VERSION_TYPE), version, versionType));
                userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_TRY_AGAIN));
                continue;
            }
            if (scmPlugin == null || scmPlugin.isVersionExists(version)) break;
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSION_DOES_NOT_EXIST), version));
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_TRY_AGAIN));
        }
        return version;
    }

    public static NodePluginFactory getNodePluginFactory(String stringClassNodePlugin) {
        try {
            Class<?> classNodePlugin = Class.forName(stringClassNodePlugin);
            Method methodGetInstance = classNodePlugin.getMethod("getInstance", null);
            if (methodGetInstance != null) {
                return (NodePluginFactory)NodePluginFactory.class.cast(methodGetInstance.invoke(null, new Object[0]));
            }
            Class<NodePluginFactory> classNodePluginFactory = classNodePlugin.asSubclass(NodePluginFactory.class);
            return classNodePluginFactory.newInstance();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends NodePlugin> getDefaultClassNodePlugin(String pluginClass) {
        try {
            Class<?> classPlugin = Class.forName(pluginClass);
            if (NodePluginFactory.class.isAssignableFrom(classPlugin)) {
                NodePluginFactory pluginFactory = Util.getNodePluginFactory(pluginClass);
                return pluginFactory.getDefaultClassNodePlugin();
            }
            if (NodePlugin.class.isAssignableFrom(classPlugin)) {
                Class<?>[] arrayClassInterface;
                Method methodGetDefaultClassNodePlugin;
                try {
                    methodGetDefaultClassNodePlugin = classPlugin.getMethod("getDefaultClassNodePlugin", null);
                }
                catch (NoSuchMethodException nsme) {
                    methodGetDefaultClassNodePlugin = null;
                }
                if (methodGetDefaultClassNodePlugin != null) {
                    return ((Class)Class.class.cast(methodGetDefaultClassNodePlugin.invoke(null, new Object[0]))).asSubclass(NodePlugin.class);
                }
                for (Class<?> classInterface : arrayClassInterface = classPlugin.getInterfaces()) {
                    if (!NodePlugin.class.isAssignableFrom(classInterface)) continue;
                    return classInterface.asSubclass(NodePlugin.class);
                }
                throw new RuntimeException("The plugin class " + pluginClass + " does not implement a sub-interface of NodePlugin.");
            }
            throw new RuntimeException("The plugin class " + pluginClass + " does not implement NodePluginFactory and cannot be instantiated as a NodePlugin.");
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultPluginId(Class<? extends NodePlugin> classNodePlugin, String pluginClass) {
        try {
            Class<?> classPlugin = Class.forName(pluginClass);
            if (NodePluginFactory.class.isAssignableFrom(classPlugin)) {
                NodePluginFactory pluginFactory = Util.getNodePluginFactory(pluginClass);
                return pluginFactory.getDefaultPluginId(classNodePlugin);
            }
            if (NodePlugin.class.isAssignableFrom(classPlugin)) {
                Method methodGetDefaultClassNodePlugin;
                try {
                    methodGetDefaultClassNodePlugin = classPlugin.getMethod("getDefaultPluginId", Class.class);
                }
                catch (NoSuchMethodException nsme) {
                    methodGetDefaultClassNodePlugin = null;
                }
                if (methodGetDefaultClassNodePlugin != null) {
                    return (String)methodGetDefaultClassNodePlugin.invoke(null, classNodePlugin);
                }
                return null;
            }
            throw new RuntimeException("The plugin class " + pluginClass + " does not implement NodePluginFactory and cannot be instantiated as a NodePlugin.");
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isWindows() {
        if (indWindows == null) {
            indWindows = System.getProperty("os.name").startsWith("Windows");
        }
        return indWindows;
    }

    public static boolean handleDoYouWantToContinue(String context) {
        if (context == null) {
            throw new RuntimeException("context must not be null.");
        }
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (Boolean.valueOf(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_NO_CONFIRM)).booleanValue()) {
            return true;
        }
        if (Boolean.valueOf(runtimePropertiesPlugin.getProperty(null, "IND_NO_CONFIRM." + context)).booleanValue()) {
            return true;
        }
        switch (Util.getInfoYesAlwaysNoUserResponse(userInteractionCallbackPlugin, resourceBundle.getString(MSG_PATTERN_DO_YOU_WANT_TO_CONTINUE), YesAlwaysNoUserResponse.YES)) {
            case NO: {
                Util.setAbort();
                return false;
            }
            case YES_ALWAYS: {
                runtimePropertiesPlugin.setProperty(null, "IND_NO_CONFIRM." + context, "true");
            }
            case YES: {
                return true;
            }
        }
        throw new RuntimeException("Must not get here.");
    }

    public static boolean handleDoYouWantToContinueWithIndividualNo(String context) {
        if (context == null) {
            throw new RuntimeException("context must not be null.");
        }
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (Boolean.valueOf(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_NO_CONFIRM)).booleanValue()) {
            return true;
        }
        if (Boolean.valueOf(runtimePropertiesPlugin.getProperty(null, "IND_NO_CONFIRM." + context)).booleanValue()) {
            return true;
        }
        switch (Util.getInfoYesAlwaysNoAbortUserResponse(userInteractionCallbackPlugin, resourceBundle.getString(MSG_PATTERN_DO_YOU_WANT_TO_CONTINUE), YesAlwaysNoUserResponse.YES)) {
            case NO_ABORT: {
                Util.setAbort();
            }
            case NO: {
                return false;
            }
            case YES_ALWAYS: {
                runtimePropertiesPlugin.setProperty(null, "IND_NO_CONFIRM." + context, "true");
            }
            case YES: {
                return true;
            }
        }
        throw new RuntimeException("Must not get here.");
    }

    public static boolean isAbort() {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        return Boolean.valueOf(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_ABORT));
    }

    public static void setAbort() {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_IND_ABORT, "true");
    }

    public static boolean isDigits(String string) {
        for (char character : string.toCharArray()) {
            if (character >= '0' && character <= '9') continue;
            return false;
        }
        return true;
    }

    public static String spaces(int length) {
        readWriteLockStringBuilderSpaces.readLock().lock();
        int currentLength = stringBuilderSpaces.length();
        if (length > currentLength) {
            readWriteLockStringBuilderSpaces.readLock().unlock();
            readWriteLockStringBuilderSpaces.writeLock().lock();
            currentLength = stringBuilderSpaces.length();
            if (length > currentLength) {
                stringBuilderSpaces.setLength(length);
                for (int i = currentLength; i < length; ++i) {
                    stringBuilderSpaces.setCharAt(i, ' ');
                }
            }
            readWriteLockStringBuilderSpaces.readLock().lock();
            readWriteLockStringBuilderSpaces.writeLock().unlock();
        }
        String spaces = stringBuilderSpaces.substring(0, length);
        readWriteLockStringBuilderSpaces.readLock().unlock();
        return spaces;
    }

    public static boolean isPosix() {
        if (indPosix == null) {
            indPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        return indPosix;
    }

    static {
        stringBuilderSpaces = new StringBuilder();
        readWriteLockStringBuilderSpaces = new ReentrantReadWriteLock();
    }
}

