/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.ModelFactory;
import org.azyva.dragom.model.config.impl.xml.XmlConfig;
import org.azyva.dragom.model.impl.simple.SimpleModel;
import org.azyva.dragom.util.Util;

public class DefaultModelFactory
implements ModelFactory {
    private static final String INIT_PROP_URL_MODEL = "URL_MODEL";
    private static Map<URL, Model> mapUrlXmlConfigModel = new HashMap<URL, Model>();
    private static final String INIT_PROPERTY_IND_IGNORE_CACHED_MODEL = "IND_IGNORE_CACHED_MODEL";

    public Model getModel(Properties propertiesInit) {
        Model model;
        String stringUrlXmlConfig = propertiesInit.getProperty(INIT_PROP_URL_MODEL);
        if (stringUrlXmlConfig == null) {
            throw new RuntimeException("Initialization property URL_MODEL is not defined.");
        }
        boolean indIgnoreCachedModel = Util.isNotNullAndTrue(propertiesInit.getProperty(INIT_PROPERTY_IND_IGNORE_CACHED_MODEL));
        if (indIgnoreCachedModel) {
            mapUrlXmlConfigModel.remove(stringUrlXmlConfig);
        }
        if ((model = mapUrlXmlConfigModel.get(stringUrlXmlConfig)) == null) {
            URL urlXmlConfig;
            try {
                urlXmlConfig = new URL(stringUrlXmlConfig);
            }
            catch (MalformedURLException mue1) {
                try {
                    urlXmlConfig = Paths.get(stringUrlXmlConfig, new String[0]).toUri().toURL();
                }
                catch (MalformedURLException mue2) {
                    throw new RuntimeException(mue1);
                }
            }
            XmlConfig xmlConfig = XmlConfig.load(urlXmlConfig);
            model = new SimpleModel(xmlConfig, propertiesInit);
            mapUrlXmlConfigModel.put(urlXmlConfig, model);
        }
        return model;
    }
}

