/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.VersionClassifierPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.Util;

public class SimpleVersionClassifierPluginImpl
extends ModulePluginAbstractImpl
implements VersionClassifierPlugin {
    private static final String MODEL_PROPERTY_STATIC_VERSION_PREFIX = "STATIC_VERSION_PREFIX";
    private String staticVersionPrefix;

    public SimpleVersionClassifierPluginImpl(Module module) {
        super(module);
        this.staticVersionPrefix = module.getProperty(MODEL_PROPERTY_STATIC_VERSION_PREFIX);
    }

    public int compare(Version version1, Version version2) {
        if (version1.equals((Object)version2)) {
            return 0;
        }
        if (version1.getVersionType() != version2.getVersionType()) {
            if (version1.getVersionType() == VersionType.STATIC) {
                return -1;
            }
            return 1;
        }
        if (version1.getVersionType() == VersionType.DYNAMIC) {
            return version1.getVersion().compareTo(version1.getVersion());
        }
        String stringVersion1 = version1.getVersion();
        String stringVersion2 = version2.getVersion();
        if (this.staticVersionPrefix != null) {
            boolean indVersion2Prefix;
            boolean indVersion1Prefix;
            if (version1.getVersion().startsWith(this.staticVersionPrefix)) {
                stringVersion1 = stringVersion1.substring(this.staticVersionPrefix.length());
                indVersion1Prefix = true;
            } else {
                indVersion1Prefix = false;
            }
            if (stringVersion2.startsWith(this.staticVersionPrefix)) {
                stringVersion2 = stringVersion2.substring(this.staticVersionPrefix.length());
                indVersion2Prefix = true;
            } else {
                indVersion2Prefix = false;
            }
            if (indVersion1Prefix != indVersion2Prefix) {
                if (indVersion1Prefix) {
                    return -1;
                }
                return 1;
            }
            if (!indVersion1Prefix) {
                return stringVersion1.compareTo(stringVersion2);
            }
        }
        String[] arrayVersion1Token = stringVersion1.split("((?<=\\.|-)|(?=\\.|-))");
        String[] arrayVersion2Token = stringVersion2.split("((?<=\\.|-)|(?=\\.|-))");
        int index = 0;
        block0: while (true) {
            if (index >= arrayVersion1Token.length) {
                if (index > arrayVersion2Token.length) {
                    return 0;
                }
                return 1;
            }
            if (index >= arrayVersion2Token.length) {
                return -1;
            }
            String token1 = arrayVersion1Token[index];
            String token2 = arrayVersion2Token[index];
            int compareResult = !Util.isDigits(token1) || !Util.isDigits(token2) ? token1.compareTo(token2) : new Integer(token1).compareTo(new Integer(token2));
            if (compareResult != 0) {
                return compareResult;
            }
            ++index;
            while (true) {
                if (index >= arrayVersion1Token.length) {
                    if (index > arrayVersion2Token.length) {
                        return 0;
                    }
                    return 1;
                }
                if (index >= arrayVersion2Token.length) {
                    return -1;
                }
                token1 = arrayVersion1Token[index];
                token2 = arrayVersion2Token[index];
                if (token1.equals(".")) {
                    if (!token2.equals(".")) {
                        return 1;
                    }
                } else if (token1.equals("-")) {
                    if (token2.equals(".")) {
                        return -1;
                    }
                    if (!token2.equals("-")) {
                        return 1;
                    }
                } else {
                    if (!token2.equals(".") && !token2.equals("-")) continue block0;
                    return -1;
                }
                ++index;
            }
            break;
        }
    }

    public String getEvolutionPath(Version version) {
        return null;
    }

    public int compareEvolutionPaths(String evolutionPath1, String evolutionPath2) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        SimpleVersionClassifierPluginImpl vc = new SimpleVersionClassifierPluginImpl(null);
        System.out.println("S/1.2.3, S/1.2.3: " + vc.compare(new Version("S/1.2.3"), new Version("S/1.2.3")));
        System.out.println("S/1.2.3, S/v-1.2.3: " + vc.compare(new Version("S/1.2.3"), new Version("S/v-1.2.3")));
        System.out.println("S/v-1.2.3, S/v-1.2.3: " + vc.compare(new Version("S/v-1.2.3"), new Version("S/v-1.2.3")));
        System.out.println("S/v-1.2.3, S/1.2.3: " + vc.compare(new Version("S/v-1.2.3"), new Version("S/1.2.3")));
        System.out.println("S/v-1.2.3, S/v-1.2.4: " + vc.compare(new Version("S/v-1.2.3"), new Version("S/v-1.2.4")));
        System.out.println("S/v-1.2.5, S/v-1.2.4: " + vc.compare(new Version("S/v-1.2.5"), new Version("S/v-1.2.4")));
        System.out.println("S/v-1.2.3, S/v-1.2-3: " + vc.compare(new Version("S/v-1.2.3"), new Version("S/v-1.2-3")));
        System.out.println("S/v-1.2-3, S/v-1.2.3: " + vc.compare(new Version("S/v-1.2-3"), new Version("S/v-1.2.3")));
        System.out.println("S/v-1.10, S/v-1.2.3: " + vc.compare(new Version("S/v-1.10"), new Version("S/v-1.2.3")));
        System.out.println("S/v-1..1, S/v-1.1: " + vc.compare(new Version("S/v-1..1"), new Version("S/v-1.1")));
        System.out.println("S/v-1.1, S/v-1..1: " + vc.compare(new Version("S/v-1.1"), new Version("S/v-1..1")));
        System.out.println("S/v-1.alpha.3, S/1.beta.3: " + vc.compare(new Version("S/v-1.alpha.3"), new Version("S/1.beta.3")));
    }
}

