/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectStaticVersionPlugin;
import org.azyva.dragom.model.plugin.VersionClassifierPlugin;
import org.azyva.dragom.model.plugin.impl.SelectStaticVersionPluginBaseImpl;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticSelectStaticVersionPluginImpl
extends SelectStaticVersionPluginBaseImpl
implements SelectStaticVersionPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SemanticSelectStaticVersionPluginImpl.class);
    private static final String MODEL_PROPERTY_SEMANTIC_VERSION_PREFIX = "SEMANTIC_VERSION_PREFIX";
    private static final String RUNTIME_PROPERTY_NEW_SEMANTIC_VERSION_TYPE = "NEW_SEMANTIC_VERSION_TYPE";
    private static final String RUNTIME_PROPERTY_CAN_REUSE_NEW_SEMANTIC_VERSION_TYPE = "CAN_REUSE_NEW_SEMANTIC_VERSION_TYPE";
    private static final String RUNTIME_PROPERTY_REUSE_NEW_SEMANTIC_VERSION_TYPE = "REUSE_NEW_SEMANTIC_VERSION_TYPE";
    private static final int DEFAULT_INITIAL_REVISION = 0;
    private static final int DEFAULT_REVISION_DECIMAL_POSITION_COUNT = 1;
    private static final String MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_SPECIFIED = "NEW_SEMANTIC_VERSION_TYPE_SPECIFIED";
    private static final String MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_AUTOMATICALLY_REUSED = "NEW_SEMANTIC_VERSION_TYPE_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_INPUT_NEW_SEMANTIC_VERSION_TYPE = "INPUT_NEW_SEMANTIC_VERSION_TYPE";
    private static final String MSG_PATTERN_KEY_INPUT_NEW_SEMANTIC_VERSION_TYPE_WITH_DEFAULT = "INPUT_NEW_SEMANTIC_VERSION_TYPE_WITH_DEFAULT";
    private static final String MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_INVALID = "NEW_SEMANTIC_VERSION_TYPE_INVALID";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_NEW_SEMANTIC_VERSION_TYPE = "AUTOMATICALLY_REUSE_NEW_SEMANTIC_VERSION_TYPE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SemanticSelectStaticVersionPluginImpl.class.getName() + "ResourceBundle");
    private String semanticVersionPrefix;

    public SemanticSelectStaticVersionPluginImpl(Module module) {
        super(module);
        this.setDefaultInitialRevision(0);
        this.setDefaultRevisionDecimalPositionCount(1);
        this.semanticVersionPrefix = module.getProperty(MODEL_PROPERTY_SEMANTIC_VERSION_PREFIX);
    }

    public Version selectStaticVersion(Version versionDynamic) {
        this.validateVersionDynamic(versionDynamic);
        Version versionNewStatic = this.handleSpecificStaticVersion(versionDynamic);
        if (versionNewStatic != null) {
            return versionNewStatic;
        }
        versionNewStatic = this.handleExistingEquivalentStaticVersion(versionDynamic);
        if (versionNewStatic != null) {
            return versionNewStatic;
        }
        Version versionStaticPrefix = this.handleSpecificStaticVersionPrefix(versionDynamic);
        if (versionStaticPrefix == null && (versionStaticPrefix = this.getStaticVersionPrefix(versionDynamic)) == null) {
            return null;
        }
        return this.getNewStaticVersionFromPrefix(this.getVersionLatestMatchingVersionStaticPrefix(this.getListVersionStaticForDynamicVersion(versionDynamic), versionStaticPrefix), versionStaticPrefix);
    }

    private Version getStaticVersionPrefix(Version versionDynamic) {
        NewSemanticVersionType newSemanticVersionType;
        String semanticVersionPrefixNotNull;
        int[] arraySemanticVersionComponentMax;
        Version versionStaticMax;
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        Module module = this.getModule();
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        VersionClassifierPlugin versionClassifierPlugin = (VersionClassifierPlugin)module.getNodePlugin(VersionClassifierPlugin.class, null);
        List<Version> listVersionStatic = scmPlugin.getListVersionStatic();
        Collections.sort(listVersionStatic, versionClassifierPlugin);
        logger.info("Sorted list of available static Version's for Module " + module + ": " + listVersionStatic);
        do {
            if (listVersionStatic.isEmpty()) {
                versionStaticMax = null;
                arraySemanticVersionComponentMax = null;
                continue;
            }
            versionStaticMax = (Version)listVersionStatic.get(listVersionStatic.size() - 1);
            logger.info("Largest available static Version for Module " + module + ": " + versionStaticMax);
            arraySemanticVersionComponentMax = this.getArraySemanticVersionComponent(versionStaticMax);
            if (arraySemanticVersionComponentMax != null) continue;
            logger.info("The largest available static Version " + versionStaticMax + " for Module " + module + " cannot be interpreted numerically and semantically. We do not use it and try the next one.");
            versionStaticMax = null;
            listVersionStatic.remove(listVersionStatic.size() - 1);
        } while (versionStaticMax == null && !listVersionStatic.isEmpty());
        String string = semanticVersionPrefixNotNull = this.semanticVersionPrefix == null ? "" : this.semanticVersionPrefix;
        if (versionStaticMax == null) {
            return new Version(VersionType.STATIC, semanticVersionPrefixNotNull + "1.0");
        }
        listVersionStatic = this.getListVersionStaticForDynamicVersion(versionDynamic);
        if (listVersionStatic.contains(versionStaticMax)) {
            return new Version(VersionType.STATIC, semanticVersionPrefixNotNull + String.valueOf(arraySemanticVersionComponentMax[0]) + '.' + String.valueOf(arraySemanticVersionComponentMax[1]));
        }
        String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_NEW_SEMANTIC_VERSION_TYPE);
        if (runtimeProperty != null) {
            newSemanticVersionType = NewSemanticVersionType.valueOf(runtimeProperty);
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_SPECIFIED), new Object[]{new ModuleVersion(module.getNodePath(), versionDynamic), newSemanticVersionType}));
        } else {
            NewSemanticVersionType newSemanticVersionTypeReuse;
            AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReuseNewSemanticVersionType = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_CAN_REUSE_NEW_SEMANTIC_VERSION_TYPE));
            runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_REUSE_NEW_SEMANTIC_VERSION_TYPE);
            if (runtimeProperty != null) {
                newSemanticVersionTypeReuse = NewSemanticVersionType.valueOf(runtimeProperty);
            } else {
                newSemanticVersionTypeReuse = null;
                if (alwaysNeverAskUserResponseCanReuseNewSemanticVersionType.isAlways()) {
                    alwaysNeverAskUserResponseCanReuseNewSemanticVersionType = AlwaysNeverAskUserResponse.YES_ASK;
                }
            }
            if (alwaysNeverAskUserResponseCanReuseNewSemanticVersionType.isAlways()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_AUTOMATICALLY_REUSED), new Object[]{new ModuleVersion(module.getNodePath(), versionDynamic), newSemanticVersionTypeReuse}));
                newSemanticVersionType = newSemanticVersionTypeReuse;
            } else {
                while (true) {
                    String stringNewSemanticVersionType;
                    block19: {
                        stringNewSemanticVersionType = newSemanticVersionTypeReuse == null ? userInteractionCallbackPlugin.getInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_NEW_SEMANTIC_VERSION_TYPE), new ModuleVersion(module.getNodePath(), versionDynamic), versionStaticMax)) : userInteractionCallbackPlugin.getInfoWithDefault(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_NEW_SEMANTIC_VERSION_TYPE_WITH_DEFAULT), new Object[]{new ModuleVersion(module.getNodePath(), versionDynamic), versionStaticMax, newSemanticVersionTypeReuse}), newSemanticVersionTypeReuse.toString());
                        stringNewSemanticVersionType = stringNewSemanticVersionType.toUpperCase().trim();
                        newSemanticVersionTypeReuse = null;
                        try {
                            newSemanticVersionTypeReuse = NewSemanticVersionType.valueOf(stringNewSemanticVersionType);
                        }
                        catch (IllegalArgumentException iae) {
                            if (stringNewSemanticVersionType.equals("A")) {
                                newSemanticVersionTypeReuse = NewSemanticVersionType.MAJOR;
                            }
                            if (!stringNewSemanticVersionType.equals("I")) break block19;
                            newSemanticVersionTypeReuse = NewSemanticVersionType.MINOR;
                        }
                    }
                    if (newSemanticVersionTypeReuse != null) break;
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NEW_SEMANTIC_VERSION_TYPE_INVALID), stringNewSemanticVersionType));
                }
                runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_REUSE_NEW_SEMANTIC_VERSION_TYPE, newSemanticVersionTypeReuse.toString());
                newSemanticVersionType = newSemanticVersionTypeReuse;
                Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_NEW_SEMANTIC_VERSION_TYPE, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_NEW_SEMANTIC_VERSION_TYPE), new Object[]{newSemanticVersionTypeReuse}));
            }
        }
        switch (newSemanticVersionType) {
            case MAJOR: {
                return new Version(VersionType.STATIC, semanticVersionPrefixNotNull + String.valueOf(arraySemanticVersionComponentMax[0] + 1) + ".0");
            }
            case MINOR: {
                return new Version(VersionType.STATIC, semanticVersionPrefixNotNull + String.valueOf(arraySemanticVersionComponentMax[0]) + '.' + String.valueOf(arraySemanticVersionComponentMax[1] + 1));
            }
        }
        throw new RuntimeException("Must not get here.");
    }

    private int[] getArraySemanticVersionComponent(Version versionStatic) {
        String[] arrayStringSemanticVersionComponent;
        if (versionStatic.getVersionType() != VersionType.STATIC) {
            throw new RuntimeException("Version + " + versionStatic + " must be static");
        }
        String version = versionStatic.getVersion();
        if (this.semanticVersionPrefix != null) {
            if (version.startsWith(this.semanticVersionPrefix)) {
                version = version.substring(this.semanticVersionPrefix.length());
            } else {
                logger.info("Static version " + versionStatic + " of module " + this.getModule() + " cannot be parsed into a semantic version because it does not start with the prefix " + this.semanticVersionPrefix + ". It is ignored.");
                return null;
            }
        }
        if ((arrayStringSemanticVersionComponent = version.split("\\.")).length < 2 || arrayStringSemanticVersionComponent.length > 3) {
            logger.info("Static version " + versionStatic + " of module " + this.getModule() + " cannot be parsed into a semantic version because it does not have 2 or 3 components. It is ignored.");
            return null;
        }
        int[] arraySemanticVersionComponent = new int[3];
        for (int i = 0; i < arrayStringSemanticVersionComponent.length; ++i) {
            try {
                arraySemanticVersionComponent[i] = Integer.parseInt(arrayStringSemanticVersionComponent[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.info("Static version " + versionStatic + " of module " + this.getModule() + " cannot be parsed into a semantic version because component " + (i + 1) + " cannot be parsed into an integer. It is ignored.");
                return null;
            }
        }
        return arraySemanticVersionComponent;
    }

    private static enum NewSemanticVersionType {
        MINOR,
        MAJOR;

    }
}

